#! /usr/bin/python3
import os
import sys
import generator_utils as gen

template = """// @{generatedby}@
/* ///////////////////////// The MPI Bugs Initiative ////////////////////////

  Origin: MBI

  Description: @{shortdesc}@
    @{longdesc}@

  Version of MPI: Conforms to MPI 1.1, does not require MPI 2 implementation

BEGIN_MPI_FEATURES
  P2P!basic: @{p2pfeature}@
  P2P!nonblocking: @{ip2pfeature}@
  P2P!persistent: Lacking
  COLL!basic: Lacking
  COLL!nonblocking: Lacking
  COLL!persistent: Lacking
  COLL!tools: Lacking
  RMA: Lacking
END_MPI_FEATURES

BEGIN_MBI_TESTS
  $ mpirun -np 2 ${EXE}
  | @{outcome}@
  | @{errormsg}@
END_MBI_TESTS
//////////////////////       End of MBI headers        /////////////////// */

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv) {
  int nprocs = -1;
  int rank = -1;
  MPI_Status sta;
  int src,dest;
  int stag=0, rtag=0;
  int buff_size = 1;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  printf("Hello from rank %d \\n", rank);

  if (nprocs < 2)
    printf("MBI ERROR: This test needs at least 2 processes to produce a bug!\\n");

  MPI_Comm newcom = MPI_COMM_WORLD;
  MPI_Datatype type = MPI_INT;

  @{init1a}@
  @{init1b}@
  @{init1c}@
  @{init2a}@
  @{init2b}@
  @{init2c}@

  if (rank == 0) {
    dest=1, src=1;
    @{operation1a}@ /* MBIERROR1 */
    @{operation1b}@
    @{operation1c}@
    @{fini1a}@
    @{fini1b}@
    @{fini1c}@
  }else if (rank == 1){
    dest=0, src=0;
    @{operation2a}@ /* MBIERROR2 */
    @{operation2b}@
    @{operation2c}@
    @{fini2a}@
    @{fini2b}@
    @{fini2c}@
  }
  @{free1a}@
  @{free1b}@
  @{free1c}@
  @{free2a}@
  @{free2b}@
  @{free2c}@

  MPI_Finalize();
  printf("Rank %d finished normally\\n", rank);
  return 0;
}
"""


for p in gen.probe:
    for s in gen.send + gen.isend:
        for r in gen.recv + gen.irecv:
            patterns = {}
            patterns = {'p':p, 's': s, 'r': r}
            patterns['generatedby'] = f'DO NOT EDIT: this file was generated by {os.path.basename(sys.argv[0])}. DO NOT EDIT.'
            patterns['p2pfeature'] = 'Yes' if s in gen.send or r in gen.recv else 'Lacking'
            patterns['ip2pfeature'] = 'Yes' if s in gen.isend or r in gen.irecv else 'Lacking'
            patterns['s'] = s
            patterns['r'] = r
            patterns['p'] = p
            patterns['init1a'] = gen.init[p]("1")
            patterns['init1b'] = gen.init[s]("1")
            patterns['init1c'] = gen.init[r]("2")
            patterns['init2a'] = gen.init[p]("1")
            patterns['init2b'] = gen.init[r]("3")
            patterns['init2c'] = gen.init[s]("4")
            patterns['fini1a'] = gen.fini[p]("1")
            patterns['fini1b'] = gen.fini[s]("1")
            patterns['fini1c'] = gen.fini[r]("2")
            patterns['fini2a'] = gen.fini[p]("1")
            patterns['fini2b'] = gen.fini[r]("3")
            patterns['fini2c'] = gen.fini[s]("4")
            patterns['free1a'] = gen.free[p]("1")
            patterns['free1b'] = gen.free[s]("1")
            patterns['free1c'] = gen.free[r]("2")
            patterns['free2a'] = gen.free[p]("1")
            patterns['free2b'] = gen.free[r]("3")
            patterns['free2c'] = gen.free[s]("4")
            patterns['operation1a'] = gen.operation[p]("1")
            patterns['operation1b'] = gen.operation[s]("1")
            patterns['operation1c'] = gen.operation[r]("2")
            patterns['operation2a'] = gen.operation[p]("1")
            patterns['operation2b'] = gen.operation[r]("3")
            patterns['operation2c'] = gen.operation[s]("4")

            # Generate the incorrect matching
            replace = patterns.copy()
            replace['shortdesc'] = 'MPI_Probe is called before MPI_Recv.'
            replace['longdesc'] = 'MPI_Probe is a blocking call that returns only after a matching message has been found. By calling MPI_Probe before MPI_Recv, a deadlock is created.'
            replace['outcome'] = 'ERROR: CallMatching'
            replace['errormsg'] = 'P2P mistmatch. @{p}@ at @{filename}@:@{line:MBIERROR1}@ and @{filename}@:@{line:MBIERROR2}@ are called before @{r}@.'
            gen.make_file(template, f'CallOrdering_{p}_{r}_{s}_nok.c', replace)

            # Generate a correct matching
            replace = patterns.copy()
            replace['shortdesc'] = 'Correct use of MPI_Probe.'
            replace['longdesc'] = 'Correct use of MPI_Probe.'
            replace['outcome'] = 'OK'
            replace['errormsg'] = 'OK'
            replace['operation1a'] = gen.operation[s]("1")
            replace['operation1b'] = gen.operation[p]("1")
            gen.make_file(template, f'CallOrdering_{p}_{r}_{s}_ok.c', replace)
