% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array-stream.R
\name{basic_array_stream}
\alias{basic_array_stream}
\title{Create ArrayStreams from batches}
\usage{
basic_array_stream(batches, schema = NULL, validate = TRUE)
}
\arguments{
\item{batches}{A \code{\link[=list]{list()}} of \link[=as_nanoarrow_array]{nanoarrow_array} objects
or objects that can be coerced via \code{\link[=as_nanoarrow_array]{as_nanoarrow_array()}}.}

\item{schema}{A \link[=as_nanoarrow_schema]{nanoarrow_schema} or \code{NULL} to guess
based on the first schema.}

\item{validate}{Use \code{FALSE} to skip the validation step (i.e., if you
know that the arrays are valid).}
}
\value{
An \link[=as_nanoarrow_array_stream]{nanoarrow_array_stream}
}
\description{
Create ArrayStreams from batches
}
\examples{
(stream <- basic_array_stream(list(data.frame(a = 1, b = 2))))
as.data.frame(stream$get_next())
stream$get_next()

}
