% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{CFtime-function}
\alias{CFtime-function}
\alias{CFtime}
\title{Create a CFTime object}
\usage{
CFtime(definition, calendar = "standard", offsets = NULL)
}
\arguments{
\item{definition}{A character string describing the time coordinate.}

\item{calendar}{A character string describing the calendar to use with the
time dimension definition string. Default value is "standard".}

\item{offsets}{Numeric or character vector, optional. When numeric, a vector
of offsets from the origin in the time series. When a character vector of
length 2 or more, timestamps in ISO8601 or UDUNITS format. When a character
string, a timestamp in ISO8601 or UDUNITS format and then a time series
will be generated with a separation between steps equal to the unit of
measure in the definition, inclusive of the definition timestamp. The unit
of measure of the offsets is defined by the time series definition.}
}
\value{
An instance of the \code{CFTime} class.
}
\description{
This function creates an instance of the \link{CFTime} class. The arguments to the
call are typically read from a CF-compliant data file with climatological
observations or climate projections. Specification of arguments can also be
made manually in a variety of combinations.
}
\examples{
CFtime("days since 1850-01-01", "julian", 0:364)

CFtime("hours since 2023-01-01", "360_day", "2023-01-30T23:00")
}
