/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: spr_unc_cha (SapphireRapids Uncore CHA)
 * Based on Intel JSON event table version   : 1.17
 * Based on Intel JSON event table published : 11/09/2023
 */

static const intel_x86_umask_t spr_unc_cha_bypass_cha_imc[]={
  { .uname   = "INTERMEDIATE",
    .udesc   = "Intermediate bypass Taken (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_TAKEN",
    .udesc   = "Not Taken (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TAKEN",
    .udesc   = "Taken (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_core_snp[]={
  { .uname   = "ANY_GTONE",
    .udesc   = "Any Cycle with Multiple Snoops (experimental)",
    .ucode   = 0xf200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY_ONE",
    .udesc   = "Any Single Snoop (experimental)",
    .ucode   = 0xf100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CORE_GTONE",
    .udesc   = "Multiple Core Requests (experimental)",
    .ucode   = 0x4200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CORE_ONE",
    .udesc   = "Single Core Requests (experimental)",
    .ucode   = 0x4100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EVICT_GTONE",
    .udesc   = "Multiple Eviction (experimental)",
    .ucode   = 0x8200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EVICT_ONE",
    .udesc   = "Single Eviction (experimental)",
    .ucode   = 0x8100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EXT_GTONE",
    .udesc   = "Multiple External Snoops (experimental)",
    .ucode   = 0x2200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EXT_ONE",
    .udesc   = "Single External Snoops (experimental)",
    .ucode   = 0x2100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_GTONE",
    .udesc   = "Multiple Snoop Targets from Remote (experimental)",
    .ucode   = 0x1200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_ONE",
    .udesc   = "Single Snoop Target from Remote (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_direct_go[]={
  { .uname   = "HA_SUPPRESS_DRD",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA_SUPPRESS_NO_D2C",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA_TOR_DEALLOC",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_direct_go_opc[]={
  { .uname   = "EXTCMP",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FAST_GO",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FAST_GO_PULL",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "GO",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "GO_PULL",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IDLE_DUE_SUPPRESS",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOP",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PULL",
    .udesc   = "Direct GO (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_dir_lookup[]={
  { .uname   = "NO_SNP",
    .udesc   = "Snoop Not Needed (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNP",
    .udesc   = "Snoop Needed (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_dir_update[]={
  { .uname   = "HA",
    .udesc   = "Directory Updated memory write from the HA pipe",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TOR",
    .udesc   = "Directory Updated memory write from TOR pipe",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_egress_ordering[]={
  { .uname   = "IV_SNOOPGO_DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_SNOOPGO_UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_hitme_hit[]={
  { .uname   = "EX_RDS",
    .udesc   = "Read request from a remote socket which hit in the HitMe Cache to a line In the E state (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SHARED_OWNREQ",
    .udesc   = "Shared hit and op is RdInvOwn, RdInv, Inv* (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBMTOE",
    .udesc   = "Op is WbMtoE (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBMTOI_OR_S",
    .udesc   = "Op is WbMtoI, WbPushMtoI, WbFlush, or WbMtoS (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_hitme_lookup[]={
  { .uname   = "READ",
    .udesc   = "Op is RdCode, RdData, RdDataMigratory, RdCur, RdInvOwn, RdInv, Inv* (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITE",
    .udesc   = "Op is WbMtoE, WbMtoI, WbPushMtoI, WbFlush, or WbMtoS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_hitme_miss[]={
  { .uname   = "NOTSHARED_RDINVOWN",
    .udesc   = "No SF/LLC HitS/F and op is RdInvOwn (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READ_OR_INV",
    .udesc   = "Op is RdCode, RdData, RdDataMigratory, RdCur, RdInv, Inv* (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SHARED_RDINVOWN",
    .udesc   = "SF/LLC HitS/F and op is RdInvOwn (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_hitme_update[]={
  { .uname   = "DEALLOCATE",
    .udesc   = "Deallocate HitME$ on Reads without RspFwdI* (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DEALLOCATE_RSPFWDI_LOC",
    .udesc   = "op is RspIFwd or RspIFwdWb for a local request (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RDINVOWN",
    .udesc   = "Update HitMe Cache on RdInvOwn even if not RspFwdI* (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWDI_REM",
    .udesc   = "op is RspIFwd or RspIFwdWb for a remote request (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SHARED",
    .udesc   = "Update HitMe Cache to SHARed (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_imc_reads_count[]={
  { .uname   = "NORMAL",
    .udesc   = "Normal priority reads issued to the memory controller from the CHA",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRIORITY",
    .udesc   = "ISOCH (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_imc_writes_count[]={
  { .uname   = "FULL",
    .udesc   = "CHA to iMC Full Line Writes Issued; Full Line Non-ISOCH",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FULL_PRIORITY",
    .udesc   = "ISOCH Full Line (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PARTIAL",
    .udesc   = "Partial Non-ISOCH (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PARTIAL_PRIORITY",
    .udesc   = "ISOCH Partial (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_llc_lookup[]={
  { .uname   = "ALL",
    .udesc   = "Cache and Snoop Filter Lookups; Any Request (experimental)",
    .ucode   = 0x1fff0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "ALL_REMOTE",
    .udesc   = "All transactions from Remote Agents (experimental)",
    .ucode   = 0x17e00000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY_F",
    .udesc   = "All Requests (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE",
    .udesc   = "CRd Requests (experimental)",
    .ucode   = 0x1bd00000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CODE_READ_F",
    .udesc   = "CRd Requests (experimental)",
    .ucode   = 0x1000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "COREPREF_OR_DMND_LOCAL_F",
    .udesc   = "Local non-prefetch requests (experimental)",
    .ucode   = 0x4000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_RD",
    .udesc   = "Cache and Snoop Filter Lookups; Data Read Request (experimental)",
    .ucode   = 0x1bc10000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_ALL",
    .udesc   = "Data Reads (experimental)",
    .ucode   = 0x1fc10000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_F",
    .udesc   = "Data Read Request (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_LOCAL",
    .udesc   = "Demand Data Reads, Core and LLC prefetches (experimental)",
    .ucode   = 0x8410000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DATA_READ_MISS",
    .udesc   = "Data Read Misses (experimental)",
    .ucode   = 0x1fc100000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "E_STATE",
    .udesc   = "E State (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "F_STATE",
    .udesc   = "F State (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLUSH_INV",
    .udesc   = "Flush or Invalidate Requests (experimental)",
    .ucode   = 0x1a440000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "FLUSH_OR_INV_F",
    .udesc   = "Flush (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "I_STATE",
    .udesc   = "I State (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLCPREF_LOCAL_F",
    .udesc   = "Local LLC prefetch requests (from LLC) (experimental)",
    .ucode   = 0x8000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCALLY_HOMED_ADDRESS",
    .udesc   = "Transactions homed locally (experimental)",
    .ucode   = 0xbdf0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_CODE",
    .udesc   = "CRd Requests that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x19d00000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_DATA_RD",
    .udesc   = "Cache and Snoop Filter Lookups; Data Read Request that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x19c10000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_DMND_CODE",
    .udesc   = "Demand CRd Requests that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x18500000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_DMND_DATA_RD",
    .udesc   = "Cache and Snoop Filter Lookups; Demand Data Reads that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x18410000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_DMND_RFO",
    .udesc   = "Demand RFO Requests that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x18480000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_F",
    .udesc   = "Transactions homed locally (experimental)",
    .ucode   = 0x80000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_FLUSH_INV",
    .udesc   = "Flush or Invalidate Requests that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x18440000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_LLC_PF",
    .udesc   = "Cache and Snoop Filter Lookups; Prefetch requests to the LLC that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x189d0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_PF",
    .udesc   = "Cache and Snoop Filter Lookups; Data Read Prefetches that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x199d0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_PF_CODE",
    .udesc   = "CRd Prefetches that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x19100000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_PF_DATA_RD",
    .udesc   = "Cache and Snoop Filter Lookups; Data Read Prefetches that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x19810000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_PF_RFO",
    .udesc   = "RFO Prefetches that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x19080000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_RFO",
    .udesc   = "RFO Requests that come from the local socket (usually the core) (experimental)",
    .ucode   = 0x19c80000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M_STATE",
    .udesc   = "M State (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MISS_ALL",
    .udesc   = "All Misses (experimental)",
    .ucode   = 0x1fe000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "OTHER_REQ_F",
    .udesc   = "Write Requests (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PREF_OR_DMND_REMOTE_F",
    .udesc   = "Remote non-snoop requests (experimental)",
    .ucode   = 0x20000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTELY_HOMED_ADDRESS",
    .udesc   = "Transactions homed remotely (experimental)",
    .ucode   = 0x15df0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_CODE",
    .udesc   = "CRd Requests that come from a Remote socket. (experimental)",
    .ucode   = 0x1a100000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_DATA_RD",
    .udesc   = "Cache and Snoop Filter Lookups; Data Read Requests that come from a Remote socket (experimental)",
    .ucode   = 0x1a010000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_F",
    .udesc   = "Transactions homed remotely (experimental)",
    .ucode   = 0x100000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_FLUSH_INV",
    .udesc   = "Flush or Invalidate requests that come from a Remote socket. (experimental)",
    .ucode   = 0x1a040000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_OTHER",
    .udesc   = "Filters Requests for those that write info into the cache that come from a remote socket (experimental)",
    .ucode   = 0x1a020000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_RFO",
    .udesc   = "RFO Requests that come from a Remote socket. (experimental)",
    .ucode   = 0x1a080000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_SNOOP_F",
    .udesc   = "Remote snoop requests (experimental)",
    .ucode   = 0x40000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_SNP",
    .udesc   = "Cache and Snoop Filter Lookups; Snoop Requests from a Remote Socket (experimental)",
    .ucode   = 0x1c190000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO",
    .udesc   = "RFO Requests (experimental)",
    .ucode   = 0x1bc80000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_F",
    .udesc   = "RFO Request Filter (experimental)",
    .ucode   = 0x800000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_LOCAL",
    .udesc   = "Locally HOMed RFOs - Demand and Prefetches (experimental)",
    .ucode   = 0x9c80000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S_STATE",
    .udesc   = "S State (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_E",
    .udesc   = "SnoopFilter - E State (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_H",
    .udesc   = "SnoopFilter - H State (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_S",
    .udesc   = "SnoopFilter - S State (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITE_LOCAL",
    .udesc   = "Writes (experimental)",
    .ucode   = 0x8420000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITE_REMOTE",
    .udesc   = "Remote Writes (experimental)",
    .ucode   = 0x17c20000ff00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_llc_victims[]={
  { .uname   = "E_STATE",
    .udesc   = "Lines in E state (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA",
    .udesc   = "IA traffic (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO",
    .udesc   = "IO traffic (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_E",
    .udesc   = "All LLC lines in E state that are victimized on a fill from an IO device (experimental)",
    .ucode   = 0x1200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_FS",
    .udesc   = "All LLC lines in F or S state that are victimized on a fill from an IO device (experimental)",
    .ucode   = 0x1c00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_M",
    .udesc   = "All LLC lines in M state that are victimized on a fill from an IO device (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MESF",
    .udesc   = "All LLC lines in any state that are victimized on a fill from an IO device (experimental)",
    .ucode   = 0x1f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_ALL",
    .udesc   = "Lines Victimized; Local - All Lines (experimental)",
    .ucode   = 0x2000000f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_E",
    .udesc   = "Lines Victimized (experimental)",
    .ucode   = 0x2000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_M",
    .udesc   = "Lines Victimized (experimental)",
    .ucode   = 0x2000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_ONLY",
    .udesc   = "Local Only (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_S",
    .udesc   = "Lines Victimized (experimental)",
    .ucode   = 0x2000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M_STATE",
    .udesc   = "Lines in M state (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_ALL",
    .udesc   = "Lines Victimized; Remote - All Lines (experimental)",
    .ucode   = 0x8000000f00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_E",
    .udesc   = "Lines Victimized (experimental)",
    .ucode   = 0x8000000200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_M",
    .udesc   = "Lines Victimized (experimental)",
    .ucode   = 0x8000000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_ONLY",
    .udesc   = "Remote Only (experimental)",
    .ucode   = 0x8000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_S",
    .udesc   = "Lines Victimized (experimental)",
    .ucode   = 0x8000000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "S_STATE",
    .udesc   = "Lines in S State (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TOTAL_E",
    .udesc   = "All LLC lines in E state that are victimized on a fill (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TOTAL_M",
    .udesc   = "All LLC lines in M state that are victimized on a fill (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TOTAL_S",
    .udesc   = "All LLC lines in S state that are victimized on a fill (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_misc[]={
  { .uname   = "CV0_PREF_MISS",
    .udesc   = "CV0 Prefetch Miss (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CV0_PREF_VIC",
    .udesc   = "CV0 Prefetch Victim (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_HIT_S",
    .udesc   = "Number of times that an RFO hit in S state. (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPI_WAS_FSE",
    .udesc   = "Silent Snoop Eviction (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WC_ALIASING",
    .udesc   = "Write Combining Aliasing (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_osb[]={
  { .uname   = "LOCAL_INVITOE",
    .udesc   = "Local InvItoE (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_READ",
    .udesc   = "Local Rd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "OFF_PWRHEURISTIC",
    .udesc   = "Off (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_READ",
    .udesc   = "Remote Rd (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_READINVITOE",
    .udesc   = "Remote Rd InvItoE (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RFO_HITS_SNP_BCAST",
    .udesc   = "RFO HitS Snoop Broadcast (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_pmm_memmode_nm_invitox[]={
  { .uname   = "LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SETCONFLICT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_pmm_memmode_nm_setconflicts[]={
  { .uname   = "LLC",
    .udesc   = "Memory Mode related events; Counts the number of times CHA saw a Near Memory set conflict in SF/LLC (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF",
    .udesc   = "Memory Mode related events; Counts the number of times CHA saw a Near memory set conflict in SF/LLC (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TOR",
    .udesc   = "Memory Mode related events; Counts the number of times CHA saw a Near Memory set conflict in TOR (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_pmm_memmode_nm_setconflicts2[]={
  { .uname   = "IODC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEMWR",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEMWRNI",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_pmm_qos[]={
  { .uname   = "DDR4_FAST_INSERT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REJ_IRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOWTORQ_SKIP",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SLOW_INSERT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "THROTTLE",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "THROTTLE_IRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "THROTTLE_PRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_pmm_qos_occupancy[]={
  { .uname   = "DDR_FAST_FIFO",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DDR_SLOW_FIFO",
    .udesc   = "Number of SLOW TOR Request inserted to ha_pmm_tor_req_fifo (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_requests[]={
  { .uname   = "INVITOE",
    .udesc   = "Requests for exclusive ownership of a cache line without receiving data (experimental)",
    .ucode   = 0x3000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "INVITOE_LOCAL",
    .udesc   = "Local requests for exclusive ownership of a cache line  without receiving data",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "INVITOE_REMOTE",
    .udesc   = "Remote requests for exclusive ownership of a cache line  without receiving data",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READS",
    .udesc   = "Read requests made into the CHA",
    .ucode   = 0x0300ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READS_LOCAL",
    .udesc   = "Read requests from a unit on this socket",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "READS_REMOTE",
    .udesc   = "Read requests from a remote socket",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITES",
    .udesc   = "Write requests made into the CHA",
    .ucode   = 0x0c00ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITES_LOCAL",
    .udesc   = "Write Requests from a unit on this socket",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WRITES_REMOTE",
    .udesc   = "Read and Write Requests; Writes Remote",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_inserts[]={
  { .uname   = "IPQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ_REJ",
    .udesc   = "IRQ Rejected (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ_REJ",
    .udesc   = "PRQ Rejected (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_irq0_reject[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_irq1_reject[]={
  { .uname   = "ALLOW_SNP",
    .udesc   = "Allow Snoop (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY0",
    .udesc   = "ANY0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "HA (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_OR_SF_WAY",
    .udesc   = "LLC or SF Way (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_VICTIM",
    .udesc   = "LLC Victim (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PA_MATCH",
    .udesc   = "Ingress (from CMS) Request Queue Rejects; PhyAddr Match (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_VICTIM",
    .udesc   = "SF Victim (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VICTIM",
    .udesc   = "Victim (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_ismq0_retry[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_ismq1_retry[]={
  { .uname   = "ANY0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_occupancy[]={
  { .uname   = "IPQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_other1_retry[]={
  { .uname   = "ALLOW_SNP",
    .udesc   = "Allow Snoop (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_OR_SF_WAY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_VICTIM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_VICTIM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VICTIM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_prq0_reject[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_req_q1_retry[]={
  { .uname   = "ALLOW_SNP",
    .udesc   = "Allow Snoop (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY0",
    .udesc   = "ANY0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "HA (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_OR_SF_WAY",
    .udesc   = "LLC OR SF Way (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_VICTIM",
    .udesc   = "LLC Victim (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_VICTIM",
    .udesc   = "SF Victim (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VICTIM",
    .udesc   = "Victim (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_rrq0_reject[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_wbq0_reject[]={
  { .uname   = "AD_REQ_VN0",
    .udesc   = "AD REQ on VN0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_RSP_VN0",
    .udesc   = "AD RSP on VN0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_NON_UPI",
    .udesc   = "Non UPI AK Request (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCB_VN0",
    .udesc   = "BL NCB on VN0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_NCS_VN0",
    .udesc   = "BL NCS on VN0 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_RSP_VN0",
    .udesc   = "BL RSP on VN0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_WB_VN0",
    .udesc   = "BL WB on VN0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_NON_UPI",
    .udesc   = "Non UPI IV Request (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_rxc_wbq1_reject[]={
  { .uname   = "ALLOW_SNP",
    .udesc   = "Allow Snoop (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ANY0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HA",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_OR_SF_WAY",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LLC_VICTIM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SF_VICTIM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VICTIM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_snoops_sent[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "BCST_LOCAL",
    .udesc   = "Broadcast snoop for Local Requests (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BCST_REMOTE",
    .udesc   = "Broadcast snoops for Remote Requests (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DIRECT_LOCAL",
    .udesc   = "Directed snoops for Local Requests (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DIRECT_REMOTE",
    .udesc   = "Directed snoops for Remote Requests (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL",
    .udesc   = "Broadcast or directed Snoops sent for Local Requests (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE",
    .udesc   = "Broadcast or directed Snoops sent for Remote Requests (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_snoop_resp[]={
  { .uname   = "RSPCNFLCT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWDWB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPI",
    .udesc   = "RspI Snoop Responses Received (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPIFWD",
    .udesc   = "RspIFwd Snoop Responses Received (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPS",
    .udesc   = "RspS Snoop Responses Received (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPSFWD",
    .udesc   = "RspSFwd Snoop Responses Received (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPWB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_snoop_resp_local[]={
  { .uname   = "RSPCNFLCT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPFWDWB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPI",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPIFWD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPSFWD",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPWB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_snoop_rsp_misc[]={
  { .uname   = "MTOI_RSPDATAM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MTOI_RSPIFWDM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PULLDATAPTL_HITLLC",
    .udesc   = "Pull Data Partial - Hit LLC (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PULLDATAPTL_HITSF",
    .udesc   = "Pull Data Partial - Hit SF (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPIFWDMPTL_HITLLC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RSPIFWDMPTL_HITSF",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_tor_inserts[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0xc001ff0000ff00ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "DDR",
    .udesc   = "DDR Access (experimental)",
    .ucode   = 0x400000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "EVICT",
    .udesc   = "SF/LLC Evictions (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HIT",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x100000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA",
    .udesc   = "All from Local IA",
    .ucode   = 0xc001ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CLFLUSH",
    .udesc   = "CLFlush from Local IA",
    .ucode   = 0xc8c7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CLFLUSHOPT",
    .udesc   = "CLFlushOpt from Local IA (experimental)",
    .ucode   = 0xc8d7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CRD",
    .udesc   = "CRd from local IA",
    .ucode   = 0xc80fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_CRD_PREF",
    .udesc   = "Rd Pref from local IA (experimental)",
    .ucode   = 0xc88fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD",
    .udesc   = "Rd from local IA",
    .ucode   = 0xc817ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRDPTE",
    .udesc   = "DRd PTEs issued by iA Cores (experimental)",
    .ucode   = 0xc837ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_OPT",
    .udesc   = "DRd Opt from local IA (experimental)",
    .ucode   = 0xc827ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_OPT_PREF",
    .udesc   = "DRd Opt Pref from local IA (experimental)",
    .ucode   = 0xc8a7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_DRD_PREF",
    .udesc   = "DRd Pref from local IA",
    .ucode   = 0xc897ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT",
    .udesc   = "Hits from Local IA",
    .ucode   = 0xc001fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_CRD",
    .udesc   = "CRd hits from local IA",
    .ucode   = 0xc80ffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_CRD_PREF",
    .udesc   = "CRd Pref hits from local IA",
    .ucode   = 0xc88ffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_CXL_ACC",
    .udesc   = "All requests issued from IA cores to CXL accelerator memory regions that hit the LLC. (experimental)",
    .ucode   = 0x10c0018100000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10c0008100000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD",
    .udesc   = "DRd hits from local IA",
    .ucode   = 0xc817fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRDPTE",
    .udesc   = "DRd PTEs issued by iA Cores that Hit the LLC (experimental)",
    .ucode   = 0xc837fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_OPT",
    .udesc   = "DRd Opt hits from local IA (experimental)",
    .ucode   = 0xc827fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_OPT_PREF",
    .udesc   = "DRd Opt Pref hits from local IA (experimental)",
    .ucode   = 0xc8a7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_DRD_PREF",
    .udesc   = "DRd Pref hits from local IA",
    .ucode   = 0xc897fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_ITOM",
    .udesc   = "ItoMs issued by iA Cores that Hit LLC (experimental)",
    .ucode   = 0xcc47fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFCODE",
    .udesc   = "LLCPrefCode hits from local IA (experimental)",
    .ucode   = 0xcccffd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFDATA",
    .udesc   = "LLCPrefData hits from local IA (experimental)",
    .ucode   = 0xccd7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_LLCPREFRFO",
    .udesc   = "LLCPrefRFO hits from local IA",
    .ucode   = 0xccc7fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_RFO",
    .udesc   = "RFO hits from local IA",
    .ucode   = 0xc807fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_HIT_RFO_PREF",
    .udesc   = "RFO Pref hits from local IA",
    .ucode   = 0xc887fd00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_ITOM",
    .udesc   = "ItoM from Local IA (experimental)",
    .ucode   = 0xcc47ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears issued by iA Cores (experimental)",
    .ucode   = 0xcd47ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFCODE",
    .udesc   = "LLCPrefCode from local IA (experimental)",
    .ucode   = 0xcccfff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFDATA",
    .udesc   = "LLCPrefData from local IA",
    .ucode   = 0xccd7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_LLCPREFRFO",
    .udesc   = "LLCPrefRFO from local IA",
    .ucode   = 0xccc7ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS",
    .udesc   = "misses from Local IA",
    .ucode   = 0xc001fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD",
    .udesc   = "CRd misses from local IA",
    .ucode   = 0xc80ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRDMORPH_CXL_ACC",
    .udesc   = "CRds and equivalent opcodes issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10c80b8200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_LOCAL",
    .udesc   = "CRd issued by iA Cores that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc80efe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF",
    .udesc   = "CRd Pref misses from local IA",
    .ucode   = 0xc88ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF_LOCAL",
    .udesc   = "CRd_Prefs issued by iA Cores that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc88efe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_PREF_REMOTE",
    .udesc   = "CRd_Prefs issued by iA Cores that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc88f7e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CRD_REMOTE",
    .udesc   = "CRd issued by iA Cores that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc80f7e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CXL_ACC",
    .udesc   = "All requests issued from IA cores to CXL accelerator memory regions that miss the LLC. (experimental)",
    .ucode   = 0x10c0018200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10c0008200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD",
    .udesc   = "DRd misses from local IA",
    .ucode   = 0xc817fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRDMORPH_CXL_ACC",
    .udesc   = "DRds and equivalent opcodes issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10c8138200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRDPTE",
    .udesc   = "DRd PTEs issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc837fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_CXL_ACC",
    .udesc   = "DRds issued from an IA core which miss the L3 and target memory in a CXL type 2 memory expander card. (experimental)",
    .ucode   = 0x10c8178200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10c8168200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_DDR",
    .udesc   = "DRds issued by IA Cores targeting DDR Mem that Missed the LLC",
    .ucode   = 0xc8178600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL",
    .udesc   = "DRd misses from local IA targeting local memory",
    .ucode   = 0xc816fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL_DDR",
    .udesc   = "DRds issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed locally",
    .ucode   = 0xc8168600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_LOCAL_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed locally",
    .ucode   = 0xc8168a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_OPT",
    .udesc   = "DRd Opt misses from local IA (experimental)",
    .ucode   = 0xc827fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_OPT_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10c8268200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_OPT_PREF",
    .udesc   = "DRd Opt Pref misses from local IA (experimental)",
    .ucode   = 0xc8a7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_OPT_PREF_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10c8a68200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC",
    .ucode   = 0xc8178a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF",
    .udesc   = "DRd Pref misses from local IA",
    .ucode   = 0xc897fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_CXL_ACC",
    .udesc   = "L2 data prefetches issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10c8978200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10c8968200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC (experimental)",
    .ucode   = 0xc8978600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL",
    .udesc   = "DRd Pref misses from local IA targeting local memory",
    .ucode   = 0xc896fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8968600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_LOCAL_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8968a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC (experimental)",
    .ucode   = 0xc8978a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE",
    .udesc   = "DRd Pref misses from local IA targeting remote memory",
    .ucode   = 0xc8977e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE_DDR",
    .udesc   = "DRd_Prefs issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8970600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_PREF_REMOTE_PMM",
    .udesc   = "DRd_Prefs issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8970a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE",
    .udesc   = "DRd misses from local IA targeting remote memory",
    .ucode   = 0xc8177e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE_DDR",
    .udesc   = "DRds issued by iA Cores targeting DDR Mem that Missed the LLC - HOMed remotely",
    .ucode   = 0xc8170600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_DRD_REMOTE_PMM",
    .udesc   = "DRds issued by iA Cores targeting PMM Mem that Missed the LLC - HOMed remotely",
    .ucode   = 0xc8170a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_ITOM",
    .udesc   = "ItoMs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xcc47fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFCODE",
    .udesc   = "LLCPrefCode misses from local IA (experimental)",
    .ucode   = 0xcccffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFCODE_CXL_ACC",
    .udesc   = "LLC Prefetch Code transactions issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10cccf8200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFDATA",
    .udesc   = "LLCPrefData misses from local IA",
    .ucode   = 0xccd7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFDATA_CXL_ACC",
    .udesc   = "LLC data prefetches issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10ccd78200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFDATA_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10ccd68200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFRFO",
    .udesc   = "LLCPrefRFO misses from local IA",
    .ucode   = 0xccc7fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFRFO_CXL_ACC",
    .udesc   = "L2 RFO prefetches issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10c8878200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LLCPREFRFO_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10c8868200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8668600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc8668a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc86e8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_LOCAL_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC - HOMed locally (experimental)",
    .ucode   = 0xc86e8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8670600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc8670a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc86f0600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_REMOTE_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC - HOMed remotely (experimental)",
    .ucode   = 0xc86f0a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO",
    .udesc   = "RFO misses from local IA",
    .ucode   = 0xc807fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFOMORPH_CXL_ACC",
    .udesc   = "RFO and L2 RFO prefetches issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10c8038200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_CXL_ACC",
    .udesc   = "RFOs issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10c8078200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10c8068200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_LOCAL",
    .udesc   = "RFO misses from local IA",
    .ucode   = 0xc806fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF",
    .udesc   = "RFO pref misses from local IA",
    .ucode   = 0xc887fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF_CXL_ACC",
    .udesc   = "LLC RFO prefetches issued from an IA core which miss the L3 and target memory in a CXL type 2 accelerator. (experimental)",
    .ucode   = 0x10ccc78200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF_CXL_ACC_LOCAL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x10ccc68200000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF_LOCAL",
    .udesc   = "RFO prefetch misses from local IA",
    .ucode   = 0xc886fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_PREF_REMOTE",
    .udesc   = "RFO prefetch misses from local IA",
    .ucode   = 0xc8877e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_RFO_REMOTE",
    .udesc   = "RFO misses from local IA",
    .ucode   = 0xc8077e00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_UCRDF",
    .udesc   = "UCRdFs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xc877de00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL",
    .udesc   = "WCiLs issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc86ffe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF",
    .udesc   = "WCiLF issued by iA Cores that Missed the LLC (experimental)",
    .ucode   = 0xc867fe00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF_DDR",
    .udesc   = "WCiLFs issued by iA Cores targeting DDR that missed the LLC (experimental)",
    .ucode   = 0xc8678600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCILF_PMM",
    .udesc   = "WCiLFs issued by iA Cores targeting PMM that missed the LLC (experimental)",
    .ucode   = 0xc8678a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL_DDR",
    .udesc   = "WCiLs issued by iA Cores targeting DDR that missed the LLC (experimental)",
    .ucode   = 0xc86f8600000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WCIL_PMM",
    .udesc   = "WCiLs issued by iA Cores targeting PMM that missed the LLC (experimental)",
    .ucode   = 0xc86f8a00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_MISS_WIL",
    .udesc   = "WiLs issued by iA Cores that Missed LLC (experimental)",
    .ucode   = 0xc87fde00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_RFO",
    .udesc   = "RFO from local IA",
    .ucode   = 0xc807ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_RFO_PREF",
    .udesc   = "RFO pref from local IA",
    .ucode   = 0xc887ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_SPECITOM",
    .udesc   = "SpecItoM from Local IA",
    .ucode   = 0xcc57ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBEFTOE",
    .udesc   = "WBEFtoEs issued by an IA Core.  Non Modified Write Backs (experimental)",
    .ucode   = 0xcc3fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBEFTOI",
    .udesc   = "WBEFtoEs issued by an IA Core.  Non Modified Write Backs (experimental)",
    .ucode   = 0xcc37ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBMTOE",
    .udesc   = "WBEFtoEs issued by an IA Core.  Non Modified Write Backs (experimental)",
    .ucode   = 0xcc2fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBMTOI",
    .udesc   = "WbMtoIs issued by an iA Cores. Modified Write Backs (experimental)",
    .ucode   = 0xcc27ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WBSTOI",
    .udesc   = "WBEFtoEs issued by an IA Core.  Non Modified Write Backs (experimental)",
    .ucode   = 0xcc67ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WCIL",
    .udesc   = "WCiLs issued by iA Cores (experimental)",
    .ucode   = 0xc86fff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IA_WCILF",
    .udesc   = "WCiLF issued by iA Cores (experimental)",
    .ucode   = 0xc867ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO",
    .udesc   = "All from local IO",
    .ucode   = 0xc001ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_CLFLUSH",
    .udesc   = "CLFlushes issued by IO Devices",
    .ucode   = 0xc8c3ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT",
    .udesc   = "Hits from local IO",
    .ucode   = 0xc001fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_ITOM",
    .udesc   = "ItoM hits from local IO",
    .ucode   = 0xcc43fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices that hit the LLC",
    .ucode   = 0xcd43fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_PCIRDCUR",
    .udesc   = "RdCur and FsRdCur hits from local IO",
    .ucode   = 0xc8f3fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_HIT_RFO",
    .udesc   = "RFO hits from local IO",
    .ucode   = 0xc803fd00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOM",
    .udesc   = "ItoM from local IO",
    .ucode   = 0xcc43ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears from IO devices.",
    .ucode   = 0xcd43ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS",
    .udesc   = "Misses from local IO",
    .ucode   = 0xc001fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_ITOM",
    .udesc   = "ItoM misses from local IO",
    .ucode   = 0xcc43fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_ITOMCACHENEAR",
    .udesc   = "ItoMCacheNears, indicating a partial write request, from IO Devices that missed the LLC",
    .ucode   = 0xcd43fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_PCIRDCUR",
    .udesc   = "RdCur and FsRdCur misses from local IO",
    .ucode   = 0xc8f3fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_MISS_RFO",
    .udesc   = "RFO misses from local IO",
    .ucode   = 0xc803fe00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_PCIRDCUR",
    .udesc   = "RdCur from local IO",
    .ucode   = 0xc8f3ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_RFO",
    .udesc   = "RFO from local IO",
    .ucode   = 0xc803ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IO_WBMTOI",
    .udesc   = "WbMtoIs issued by IO Devices",
    .ucode   = 0xcc23ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IPQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ_IA",
    .udesc   = "IRQ - iA (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IRQ_NON_IA",
    .udesc   = "IRQ - Non iA (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "ISOC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x200000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_TGT",
    .udesc   = "Local Targets (experimental)",
    .ucode   = 0x8000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_ALL",
    .udesc   = "All from Local iA and IO (experimental)",
    .ucode   = 0xc000ff00000500ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_IA",
    .udesc   = "All from Local iA (experimental)",
    .ucode   = 0xc000ff00000100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOC_IO",
    .udesc   = "All from Local IO (experimental)",
    .ucode   = 0xc000ff00000400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MISS",
    .udesc   = "Just Misses (experimental)",
    .ucode   = 0x200000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MMCFG",
    .udesc   = "MMCFG Access (experimental)",
    .ucode   = 0x2000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MMIO",
    .udesc   = "MMIO Access (experimental)",
    .ucode   = 0x4000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NEARMEM",
    .udesc   = "Near Memory (experimental)",
    .ucode   = 0x40000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NONCOH",
    .udesc   = "Non Coherent (experimental)",
    .ucode   = 0x100000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NOT_NEARMEM",
    .udesc   = "Not Near Memory (experimental)",
    .ucode   = 0x80000000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM",
    .udesc   = "PMM Access (experimental)",
    .ucode   = 0x800000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ_IOSF",
    .udesc   = "PRQ - IOSF (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ_NON_IOSF",
    .udesc   = "PRQ - Non IOSF (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_TGT",
    .udesc   = "Remote Targets (experimental)",
    .ucode   = 0x10000000000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REM_ALL",
    .udesc   = "All from Remote (experimental)",
    .ucode   = 0xc001ff0000c800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REM_SNPS",
    .udesc   = "All Snoops from Remote (experimental)",
    .ucode   = 0xc001ff00000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SNPS_FROM_REM",
    .udesc   = "All Snoops from Remote (experimental)",
    .ucode   = 0xc001ff00000800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "WBQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_wb_push_mtoi[]={
  { .uname   = "LLC",
    .udesc   = "Pushed to LLC (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MEM",
    .udesc   = "Pushed to Memory (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_write_no_credits[]={
  { .uname   = "MC0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC2",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC3",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC4",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MC5",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t spr_unc_cha_xpt_pref[]={
  { .uname   = "DROP0_CONFLICT",
    .udesc   = "Dropped (on 0?) - Conflict (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DROP0_NOCRD",
    .udesc   = "Dropped (on 0?) - No Credits (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DROP1_CONFLICT",
    .udesc   = "Dropped (on 1?) - Conflict (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DROP1_NOCRD",
    .udesc   = "Dropped (on 1?) - No Credits (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SENT0",
    .udesc   = "Sent (on 0?) (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "SENT1",
    .udesc   = "Sent (on 1?) (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_spr_unc_cha_pe[]={
  { .name   = "UNC_CHA_BYPASS_CHA_IMC",
    .desc   = "CHA to iMC Bypass",
    .code   = 0x0057,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_bypass_cha_imc),
    .umasks = spr_unc_cha_bypass_cha_imc,
  },
  { .name   = "UNC_CHA_CLOCKTICKS",
    .desc   = "Clockticks",
    .code   = 0x0001,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_CHA_CMS_CLOCKTICKS",
    .desc   = "CMS Clockticks",
    .code   = 0x00c0,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_CHA_CORE_SNP",
    .desc   = "Core Cross Snoops Issued",
    .code   = 0x0033,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_core_snp),
    .umasks = spr_unc_cha_core_snp,
  },
  { .name   = "UNC_CHA_DIRECT_GO",
    .desc   = "Direct GO",
    .code   = 0x006e,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_direct_go),
    .umasks = spr_unc_cha_direct_go,
  },
  { .name   = "UNC_CHA_DIRECT_GO_OPC",
    .desc   = "Direct GO opcodes",
    .code   = 0x006d,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_direct_go_opc),
    .umasks = spr_unc_cha_direct_go_opc,
  },
  { .name   = "UNC_CHA_DIR_LOOKUP",
    .desc   = "Multi-socket cacheline Directory state lookups",
    .code   = 0x0053,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_dir_lookup),
    .umasks = spr_unc_cha_dir_lookup,
  },
  { .name   = "UNC_CHA_DIR_UPDATE",
    .desc   = "Multi-socket cacheline Directory state updates",
    .code   = 0x0054,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_dir_update),
    .umasks = spr_unc_cha_dir_update,
  },
  { .name   = "UNC_CHA_EGRESS_ORDERING",
    .desc   = "Egress Blocking due to Ordering requirements",
    .code   = 0x00ba,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_egress_ordering),
    .umasks = spr_unc_cha_egress_ordering,
  },
  { .name   = "UNC_CHA_HITME_HIT",
    .desc   = "HitMe Cache hits",
    .code   = 0x005f,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_hitme_hit),
    .umasks = spr_unc_cha_hitme_hit,
  },
  { .name   = "UNC_CHA_HITME_LOOKUP",
    .desc   = "HitMe Cache accesses",
    .code   = 0x005e,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_hitme_lookup),
    .umasks = spr_unc_cha_hitme_lookup,
  },
  { .name   = "UNC_CHA_HITME_MISS",
    .desc   = "HitMe Cache misses",
    .code   = 0x0060,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_hitme_miss),
    .umasks = spr_unc_cha_hitme_miss,
  },
  { .name   = "UNC_CHA_HITME_UPDATE",
    .desc   = "HitMe Cache updates",
    .code   = 0x0061,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_hitme_update),
    .umasks = spr_unc_cha_hitme_update,
  },
  { .name   = "UNC_CHA_IMC_READS_COUNT",
    .desc   = "Memory controller reads from CHA",
    .code   = 0x0059,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_imc_reads_count),
    .umasks = spr_unc_cha_imc_reads_count,
  },
  { .name   = "UNC_CHA_IMC_WRITES_COUNT",
    .desc   = "Memory controller writes from CHA",
    .code   = 0x005b,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_imc_writes_count),
    .umasks = spr_unc_cha_imc_writes_count,
  },
  { .name   = "UNC_CHA_LLC_LOOKUP",
    .desc   = "LLC Cache Lookups",
    .code   = 0x0034,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_llc_lookup),
    .umasks = spr_unc_cha_llc_lookup,
  },
  { .name   = "UNC_CHA_LLC_VICTIMS",
    .desc   = "LLC cache victims",
    .code   = 0x0037,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_llc_victims),
    .umasks = spr_unc_cha_llc_victims,
  },
  { .name   = "UNC_CHA_MISC",
    .desc   = "Miscellaneous",
    .code   = 0x0039,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_misc),
    .umasks = spr_unc_cha_misc,
  },
  { .name   = "UNC_CHA_OSB",
    .desc   = "OSB",
    .code   = 0x0055,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_osb),
    .umasks = spr_unc_cha_osb,
  },
  { .name   = "UNC_CHA_PMM_MEMMODE_NM_INVITOX",
    .desc   = "TBD",
    .code   = 0x0065,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_pmm_memmode_nm_invitox),
    .umasks = spr_unc_cha_pmm_memmode_nm_invitox,
  },
  { .name   = "UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS",
    .desc   = "Memory Modes",
    .code   = 0x0064,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_pmm_memmode_nm_setconflicts),
    .umasks = spr_unc_cha_pmm_memmode_nm_setconflicts,
  },
  { .name   = "UNC_CHA_PMM_MEMMODE_NM_SETCONFLICTS2",
    .desc   = "TBD",
    .code   = 0x0070,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_pmm_memmode_nm_setconflicts2),
    .umasks = spr_unc_cha_pmm_memmode_nm_setconflicts2,
  },
  { .name   = "UNC_CHA_PMM_QOS",
    .desc   = "TBD",
    .code   = 0x0066,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_pmm_qos),
    .umasks = spr_unc_cha_pmm_qos,
  },
  { .name   = "UNC_CHA_PMM_QOS_OCCUPANCY",
    .desc   = "TBD",
    .code   = 0x0067,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_pmm_qos_occupancy),
    .umasks = spr_unc_cha_pmm_qos_occupancy,
  },
  { .name   = "UNC_CHA_READ_NO_CREDITS",
    .desc   = "CHA iMC CHNx READ Credits Empty",
    .code   = 0x0058,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_write_no_credits), /* shared */
    .umasks = spr_unc_cha_write_no_credits,
  },
  { .name   = "UNC_CHA_REQUESTS",
    .desc   = "Requests",
    .code   = 0x0050,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_requests),
    .umasks = spr_unc_cha_requests,
  },
  { .name   = "UNC_CHA_RxC_INSERTS",
    .desc   = "Ingress (from CMS) Allocations",
    .code   = 0x0013,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_inserts),
    .umasks = spr_unc_cha_rxc_inserts,
  },
  { .name   = "UNC_CHA_RxC_IPQ0_REJECT",
    .desc   = "IPQ Requests (from CMS) Rejected - Set 0",
    .code   = 0x0022,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_irq0_reject), /* shared */
    .umasks = spr_unc_cha_rxc_irq0_reject,
  },
  { .name   = "UNC_CHA_RxC_IPQ1_REJECT",
    .desc   = "IPQ Requests (from CMS) Rejected - Set 1",
    .code   = 0x0023,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_other1_retry), /* shared */
    .umasks = spr_unc_cha_rxc_other1_retry,
  },
  { .name   = "UNC_CHA_RxC_IRQ0_REJECT",
    .desc   = "IRQ Requests (from CMS) Rejected - Set 0",
    .code   = 0x0018,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_irq0_reject),
    .umasks = spr_unc_cha_rxc_irq0_reject,
  },
  { .name   = "UNC_CHA_RxC_IRQ1_REJECT",
    .desc   = "Ingress (from CMS) Request Queue Rejects",
    .code   = 0x0019,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_irq1_reject),
    .umasks = spr_unc_cha_rxc_irq1_reject,
  },
  { .name   = "UNC_CHA_RxC_ISMQ0_REJECT",
    .desc   = "ISMQ Rejects - Set 0",
    .code   = 0x0024,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_ismq0_retry), /* shared */
    .umasks = spr_unc_cha_rxc_ismq0_retry,
  },
  { .name   = "UNC_CHA_RxC_ISMQ0_RETRY",
    .desc   = "ISMQ Retries - Set 0",
    .code   = 0x002c,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_ismq0_retry),
    .umasks = spr_unc_cha_rxc_ismq0_retry,
  },
  { .name   = "UNC_CHA_RxC_ISMQ1_REJECT",
    .desc   = "ISMQ Rejects - Set 1",
    .code   = 0x0025,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_ismq1_retry), /* shared */
    .umasks = spr_unc_cha_rxc_ismq1_retry,
  },
  { .name   = "UNC_CHA_RxC_ISMQ1_RETRY",
    .desc   = "ISMQ Retries - Set 1",
    .code   = 0x002d,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_ismq1_retry),
    .umasks = spr_unc_cha_rxc_ismq1_retry,
  },
  { .name   = "UNC_CHA_RxC_OCCUPANCY",
    .desc   = "Ingress (from CMS) Occupancy",
    .code   = 0x0011,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0x1ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_occupancy),
    .umasks = spr_unc_cha_rxc_occupancy,
  },
  { .name   = "UNC_CHA_RxC_OTHER0_RETRY",
    .desc   = "Other Retries - Set 0",
    .code   = 0x002e,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_prq0_reject), /* shared */
    .umasks = spr_unc_cha_rxc_prq0_reject,
  },
  { .name   = "UNC_CHA_RxC_OTHER1_RETRY",
    .desc   = "Other Retries - Set 1",
    .code   = 0x002f,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_other1_retry),
    .umasks = spr_unc_cha_rxc_other1_retry,
  },
  { .name   = "UNC_CHA_RxC_PRQ0_REJECT",
    .desc   = "PRQ Requests (from CMS) Rejected - Set 0",
    .code   = 0x0020,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_prq0_reject),
    .umasks = spr_unc_cha_rxc_prq0_reject,
  },
  { .name   = "UNC_CHA_RxC_PRQ1_REJECT",
    .desc   = "PRQ Requests (from CMS) Rejected - Set 1",
    .code   = 0x0021,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_req_q1_retry), /* shared */
    .umasks = spr_unc_cha_rxc_req_q1_retry,
  },
  { .name   = "UNC_CHA_RxC_REQ_Q0_RETRY",
    .desc   = "Request Queue Retries - Set 0",
    .code   = 0x002a,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_rrq0_reject), /* shared */
    .umasks = spr_unc_cha_rxc_rrq0_reject,
  },
  { .name   = "UNC_CHA_RxC_REQ_Q1_RETRY",
    .desc   = "Request Queue Retries - Set 1",
    .code   = 0x002b,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_req_q1_retry),
    .umasks = spr_unc_cha_rxc_req_q1_retry,
  },
  { .name   = "UNC_CHA_RxC_RRQ0_REJECT",
    .desc   = "RRQ Rejects - Set 0",
    .code   = 0x0026,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_rrq0_reject),
    .umasks = spr_unc_cha_rxc_rrq0_reject,
  },
  { .name   = "UNC_CHA_RxC_RRQ1_REJECT",
    .desc   = "RRQ Rejects - Set 1",
    .code   = 0x0027,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_wbq1_reject), /* shared */
    .umasks = spr_unc_cha_rxc_wbq1_reject,
  },
  { .name   = "UNC_CHA_RxC_WBQ0_REJECT",
    .desc   = "WBQ Rejects - Set 0",
    .code   = 0x0028,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_wbq0_reject),
    .umasks = spr_unc_cha_rxc_wbq0_reject,
  },
  { .name   = "UNC_CHA_RxC_WBQ1_REJECT",
    .desc   = "WBQ Rejects - Set 1",
    .code   = 0x0029,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_rxc_wbq1_reject),
    .umasks = spr_unc_cha_rxc_wbq1_reject,
  },
  { .name   = "UNC_CHA_SNOOPS_SENT",
    .desc   = "Snoops Sent",
    .code   = 0x0051,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_snoops_sent),
    .umasks = spr_unc_cha_snoops_sent,
  },
  { .name   = "UNC_CHA_SNOOP_RESP",
    .desc   = "Snoop Responses Received",
    .code   = 0x005c,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_snoop_resp),
    .umasks = spr_unc_cha_snoop_resp,
  },
  { .name   = "UNC_CHA_SNOOP_RESP_LOCAL",
    .desc   = "Snoop Responses Received Local",
    .code   = 0x005d,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_snoop_resp_local),
    .umasks = spr_unc_cha_snoop_resp_local,
  },
  { .name   = "UNC_CHA_SNOOP_RSP_MISC",
    .desc   = "Misc Snoop Responses Received",
    .code   = 0x006b,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_snoop_rsp_misc),
    .umasks = spr_unc_cha_snoop_rsp_misc,
  },
  { .name   = "UNC_CHA_TOR_INSERTS",
    .desc   = "TOR Inserts",
    .code   = 0x0035,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_tor_inserts),
    .umasks = spr_unc_cha_tor_inserts,
  },
  { .name   = "UNC_CHA_TOR_OCCUPANCY",
    .desc   = "TOR Occupancy",
    .code   = 0x0036,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0x1ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_tor_inserts), /* shared */
    .umasks = spr_unc_cha_tor_inserts,
  },
  { .name   = "UNC_CHA_WB_PUSH_MTOI",
    .desc   = "WbPushMtoI",
    .code   = 0x0056,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_wb_push_mtoi),
    .umasks = spr_unc_cha_wb_push_mtoi,
  },
  { .name   = "UNC_CHA_WRITE_NO_CREDITS",
    .desc   = "CHA iMC CHNx WRITE Credits Empty",
    .code   = 0x005a,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_write_no_credits),
    .umasks = spr_unc_cha_write_no_credits,
  },
  { .name   = "UNC_CHA_XPT_PREF",
    .desc   = "XPT Prefetches",
    .code   = 0x006f,
    .modmsk = SPR_UNC_CHA_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(spr_unc_cha_xpt_pref),
    .umasks = spr_unc_cha_xpt_pref,
  },
};
/* 55 events available */
