# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, List, Literal, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._serialization import Deserializer, Serializer
from ...operations._share_operations import (
    build_acquire_lease_request,
    build_break_lease_request,
    build_change_lease_request,
    build_create_permission_request,
    build_create_request,
    build_create_snapshot_request,
    build_delete_request,
    build_get_access_policy_request,
    build_get_permission_request,
    build_get_properties_request,
    build_get_statistics_request,
    build_release_lease_request,
    build_renew_lease_request,
    build_restore_request,
    build_set_access_policy_request,
    build_set_metadata_request,
    build_set_properties_request,
)
from .._configuration import AzureFileStorageConfiguration

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ShareOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.storage.fileshare.aio.AzureFileStorage`'s
        :attr:`share` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: AzureFileStorageConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def create(
        self,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        quota: Optional[int] = None,
        access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
        enabled_protocols: Optional[str] = None,
        root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
        enable_snapshot_virtual_directory_access: Optional[bool] = None,
        paid_bursting_enabled: Optional[bool] = None,
        paid_bursting_max_bandwidth_mibps: Optional[int] = None,
        paid_bursting_max_iops: Optional[int] = None,
        share_provisioned_iops: Optional[int] = None,
        share_provisioned_bandwidth_mibps: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Creates a new share under the specified account. If the share with the same name already
        exists, the operation fails.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param quota: Specifies the maximum size of the share, in gigabytes. Default value is None.
        :type quota: int
        :param access_tier: Specifies the access tier of the share. Known values are:
         "TransactionOptimized", "Hot", "Cool", and "Premium". Default value is None.
        :type access_tier: str or ~azure.storage.fileshare.models.ShareAccessTier
        :param enabled_protocols: Protocols to enable on the share. Default value is None.
        :type enabled_protocols: str
        :param root_squash: Root squash to set on the share.  Only valid for NFS shares. Known values
         are: "NoRootSquash", "RootSquash", and "AllSquash". Default value is None.
        :type root_squash: str or ~azure.storage.fileshare.models.ShareRootSquash
        :param enable_snapshot_virtual_directory_access: Default value is None.
        :type enable_snapshot_virtual_directory_access: bool
        :param paid_bursting_enabled: Optional. Boolean. Default if not specified is false. This
         property enables paid bursting. Default value is None.
        :type paid_bursting_enabled: bool
        :param paid_bursting_max_bandwidth_mibps: Optional. Integer. Default if not specified is the
         maximum throughput the file share can support. Current maximum for a file share is 10,340
         MiB/sec. Default value is None.
        :type paid_bursting_max_bandwidth_mibps: int
        :param paid_bursting_max_iops: Optional. Integer. Default if not specified is the maximum IOPS
         the file share can support. Current maximum for a file share is 102,400 IOPS. Default value is
         None.
        :type paid_bursting_max_iops: int
        :param share_provisioned_iops: Optional. Supported in version 2025-01-05 and later. Only
         allowed for provisioned v2 file shares. Specifies the provisioned number of input/output
         operations per second (IOPS) of the share. If this is not specified, the provisioned IOPS is
         set to value calculated based on recommendation formula. Default value is None.
        :type share_provisioned_iops: int
        :param share_provisioned_bandwidth_mibps: Optional. Supported in version 2025-01-05 and later.
         Only allowed for provisioned v2 file shares. Specifies the provisioned bandwidth of the share,
         in mebibytes per second (MiBps). If this is not specified, the provisioned bandwidth is set to
         value calculated based on recommendation formula. Default value is None.
        :type share_provisioned_bandwidth_mibps: int
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_create_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            quota=quota,
            access_tier=access_tier,
            enabled_protocols=enabled_protocols,
            root_squash=root_squash,
            enable_snapshot_virtual_directory_access=enable_snapshot_virtual_directory_access,
            paid_bursting_enabled=paid_bursting_enabled,
            paid_bursting_max_bandwidth_mibps=paid_bursting_max_bandwidth_mibps,
            paid_bursting_max_iops=paid_bursting_max_iops,
            share_provisioned_iops=share_provisioned_iops,
            share_provisioned_bandwidth_mibps=share_provisioned_bandwidth_mibps,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-share-included-burst-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-included-burst-iops")
        )
        response_headers["x-ms-share-max-burst-credits-for-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-max-burst-credits-for-iops")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def get_properties(
        self,
        sharesnapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Returns all user-defined metadata and system properties for the specified share or share
        snapshot. The data returned does not include the share's list of files.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_get_properties_request(
            url=self._config.url,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-meta"] = self._deserialize("{str}", response.headers.get("x-ms-meta"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-ingress-mbps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-ingress-mbps")
        )
        response_headers["x-ms-share-provisioned-egress-mbps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-egress-mbps")
        )
        response_headers["x-ms-share-next-allowed-quota-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-quota-downgrade-time")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-lease-duration"] = self._deserialize("str", response.headers.get("x-ms-lease-duration"))
        response_headers["x-ms-lease-state"] = self._deserialize("str", response.headers.get("x-ms-lease-state"))
        response_headers["x-ms-lease-status"] = self._deserialize("str", response.headers.get("x-ms-lease-status"))
        response_headers["x-ms-access-tier"] = self._deserialize("str", response.headers.get("x-ms-access-tier"))
        response_headers["x-ms-access-tier-change-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-access-tier-change-time")
        )
        response_headers["x-ms-access-tier-transition-state"] = self._deserialize(
            "str", response.headers.get("x-ms-access-tier-transition-state")
        )
        response_headers["x-ms-enabled-protocols"] = self._deserialize(
            "str", response.headers.get("x-ms-enabled-protocols")
        )
        response_headers["x-ms-root-squash"] = self._deserialize("str", response.headers.get("x-ms-root-squash"))
        response_headers["x-ms-enable-snapshot-virtual-directory-access"] = self._deserialize(
            "bool", response.headers.get("x-ms-enable-snapshot-virtual-directory-access")
        )
        response_headers["x-ms-share-paid-bursting-enabled"] = self._deserialize(
            "bool", response.headers.get("x-ms-share-paid-bursting-enabled")
        )
        response_headers["x-ms-share-paid-bursting-max-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-paid-bursting-max-iops")
        )
        response_headers["x-ms-share-paid-bursting-max-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-paid-bursting-max-bandwidth-mibps")
        )
        response_headers["x-ms-share-included-burst-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-included-burst-iops")
        )
        response_headers["x-ms-share-max-burst-credits-for-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-max-burst-credits-for-iops")
        )
        response_headers["x-ms-share-next-allowed-provisioned-iops-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-provisioned-iops-downgrade-time")
        )
        response_headers["x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def delete(
        self,
        sharesnapshot: Optional[str] = None,
        timeout: Optional[int] = None,
        delete_snapshots: Optional[Union[str, _models.DeleteSnapshotsOptionType]] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Operation marks the specified share or share snapshot for deletion. The share or share snapshot
        and any files contained within it are later deleted during garbage collection.

        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param delete_snapshots: Specifies the option include to delete the base share and all of its
         snapshots. Known values are: "include" and "include-leased". Default value is None.
        :type delete_snapshots: str or ~azure.storage.fileshare.models.DeleteSnapshotsOptionType
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_delete_request(
            url=self._config.url,
            sharesnapshot=sharesnapshot,
            timeout=timeout,
            delete_snapshots=delete_snapshots,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-file-share-usage-bytes"] = self._deserialize(
            "int", response.headers.get("x-ms-file-share-usage-bytes")
        )
        response_headers["x-ms-file-share-snapshot-usage-bytes"] = self._deserialize(
            "int", response.headers.get("x-ms-file-share-snapshot-usage-bytes")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def acquire_lease(
        self,
        timeout: Optional[int] = None,
        duration: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param duration: Specifies the duration of the lease, in seconds, or negative one (-1) for a
         lease that never expires. A non-infinite lease can be between 15 and 60 seconds. A lease
         duration cannot be changed using renew or change. Default value is None.
        :type duration: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["acquire"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "acquire"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_acquire_lease_request(
            url=self._config.url,
            timeout=timeout,
            duration=duration,
            proposed_lease_id=proposed_lease_id,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def release_lease(
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["release"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "release"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_release_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def change_lease(
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        proposed_lease_id: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param proposed_lease_id: Proposed lease ID, in a GUID string format. The File service returns
         400 (Invalid request) if the proposed lease ID is not in the correct format. See Guid
         Constructor (String) for a list of valid GUID string formats. Default value is None.
        :type proposed_lease_id: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["change"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "change"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_change_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            proposed_lease_id=proposed_lease_id,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def renew_lease(
        self,
        lease_id: str,
        timeout: Optional[int] = None,
        sharesnapshot: Optional[str] = None,
        request_id_parameter: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param lease_id: Specifies the current lease ID on the resource. Required.
        :type lease_id: str
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["renew"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "renew"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_renew_lease_request(
            url=self._config.url,
            lease_id=lease_id,
            timeout=timeout,
            sharesnapshot=sharesnapshot,
            request_id_parameter=request_id_parameter,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def break_lease(
        self,
        timeout: Optional[int] = None,
        break_period: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        sharesnapshot: Optional[str] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """The Lease Share operation establishes and manages a lock on a share, or the specified snapshot
        for set and delete share operations.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param break_period: For a break operation, proposed duration the lease should continue before
         it is broken, in seconds, between 0 and 60. This break period is only used if it is shorter
         than the time remaining on the lease. If longer, the time remaining on the lease is used. A new
         lease will not be available before the break period has expired, but the lease may be held for
         longer than the break period. If this header does not appear with a break operation, a
         fixed-duration lease breaks after the remaining lease period elapses, and an infinite lease
         breaks immediately. Default value is None.
        :type break_period: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param sharesnapshot: The snapshot parameter is an opaque DateTime value that, when present,
         specifies the share snapshot to query. Default value is None.
        :type sharesnapshot: str
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        comp: Literal["lease"] = kwargs.pop("comp", _params.pop("comp", "lease"))
        action: Literal["break"] = kwargs.pop("action", _headers.pop("x-ms-lease-action", "break"))
        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_break_lease_request(
            url=self._config.url,
            timeout=timeout,
            break_period=break_period,
            lease_id=_lease_id,
            request_id_parameter=request_id_parameter,
            sharesnapshot=sharesnapshot,
            file_request_intent=self._config.file_request_intent,
            comp=comp,
            action=action,
            restype=restype,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-lease-time"] = self._deserialize("int", response.headers.get("x-ms-lease-time"))
        response_headers["x-ms-lease-id"] = self._deserialize("str", response.headers.get("x-ms-lease-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def create_snapshot(
        self, timeout: Optional[int] = None, metadata: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Creates a read-only snapshot of a share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["snapshot"] = kwargs.pop("comp", _params.pop("comp", "snapshot"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_create_snapshot_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-snapshot"] = self._deserialize("str", response.headers.get("x-ms-snapshot"))
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @overload
    async def create_permission(
        self,
        share_permission: _models.SharePermission,
        timeout: Optional[int] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Required.
        :type share_permission: ~azure.storage.fileshare.models.SharePermission
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_permission(
        self,
        share_permission: IO[bytes],
        timeout: Optional[int] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Required.
        :type share_permission: IO[bytes]
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_permission(
        self, share_permission: Union[_models.SharePermission, IO[bytes]], timeout: Optional[int] = None, **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Create a permission (a security descriptor).

        :param share_permission: A permission (a security descriptor) at the share level. Is either a
         SharePermission type or a IO[bytes] type. Required.
        :type share_permission: ~azure.storage.fileshare.models.SharePermission or IO[bytes]
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["filepermission"] = kwargs.pop("comp", _params.pop("comp", "filepermission"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(share_permission, (IOBase, bytes)):
            _content = share_permission
        else:
            _json = self._serialize.body(share_permission, "SharePermission")

        _request = build_create_permission_request(
            url=self._config.url,
            timeout=timeout,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            content_type=content_type,
            version=self._config.version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-file-permission-key"] = self._deserialize(
            "str", response.headers.get("x-ms-file-permission-key")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def get_permission(
        self,
        file_permission_key: str,
        file_permission_format: Optional[Union[str, _models.FilePermissionFormat]] = None,
        timeout: Optional[int] = None,
        **kwargs: Any
    ) -> _models.SharePermission:
        # pylint: disable=line-too-long
        """Returns the permission (security descriptor) for a given key.

        :param file_permission_key: Key of the permission to be set for the directory/file. Required.
        :type file_permission_key: str
        :param file_permission_format: Optional. Available for version 2023-06-01 and later. Specifies
         the format in which the permission is returned. Acceptable values are SDDL or binary. If
         x-ms-file-permission-format is unspecified or explicitly set to SDDL, the permission is
         returned in SDDL format. If x-ms-file-permission-format is explicitly set to binary, the
         permission is returned as a base64 string representing the binary encoding of the permission.
         Known values are: "Sddl" and "Binary". Default value is None.
        :type file_permission_format: str or ~azure.storage.fileshare.models.FilePermissionFormat
        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :return: SharePermission or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.SharePermission
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["filepermission"] = kwargs.pop("comp", _params.pop("comp", "filepermission"))
        cls: ClsType[_models.SharePermission] = kwargs.pop("cls", None)

        _request = build_get_permission_request(
            url=self._config.url,
            file_permission_key=file_permission_key,
            file_permission_format=file_permission_format,
            timeout=timeout,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("SharePermission", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def set_properties(
        self,
        timeout: Optional[int] = None,
        quota: Optional[int] = None,
        access_tier: Optional[Union[str, _models.ShareAccessTier]] = None,
        root_squash: Optional[Union[str, _models.ShareRootSquash]] = None,
        enable_snapshot_virtual_directory_access: Optional[bool] = None,
        paid_bursting_enabled: Optional[bool] = None,
        paid_bursting_max_bandwidth_mibps: Optional[int] = None,
        paid_bursting_max_iops: Optional[int] = None,
        share_provisioned_iops: Optional[int] = None,
        share_provisioned_bandwidth_mibps: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Sets properties for the specified share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param quota: Specifies the maximum size of the share, in gigabytes. Default value is None.
        :type quota: int
        :param access_tier: Specifies the access tier of the share. Known values are:
         "TransactionOptimized", "Hot", "Cool", and "Premium". Default value is None.
        :type access_tier: str or ~azure.storage.fileshare.models.ShareAccessTier
        :param root_squash: Root squash to set on the share.  Only valid for NFS shares. Known values
         are: "NoRootSquash", "RootSquash", and "AllSquash". Default value is None.
        :type root_squash: str or ~azure.storage.fileshare.models.ShareRootSquash
        :param enable_snapshot_virtual_directory_access: Default value is None.
        :type enable_snapshot_virtual_directory_access: bool
        :param paid_bursting_enabled: Optional. Boolean. Default if not specified is false. This
         property enables paid bursting. Default value is None.
        :type paid_bursting_enabled: bool
        :param paid_bursting_max_bandwidth_mibps: Optional. Integer. Default if not specified is the
         maximum throughput the file share can support. Current maximum for a file share is 10,340
         MiB/sec. Default value is None.
        :type paid_bursting_max_bandwidth_mibps: int
        :param paid_bursting_max_iops: Optional. Integer. Default if not specified is the maximum IOPS
         the file share can support. Current maximum for a file share is 102,400 IOPS. Default value is
         None.
        :type paid_bursting_max_iops: int
        :param share_provisioned_iops: Optional. Supported in version 2025-01-05 and later. Only
         allowed for provisioned v2 file shares. Specifies the provisioned number of input/output
         operations per second (IOPS) of the share. If this is not specified, the provisioned IOPS is
         set to value calculated based on recommendation formula. Default value is None.
        :type share_provisioned_iops: int
        :param share_provisioned_bandwidth_mibps: Optional. Supported in version 2025-01-05 and later.
         Only allowed for provisioned v2 file shares. Specifies the provisioned bandwidth of the share,
         in mebibytes per second (MiBps). If this is not specified, the provisioned bandwidth is set to
         value calculated based on recommendation formula. Default value is None.
        :type share_provisioned_bandwidth_mibps: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["properties"] = kwargs.pop("comp", _params.pop("comp", "properties"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_set_properties_request(
            url=self._config.url,
            timeout=timeout,
            quota=quota,
            access_tier=access_tier,
            lease_id=_lease_id,
            root_squash=root_squash,
            enable_snapshot_virtual_directory_access=enable_snapshot_virtual_directory_access,
            paid_bursting_enabled=paid_bursting_enabled,
            paid_bursting_max_bandwidth_mibps=paid_bursting_max_bandwidth_mibps,
            paid_bursting_max_iops=paid_bursting_max_iops,
            share_provisioned_iops=share_provisioned_iops,
            share_provisioned_bandwidth_mibps=share_provisioned_bandwidth_mibps,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-share-included-burst-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-included-burst-iops")
        )
        response_headers["x-ms-share-max-burst-credits-for-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-max-burst-credits-for-iops")
        )
        response_headers["x-ms-share-next-allowed-quota-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-quota-downgrade-time")
        )
        response_headers["x-ms-share-next-allowed-provisioned-iops-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-provisioned-iops-downgrade-time")
        )
        response_headers["x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time"] = self._deserialize(
            "rfc-1123", response.headers.get("x-ms-share-next-allowed-provisioned-bandwidth-downgrade-time")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def set_metadata(
        self,
        timeout: Optional[int] = None,
        metadata: Optional[Dict[str, str]] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Sets one or more user-defined name-value pairs for the specified share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param metadata: A name-value pair to associate with a file storage object. Default value is
         None.
        :type metadata: dict[str, str]
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["metadata"] = kwargs.pop("comp", _params.pop("comp", "metadata"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_set_metadata_request(
            url=self._config.url,
            timeout=timeout,
            metadata=metadata,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def get_access_policy(
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> List[_models.SignedIdentifier]:
        # pylint: disable=line-too-long
        """Returns information about stored access policies specified on the share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: list of SignedIdentifier or the result of cls(response)
        :rtype: list[~azure.storage.fileshare.models.SignedIdentifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
        cls: ClsType[List[_models.SignedIdentifier]] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_get_access_policy_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("[SignedIdentifier]", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def set_access_policy(
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        share_acl: Optional[List[_models.SignedIdentifier]] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Sets a stored access policy for use with shared access signatures.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :param share_acl: The ACL for the share. Default value is None.
        :type share_acl: list[~azure.storage.fileshare.models.SignedIdentifier]
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["acl"] = kwargs.pop("comp", _params.pop("comp", "acl"))
        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/xml"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id
        serialization_ctxt = {"xml": {"name": "SignedIdentifiers", "wrapped": True}}
        if share_acl is not None:
            _content = self._serialize.body(
                share_acl, "[SignedIdentifier]", is_xml=True, serialization_ctxt=serialization_ctxt
            )
        else:
            _content = None

        _request = build_set_access_policy_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            content_type=content_type,
            version=self._config.version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore

    @distributed_trace_async
    async def get_statistics(
        self,
        timeout: Optional[int] = None,
        lease_access_conditions: Optional[_models.LeaseAccessConditions] = None,
        **kwargs: Any
    ) -> _models.ShareStats:
        # pylint: disable=line-too-long
        """Retrieves statistics related to the share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param lease_access_conditions: Parameter group. Default value is None.
        :type lease_access_conditions: ~azure.storage.fileshare.models.LeaseAccessConditions
        :return: ShareStats or the result of cls(response)
        :rtype: ~azure.storage.fileshare.models.ShareStats
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["stats"] = kwargs.pop("comp", _params.pop("comp", "stats"))
        cls: ClsType[_models.ShareStats] = kwargs.pop("cls", None)

        _lease_id = None
        if lease_access_conditions is not None:
            _lease_id = lease_access_conditions.lease_id

        _request = build_get_statistics_request(
            url=self._config.url,
            timeout=timeout,
            lease_id=_lease_id,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))

        deserialized = self._deserialize("ShareStats", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def restore(
        self,
        timeout: Optional[int] = None,
        request_id_parameter: Optional[str] = None,
        deleted_share_name: Optional[str] = None,
        deleted_share_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        # pylint: disable=line-too-long
        """Restores a previously deleted Share.

        :param timeout: The timeout parameter is expressed in seconds. For more information, see
         :code:`<a
         href="https://docs.microsoft.com/en-us/rest/api/storageservices/Setting-Timeouts-for-File-Service-Operations?redirectedfrom=MSDN">Setting
         Timeouts for File Service Operations.</a>`. Default value is None.
        :type timeout: int
        :param request_id_parameter: Provides a client-generated, opaque value with a 1 KB character
         limit that is recorded in the analytics logs when storage analytics logging is enabled. Default
         value is None.
        :type request_id_parameter: str
        :param deleted_share_name: Specifies the name of the previously-deleted share. Default value is
         None.
        :type deleted_share_name: str
        :param deleted_share_version: Specifies the version of the previously-deleted share. Default
         value is None.
        :type deleted_share_version: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        restype: Literal["share"] = kwargs.pop("restype", _params.pop("restype", "share"))
        comp: Literal["undelete"] = kwargs.pop("comp", _params.pop("comp", "undelete"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_restore_request(
            url=self._config.url,
            timeout=timeout,
            request_id_parameter=request_id_parameter,
            deleted_share_name=deleted_share_name,
            deleted_share_version=deleted_share_version,
            file_request_intent=self._config.file_request_intent,
            restype=restype,
            comp=comp,
            version=self._config.version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.StorageError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["ETag"] = self._deserialize("str", response.headers.get("ETag"))
        response_headers["Last-Modified"] = self._deserialize("rfc-1123", response.headers.get("Last-Modified"))
        response_headers["x-ms-request-id"] = self._deserialize("str", response.headers.get("x-ms-request-id"))
        response_headers["x-ms-client-request-id"] = self._deserialize(
            "str", response.headers.get("x-ms-client-request-id")
        )
        response_headers["x-ms-version"] = self._deserialize("str", response.headers.get("x-ms-version"))
        response_headers["Date"] = self._deserialize("rfc-1123", response.headers.get("Date"))
        response_headers["x-ms-share-quota"] = self._deserialize("int", response.headers.get("x-ms-share-quota"))
        response_headers["x-ms-share-provisioned-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-iops")
        )
        response_headers["x-ms-share-provisioned-bandwidth-mibps"] = self._deserialize(
            "int", response.headers.get("x-ms-share-provisioned-bandwidth-mibps")
        )
        response_headers["x-ms-share-included-burst-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-included-burst-iops")
        )
        response_headers["x-ms-share-max-burst-credits-for-iops"] = self._deserialize(
            "int", response.headers.get("x-ms-share-max-burst-credits-for-iops")
        )

        if cls:
            return cls(pipeline_response, None, response_headers)  # type: ignore
