/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.table.DomNodeList;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderColumnsElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfTableColumnProperties;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.odfdom.type.PositiveLength;
import org.w3c.dom.Node;

public class OdfTableColumn {
    TableTableColumnElement maColumnElement;
    int mnRepeatedIndex;
    private static final String DEFAULT_WIDTH = "0in";
    private OdfDocument mDocument;

    OdfTableColumn(TableTableColumnElement colElement, int repeatedIndex) {
        this.maColumnElement = colElement;
        this.mnRepeatedIndex = repeatedIndex;
        this.mDocument = (OdfDocument)((OdfFileDom)this.maColumnElement.getOwnerDocument()).getDocument();
    }

    public static OdfTableColumn getInstance(TableTableColumnElement colElement) {
        TableTableElement tableElement = null;
        for (Node node = colElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            tableElement = (TableTableElement)node;
        }
        OdfTable table = null;
        if (tableElement == null) {
            throw new IllegalArgumentException("the colElement is not in the table dom tree");
        }
        table = OdfTable.getInstance(tableElement);
        OdfTableColumn column = table.getColumnInstance(colElement, 0);
        if (column.getColumnsRepeatedNumber() > 1) {
            Logger.getLogger(OdfTableColumn.class.getName()).log(Level.WARNING, "the column has the repeated column number, and puzzled about get which repeated index of the column,here just return the first column of the repeated columns.");
        }
        return column;
    }

    private TableTableElement getTableElement() {
        for (Node node = this.maColumnElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            return (TableTableElement)node;
        }
        return null;
    }

    public OdfTable getTable() {
        TableTableElement tableElement = this.getTableElement();
        if (tableElement != null) {
            return OdfTable.getInstance(tableElement);
        }
        return null;
    }

    public long getWidth() {
        String sWidth = this.maColumnElement.getProperty(OdfTableColumnProperties.ColumnWidth);
        if (sWidth == null) {
            sWidth = DEFAULT_WIDTH;
        }
        return PositiveLength.parseLong(sWidth, Length.Unit.MILLIMETER);
    }

    public void setWidth(long width) {
        long prevColumnRelWidth;
        String sWidthMM = String.valueOf(width) + Length.Unit.MILLIMETER.abbr();
        String sWidthIN = PositiveLength.mapToUnit(sWidthMM, Length.Unit.INCH);
        this.splitRepeatedColumns();
        this.maColumnElement.setProperty(OdfTableColumnProperties.ColumnWidth, sWidthIN);
        int index = this.getColumnIndex();
        index = index >= 1 ? --index : ++index;
        OdfTableColumn column = null;
        if (index < this.getTable().getColumnCount()) {
            column = this.getTable().getColumnByIndex(index);
        }
        if (column != null && (prevColumnRelWidth = super.getRelativeWidth()) != 0L) {
            long prevColumnWidth = column.getWidth();
            this.setRelativeWidth(prevColumnRelWidth / prevColumnWidth * width);
        }
    }

    void splitRepeatedColumns() {
        OdfTable table = this.getTable();
        TableTableElement tableEle = table.getOdfElement();
        int repeateNum = this.getColumnsRepeatedNumber();
        if (repeateNum > 1) {
            TableTableColumnElement ownerColumnElement = null;
            int repeatedColumnIndex = this.mnRepeatedIndex;
            TableTableColumnElement refElement = this.maColumnElement;
            this.maColumnElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
            String originalWidth = this.maColumnElement.getProperty(OdfTableColumnProperties.ColumnWidth);
            String originalRelWidth = this.maColumnElement.getProperty(OdfTableColumnProperties.RelColumnWidth);
            for (int i = repeateNum - 1; i >= 0; --i) {
                TableTableColumnElement newColumn = (TableTableColumnElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.maColumnElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "table-column"));
                if (originalWidth != null && originalWidth.length() > 0) {
                    newColumn.setProperty(OdfTableColumnProperties.ColumnWidth, originalWidth);
                }
                if (originalRelWidth != null && originalRelWidth.length() > 0) {
                    newColumn.setProperty(OdfTableColumnProperties.RelColumnWidth, originalRelWidth);
                }
                tableEle.insertBefore(newColumn, refElement);
                refElement = newColumn;
                if (repeatedColumnIndex == i) {
                    ownerColumnElement = newColumn;
                    continue;
                }
                table.updateColumnRepository(this.maColumnElement, i, newColumn, 0);
            }
            tableEle.removeChild(this.maColumnElement);
            if (ownerColumnElement != null) {
                table.updateColumnRepository(this.maColumnElement, this.mnRepeatedIndex, ownerColumnElement, 0);
            }
        }
    }

    private long getRelativeWidth() {
        String sRelWidth = this.maColumnElement.getProperty(OdfTableColumnProperties.RelColumnWidth);
        if (sRelWidth != null && sRelWidth.contains("*")) {
            Long value = Long.valueOf(sRelWidth.substring(0, sRelWidth.indexOf("*")));
            return value;
        }
        return 0L;
    }

    private void setRelativeWidth(long relWidth) {
        this.maColumnElement.setProperty(OdfTableColumnProperties.RelColumnWidth, String.valueOf(relWidth) + "*");
    }

    public boolean isOptimalWidth() {
        return Boolean.parseBoolean(this.maColumnElement.getProperty(OdfTableColumnProperties.UseOptimalColumnWidth));
    }

    public void setUseOptimalWidth(boolean isUseOptimalWidth) {
        this.maColumnElement.setProperty(OdfTableColumnProperties.UseOptimalColumnWidth, String.valueOf(isUseOptimalWidth));
    }

    public TableTableColumnElement getOdfElement() {
        return this.maColumnElement;
    }

    public int getCellCount() {
        return this.getTable().getRowCount();
    }

    public OdfTableCell getCellByIndex(int index) {
        return this.getTable().getCellByPosition(this.getColumnIndex(), index);
    }

    public OdfTableColumn getPreviousColumn() {
        OdfTable table = this.getTable();
        if (this.maColumnElement.getTableNumberColumnsRepeatedAttribute() > 1 && this.mnRepeatedIndex > 0) {
            return table.getColumnInstance(this.maColumnElement, this.mnRepeatedIndex - 1);
        }
        Node aPrevNode = this.maColumnElement.getPreviousSibling();
        Node aCurNode = this.maColumnElement;
        while (true) {
            if (aPrevNode == null) {
                Node parentNode = aCurNode.getParentNode();
                if (parentNode instanceof TableTableElement) {
                    return null;
                }
                aPrevNode = parentNode.getPreviousSibling();
            }
            if (aPrevNode == null) continue;
            try {
                if (aPrevNode instanceof TableTableColumnElement) {
                    return table.getColumnInstance((TableTableColumnElement)aPrevNode, ((TableTableColumnElement)aPrevNode).getTableNumberColumnsRepeatedAttribute() - 1);
                }
                if (aPrevNode instanceof TableTableColumnsElement || aPrevNode instanceof TableTableHeaderColumnsElement || aPrevNode instanceof TableTableColumnGroupElement) {
                    XPath xpath = ((OdfFileDom)this.maColumnElement.getOwnerDocument()).getXPath();
                    TableTableColumnElement lastCol = (TableTableColumnElement)xpath.evaluate("//table:table-column[last()]", aPrevNode, XPathConstants.NODE);
                    if (lastCol == null) continue;
                    return table.getColumnInstance(lastCol, lastCol.getTableNumberColumnsRepeatedAttribute() - 1);
                }
                aCurNode = aPrevNode;
                aPrevNode = aPrevNode.getPreviousSibling();
                continue;
            }
            catch (XPathExpressionException e) {
                Logger.getLogger(OdfTableColumn.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    public OdfTableColumn getNextColumn() {
        OdfTable table = this.getTable();
        if (this.getColumnsRepeatedNumber() > 1 && this.mnRepeatedIndex < this.getColumnsRepeatedNumber() - 1) {
            return table.getColumnInstance(this.maColumnElement, this.mnRepeatedIndex + 1);
        }
        Node aNextNode = this.maColumnElement.getNextSibling();
        Node aCurNode = this.maColumnElement;
        while (true) {
            if (aNextNode == null) {
                Node parentNode = aCurNode.getParentNode();
                if (parentNode instanceof TableTableElement) {
                    return null;
                }
                aNextNode = parentNode.getNextSibling();
            }
            if (aNextNode == null) continue;
            try {
                if (aNextNode instanceof TableTableColumnElement) {
                    return table.getColumnInstance((TableTableColumnElement)aNextNode, 0);
                }
                if (aNextNode instanceof TableTableColumnsElement || aNextNode instanceof TableTableHeaderColumnsElement || aNextNode instanceof TableTableColumnGroupElement) {
                    XPath xpath = ((OdfFileDom)this.maColumnElement.getOwnerDocument()).getXPath();
                    TableTableColumnElement firstCol = (TableTableColumnElement)xpath.evaluate("//table:table-column[first()]", aNextNode, XPathConstants.NODE);
                    if (firstCol == null) continue;
                    return table.getColumnInstance(firstCol, 0);
                }
                aCurNode = aNextNode;
                aNextNode = aNextNode.getNextSibling();
                continue;
            }
            catch (XPathExpressionException e) {
                Logger.getLogger(OdfTableColumn.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    public int getColumnIndex() {
        int result = 0;
        OdfTable table = this.getTable();
        TableTableElement mTableElement = table.getOdfElement();
        for (Node n : new DomNodeList(mTableElement.getChildNodes())) {
            TableTableColumnElement columnEle;
            if (n instanceof TableTableHeaderColumnsElement) {
                TableTableHeaderColumnsElement headers = (TableTableHeaderColumnsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (!(m instanceof TableTableColumnElement)) continue;
                    columnEle = (TableTableColumnElement)m;
                    if (columnEle == this.getOdfElement()) {
                        return result + this.mnRepeatedIndex;
                    }
                    if (columnEle.getTableNumberColumnsRepeatedAttribute() == null) {
                        ++result;
                        continue;
                    }
                    result += columnEle.getTableNumberColumnsRepeatedAttribute().intValue();
                }
            }
            if (!(n instanceof TableTableColumnElement)) continue;
            columnEle = (TableTableColumnElement)n;
            if (columnEle == this.getOdfElement()) break;
            if (columnEle.getTableNumberColumnsRepeatedAttribute() == null) {
                ++result;
                continue;
            }
            result += columnEle.getTableNumberColumnsRepeatedAttribute().intValue();
        }
        return result + this.mnRepeatedIndex;
    }

    public void setDefaultCellStyle(OdfStyle style) {
        this.splitRepeatedColumns();
        OdfStyle defaultStyle = this.getDefaultCellStyle();
        if (defaultStyle != null) {
            defaultStyle.removeStyleUser(this.maColumnElement);
        }
        if (style != null) {
            style.addStyleUser(this.maColumnElement);
            this.maColumnElement.setTableDefaultCellStyleNameAttribute(style.getStyleNameAttribute());
        }
    }

    public OdfStyle getDefaultCellStyle() {
        String styleName = this.maColumnElement.getTableDefaultCellStyleNameAttribute();
        OdfStyle style = this.maColumnElement.getAutomaticStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        if (style == null) {
            style = this.mDocument.getDocumentStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        }
        return style;
    }

    void setColumnsRepeatedNumber(int num) {
        this.maColumnElement.setTableNumberColumnsRepeatedAttribute(num);
    }

    int getColumnsRepeatedNumber() {
        Integer count = this.maColumnElement.getTableNumberColumnsRepeatedAttribute();
        if (count == null) {
            return 1;
        }
        return count;
    }
}

