% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{wk_plot}
\alias{wk_plot}
\alias{wk_plot.default}
\alias{plot.wk_wkt}
\alias{plot.wk_wkb}
\alias{plot.wk_xy}
\alias{plot.wk_rct}
\alias{plot.wk_crc}
\title{Plot well-known geometry vectors}
\usage{
wk_plot(
  handleable,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE
)

\method{wk_plot}{default}(
  handleable,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE
)

\method{plot}{wk_wkt}(
  x,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE
)

\method{plot}{wk_wkb}(
  x,
  ...,
  asp = 1,
  bbox = NULL,
  xlab = "",
  ylab = "",
  rule = "evenodd",
  add = FALSE
)

\method{plot}{wk_xy}(x, ..., asp = 1, bbox = NULL, xlab = "", ylab = "", add = FALSE)

\method{plot}{wk_rct}(x, ..., asp = 1, bbox = NULL, xlab = "", ylab = "", add = FALSE)

\method{plot}{wk_crc}(x, ..., asp = 1, bbox = NULL, xlab = "", ylab = "", add = FALSE)
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{...}{Passed to plotting functions for features: \code{\link[graphics:points]{graphics::points()}}
for point and multipoint geometries, \code{\link[graphics:lines]{graphics::lines()}} for linestring
and multilinestring geometries, and \code{\link[graphics:polypath]{graphics::polypath()}} for polygon
and multipolygon geometries.}

\item{asp, xlab, ylab}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{bbox}{The limits of the plot as a \code{\link[=rct]{rct()}} or compatible object}

\item{rule}{The rule to use for filling polygons (see \code{\link[graphics:polypath]{graphics::polypath()}})}

\item{add}{Should a new plot be created, or should \code{handleable} be added to the
existing plot?}

\item{x}{A \code{\link[=wkb]{wkb()}} or \code{\link[=wkt]{wkt()}}}
}
\value{
The input, invisibly.
}
\description{
Plot well-known geometry vectors
}
\examples{
plot(as_wkt("LINESTRING (0 0, 1 1)"))
plot(as_wkb("LINESTRING (0 0, 1 1)"))

}
