% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_igraph.R
\name{to_igraph}
\alias{to_igraph}
\title{Convert a DiagrammeR graph to an igraph one}
\usage{
to_igraph(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
An igraph object.
}
\description{
Convert a DiagrammeR graph to an igraph graph object.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 36,
    m = 50,
    set_seed = 23)

# Confirm that `graph` is a
# DiagrammeR graph by getting
# the object's class
class(graph)

# Convert the DiagrammeR graph
# to an igraph object
ig_graph <- to_igraph(graph)

# Get the class of the converted
# graph, just to be certain
class(ig_graph)

# Get a summary of the igraph
# graph object
summary(ig_graph)

}
