#
# PySNMP MIB module HPR-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/HPR-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:15:28 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( SnaControlPointName, ) = mibBuilder.importSymbols("APPN-MIB", "SnaControlPointName")
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ConstraintsIntersection, ValueSizeConstraint, SingleValueConstraint, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ConstraintsIntersection", "ValueSizeConstraint", "SingleValueConstraint", "ValueRangeConstraint")
( snanauMIB, ) = mibBuilder.importSymbols("SNA-NAU-MIB", "snanauMIB")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( Counter64, TimeTicks, NotificationType, Bits, Counter32, ObjectIdentity, Gauge32, Integer32, MibIdentifier, ModuleIdentity, IpAddress, iso, MibScalar, MibTable, MibTableRow, MibTableColumn, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter64", "TimeTicks", "NotificationType", "Bits", "Counter32", "ObjectIdentity", "Gauge32", "Integer32", "MibIdentifier", "ModuleIdentity", "IpAddress", "iso", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Unsigned32")
( TextualConvention, DateAndTime, TimeStamp, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DateAndTime", "TimeStamp", "DisplayString")
hprMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 34, 6))
if mibBuilder.loadTexts: hprMIB.setLastUpdated('970514000000Z')
if mibBuilder.loadTexts: hprMIB.setOrganization('AIW APPN / HPR MIB SIG')
if mibBuilder.loadTexts: hprMIB.setContactInfo('\n\n                        Bob Clouston\n                        Cisco Systems\n                        7025 Kit Creek Road\n                        P.O. Box 14987\n                        Research Triangle Park, NC 27709, USA\n                        Tel:    1 919 472 2333\n                        E-mail: clouston@cisco.com\n\n                        Bob Moore\n                        IBM Corporation\n                        800 Park Offices Drive\n                        RHJA/664\n                        P.O. Box 12195\n                        Research Triangle Park, NC 27709, USA\n                        Tel:    1 919 254 4436\n                        E-mail: remoore@ralvm6.vnet.ibm.com\n                ')
if mibBuilder.loadTexts: hprMIB.setDescription('This is the MIB module for objects used to\n                 manage network devices with HPR capabilities.')
class HprNceTypes(Bits, TextualConvention):
    namedValues = NamedValues(("controlPoint", 0), ("logicalUnit", 1), ("boundaryFunction", 2), ("routeSetup", 3),)

class HprRtpCounter(Counter32, TextualConvention):
    pass

hprObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1))
hprGlobal = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 1))
hprNodeCpName = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 1, 1), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprNodeCpName.setDescription('Administratively assigned network name for the APPN node\n          where this HPR implementation resides.  If this object has\n          the same value as the appnNodeCpName object in the APPN MIB,\n          then the two objects are referring to the same APPN node.')
hprOperatorPathSwitchSupport = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("notSupported", 1), ("switchTriggerSupported", 2), ("switchToPathSupported", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprOperatorPathSwitchSupport.setDescription("This object indicates an implementation's level of support\n          for an operator-requested path switch.\n\n            notSupported(1)           - the agent does not support\n                                        operator-requested path switches\n            switchTriggerSupported(2) - the agent supports a 'switch\n                                        path now' command from an\n                                        operator, but not a command to\n                                        switch to a specified path\n            switchToPathSupported(3)  - the agent supports both a\n                                        'switch path now' command and a\n                                        command to switch to a specified\n                                        path.  Note that the latter\n                                        command is not available via\n                                        this MIB; a system that supports\n                                        it must do so via other means,\n                                        such as a local operator\n                                        interface.")
hprAnrRouting = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 2))
hprAnrsAssigned = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 1), Counter32()).setUnits('ANR labels').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrsAssigned.setDescription('The count of ANR labels assigned by this node since it was\n          last re-initialized.  A Management Station can detect\n          discontinuities in this counter by monitoring the\n          appnNodeCounterDisconTime object in the APPN MIB.')
hprAnrCounterState = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("notActive", 1), ("active", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hprAnrCounterState.setDescription('This object is used for a network management station to turn\n          on/off the counting of ANR packets in the hprAnrRoutingTable.\n          The initial value of this object is an implementation choice.\n\n                 notActive(1) - the counter hprAnrPacketsReceived\n                                returns no meaningful value\n                 active(2)    - the counter hprAnrPacketsReceived is\n                                being incremented and is returning\n                                meaningful values')
hprAnrCounterStateTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrCounterStateTime.setDescription('The time when the hprAnrCounterState object last changed its\n          value.  The initial value returned by this object is the time\n          at which the APPN node instrumented with this MIB was last\n          brought up.')
hprAnrRoutingTable = MibTable((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4), )
if mibBuilder.loadTexts: hprAnrRoutingTable.setDescription('The ANR Routing table provides a means of correlating an\n          incoming ANR label (i.e., one assigned by this node) with the\n          TG over which a packet containing the label will be forwarded.\n          When the ANR label identifies a local NCE, the hprAnrOutTgDest\n          and hprAnrOutTgNum objects have no meaning.  The table also\n          contains an object to count the number of packets received\n          with a given ANR label.')
hprAnrRoutingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1), ).setIndexNames((0, "HPR-MIB", "hprAnrLabel"))
if mibBuilder.loadTexts: hprAnrRoutingEntry.setDescription('The ANR label is used to index this table.')
hprAnrLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,8)))
if mibBuilder.loadTexts: hprAnrLabel.setDescription('The first ANR label in an incoming packet.')
hprAnrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("nce", 1), ("tg", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrType.setDescription('An object indicating whether an ANR label assigned by this\n          node identifies a local NCE or a TG on which outgoing packets\n          are forwarded.\n\n              nce(1)  - the ANR label identifies a local NCE.  In this\n                        case the hprAnrOutTgDest and hprAnrOutTgNum\n                        objects have no meaning.\n              tg(2)   - the ANR label identifies a TG.')
hprAnrOutTgDest = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 3), DisplayString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,17),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrOutTgDest.setDescription('Destination node for the TG over which packets with this ANR\n          label are forwarded.  This is the fully qualified name of an\n          APPN network node or end node, formatted according to the\n          SnaControlPointName textual convention.  If the ANR label\n          identifies a local NCE, then this object returns a zero-length\n          string.\n\n          This object corresponds to the appnLocalTgDest object in the\n          APPN MIB.')
hprAnrOutTgNum = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrOutTgNum.setDescription('Number of the TG over which packets with this ANR label are\n          forwarded.  If the ANR label identifies a local NCE, then this\n          object returns the value 0, since 0 is not a valid TG number\n          for a TG that supports HPR.\n\n          This object corresponds to the appnLocalTgNum object in the\n          APPN MIB.')
hprAnrPacketsReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 5), Counter32()).setUnits('ANR packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrPacketsReceived.setDescription('The count of packets received with this ANR label as their\n          first label.\n\n          A Management Station can detect discontinuities in this\n          counter by monitoring the hprAnrCounterDisconTime object in\n          the same row.')
hprAnrCounterDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 2, 4, 1, 6), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprAnrCounterDisconTime.setDescription('The value of the sysUpTime object when the\n          hprAnrPacketsReceived counter for this ANR label last\n          experienced a discontinuity.  This will be the more recent of\n          two times:  the time at which the ANR label was associated with\n          either an outgoing TG or a local NCE, or the time at which the\n          ANR counters were last turned on or off.')
hprTransportUser = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 3))
hprNceTable = MibTable((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1), )
if mibBuilder.loadTexts: hprNceTable.setDescription('The Network Connection Endpoint (NCE) table.')
hprNceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1), ).setIndexNames((0, "HPR-MIB", "hprNceId"))
if mibBuilder.loadTexts: hprNceEntry.setDescription('The NCE ID is used to index this table.')
hprNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,8)))
if mibBuilder.loadTexts: hprNceId.setDescription('The Network Connection Endpoint (NCE) ID.  NCEs identify\n          Control Points (Cp), Logical Units (Lu), HPR Boundary\n          Functions (Bf) and Route Setup (Rs) Functions.  A value for\n          this object can be retrieved from any of the following\n          objects in the APPN MIB:\n\n               - appnLsCpCpNceId\n               - appnLsRouteNceId\n               - appnLsBfNceId\n               - appnIsInRtpNceId\n               - appnIsRtpNceId\n\n          In each case this value identifies a row in this table\n          containing information related to that in the APPN MIB.')
hprNceType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1, 2), HprNceTypes()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprNceType.setDescription('A bit string identifying the function types provided by this\n          Network Connection Endpoint (NCE).')
hprNceDefault = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1, 3), HprNceTypes()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprNceDefault.setDescription('A bit string identifying the function types for which this\n          Network Connection Endpoint (NCE) is the default NCE.  While\n          default NCEs are not explicitly defined in the architecture,\n          some implementations provide them; for such implementations,\n          it is useful to make this information available to a\n          Management Station.')
hprNceInstanceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 3, 1, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4,4)).setFixedLength(4)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprNceInstanceId.setDescription("The NCE instance identifier (NCEII) identifying the current\n          instance of this NCE.  An NCEII is used to denote different\n          instances (IPLs) of an NCE component.  Each time an NCE is\n          activated (IPL'd), it acquires a different, unique NCEII.")
hprRtp = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 4))
hprRtpGlobe = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 1))
hprRtpGlobeConnSetups = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 1, 1), Counter32()).setUnits('RTP connection setups').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpGlobeConnSetups.setDescription('The count of RTP connection setups in which this node has\n          participated, as either sender or receiver, since it was last\n          re-initialized.  Retries of a setup attempt do not cause the\n          counter to be incremented.\n\n          A Management Station can detect discontinuities in this\n          counter by monitoring the appnNodeCounterDisconTime object\n          in the APPN MIB.')
hprRtpGlobeCtrState = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("notActive", 1), ("active", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hprRtpGlobeCtrState.setDescription('This object allows a network management station to turn the\n          counters in the hprRtpTable on and off.  The initial value of\n          this object is an implementation choice.\n\n                 notActive(1) - the counters in the hprRtpTable are\n                                returning no meaningful values\n                 active(2)    - the counters in the hprRtpTable are\n                                being incremented and are returning\n                                meaningful values')
hprRtpGlobeCtrStateTime = MibScalar((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpGlobeCtrStateTime.setDescription('The time when the value of the hprRtpGlobeCtrState object\n          last changed.  The initial value returned by this object is\n          the time at which the APPN node instrumented with this MIB\n          was last brought up.')
hprRtpTable = MibTable((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2), )
if mibBuilder.loadTexts: hprRtpTable.setDescription('The RTP Connection table')
hprRtpEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1), ).setIndexNames((0, "HPR-MIB", "hprRtpLocNceId"), (0, "HPR-MIB", "hprRtpLocTcid"))
if mibBuilder.loadTexts: hprRtpEntry.setDescription('The local NCE ID and local TCID are used to index this\n          table.')
hprRtpLocNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,8)))
if mibBuilder.loadTexts: hprRtpLocNceId.setDescription('The local Network Connection Endpoint (NCE) ID of this RTP\n          connection.  NCEs identify CPs, LUs, Boundary Functions (BFs),\n          and Route Setup (RS) components.  A value for this object can\n          be retrieved from any of the following objects in the APPN\n          MIB:\n\n               - appnLsCpCpNceId\n               - appnLsRouteNceId\n               - appnLsBfNceId\n               - appnIsInRtpNceId\n               - appnIsRtpNceId\n\n          In each case this value identifies a row in this table\n          containing information related to that in the APPN MIB.')
hprRtpLocTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8,8)).setFixedLength(8))
if mibBuilder.loadTexts: hprRtpLocTcid.setDescription('The local TCID of this RTP connection.  A value for this\n          object can be retrieved from either the appnIsInRtpTcid object\n          or the appnIsRtpTcid object the APPN MIB; in each case this\n          value identifies a row in this table containing information\n          related to that in the APPN MIB.')
hprRtpRemCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 3), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRemCpName.setDescription('Administratively assigned network name for the remote node of\n          this RTP connection.')
hprRtpRemNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 4), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRemNceId.setDescription('The remote Network Connection Endpoint (NCE) of this RTP\n          connection.  NCEs identify CPs, LUs, Boundary Functions (BFs),\n          and Route Setup (RS) components.')
hprRtpRemTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8,8)).setFixedLength(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRemTcid.setDescription('The remote TCID of this RTP connection.')
hprRtpPathSwitchTrigger = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("ready", 1), ("switchPathNow", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hprRtpPathSwitchTrigger.setDescription('Object by which a Management Station can trigger an operator-\n          requested path switch, by setting the value to\n          switchPathNow(2).  Setting this object to switchPathNow(2)\n          triggers a path switch even if its previous value was already\n          switchPathNow(2).\n          The value ready(1) is returned on GET operations until a SET\n          has been processed; after that the value received on the most\n          recent SET is returned.\n\n          This MIB module provides no support for an operator-requested\n          switch to a specified path.')
hprRtpRscv = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRscv.setDescription('The forward Route Selection Control Vector for this RTP\n          connection.  The format of this vector is described in SNA\n          Formats.\n\n          The value returned in this object during a path switch is\n          implementation-dependent:  it may be the old path, the new\n          path, a zero-length string, or some other valid RSCV string.')
hprRtpTopic = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 8), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(8,8)).setFixedLength(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpTopic.setDescription('The topic for this RTP connection.  This is used to indicate\n          the Class of Service.')
hprRtpState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 99,))).clone(namedValues=NamedValues(("rtpListening", 1), ("rtpCalling", 2), ("rtpConnected", 3), ("rtpPathSwitching", 4), ("rtpDisconnecting", 5), ("other", 99),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpState.setDescription("The state of the RTP connection, from the perspective of the\n          local RTP protocol machine:\n              rtpListening      - connection open; waiting for other end\n                                  to call in\n              rtpCalling        - connection opened, attempting to call\n                                  out, have not yet received any data\n                                  from other end\n              rtpConnected      - connection is active; responded to a\n                                  call-in or received other end's TCID\n                                  from a call-out attempt\n              rtpPathSwitching  - the path switch timer is running;\n                                  attempting to find a new path for this\n                                  connection.\n              rtpDisconnecting  - no sessions are using this connection;\n                                  in process of bringing it down\n              other             - the connection is not in any of the\n                                  states listed above.")
hprRtpUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 10), TimeTicks()).setUnits('1/100ths of a second').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpUpTime.setDescription('The length of time the RTP connection has been up, measured\n          in 1/100ths of a second.')
hprRtpLivenessTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 11), Unsigned32()).setUnits('1/100ths of a second').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpLivenessTimer.setDescription('The value of the liveness (ALIVE) timer of this RTP\n          connection, in units of 1/100th of a second.  When this timer\n          expires and no packet has arrived from the partner since it\n          was last set, packets with Status Request indicators will be\n          sent to see if the RTP connection is still alive.')
hprRtpShortReqTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 12), Unsigned32()).setUnits('1/100ths of a second').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpShortReqTimer.setDescription('The value of the RTP SHORT-REQ timer, in units of 1/100 of a\n          second.  This timer represents the maximum time that a sender\n          waits for a reply from a receiver.')
hprRtpPathSwTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 13), Unsigned32()).setUnits('1/100ths of a second').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpPathSwTimer.setDescription('The length of time that RTP should attempt a path switch\n          for a connection, in units of 1/100th of a second.')
hprRtpLivenessTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 14), HprRtpCounter()).setUnits('liveness timeouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpLivenessTimeouts.setDescription('The count of liveness timeouts for this RTP connection.')
hprRtpShortReqTimeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 15), HprRtpCounter()).setUnits('short request timeouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpShortReqTimeouts.setDescription('The count of short request timeouts for this RTP connection.')
hprRtpMaxSendRate = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 16), Gauge32()).setUnits('bytes per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpMaxSendRate.setDescription("The high-water mark for this RTP connection's send rate, in\n          units of bytes per second.  This is the high-water mark for\n          the entire life of the connection, not just the high-water\n          mark for the connection's current path.\n          For more details on this and other parameters related to HPR,\n          see the High Performance Routing Architecture Reference.")
hprRtpMinSendRate = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 17), Gauge32()).setUnits('bytes per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpMinSendRate.setDescription("The low-water mark for this RTP connection's send rate, in\n          units of bytes per second.  This is the low-water mark for the\n          entire life of the connection, not just the low-water mark for\n          the connection's current path.\n\n          For more details on this and other parameters related to HPR,\n          see the High Performance Routing Architecture Reference.")
hprRtpCurSendRate = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 18), Gauge32()).setUnits('bytes per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpCurSendRate.setDescription('The current send rate for this RTP connection, in units of\n          bytes per second.\n\n          For more details on this and other parameters related to HPR,\n          see the High Performance Routing Architecture Reference.')
hprRtpSmRdTripDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 19), Gauge32()).setUnits('1/1000ths of a second').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpSmRdTripDelay.setDescription('The smoothed round trip delay for this RTP connection, in\n          units of 1/1000th of a second (ms).\n\n          For more details on this and other parameters related to HPR,\n          see the High Performance Routing Architecture Reference.')
hprRtpSendPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 20), HprRtpCounter()).setUnits('RTP packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpSendPackets.setDescription('The count of packets successfully sent on this RTP\n          connection.')
hprRtpRecvPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 21), HprRtpCounter()).setUnits('RTP packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRecvPackets.setDescription('The count of packets received on this RTP connection.  The\n          counter is incremented only once if duplicate copies of a\n          packet are received.')
hprRtpSendBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 22), HprRtpCounter()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpSendBytes.setDescription('The count of bytes sent on this RTP connection.  Both RTP\n          Transport Header (THDR) bytes and data bytes are included in\n          this count.')
hprRtpRecvBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 23), HprRtpCounter()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRecvBytes.setDescription('The count of bytes received on this RTP connection.  Both RTP\n          Transport Header (THDR) bytes and data bytes are included in\n          this count.')
hprRtpRetrPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 24), HprRtpCounter()).setUnits('RTP packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRetrPackets.setDescription('The count of packets retransmitted on this RTP connection.')
hprRtpPacketsDiscarded = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 25), HprRtpCounter()).setUnits('RTP packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpPacketsDiscarded.setDescription('The count of packets received on this RTP connection and then\n          discarded.  A packet may be discarded because it is determined\n          to be a duplicate, or for other reasons.')
hprRtpDetectGaps = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 26), HprRtpCounter()).setUnits('gaps').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpDetectGaps.setDescription('The count of gaps detected on this RTP connection.')
hprRtpRateReqSends = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 27), HprRtpCounter()).setUnits('rate requests').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpRateReqSends.setDescription('The count of Rate Requests sent on this RTP connection.')
hprRtpOkErrPathSws = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 28), HprRtpCounter()).setUnits('path switch attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpOkErrPathSws.setDescription('The count of successful path switch attempts for this RTP\n          connection due to errors.')
hprRtpBadErrPathSws = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 29), HprRtpCounter()).setUnits('path switch attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpBadErrPathSws.setDescription('The count of unsuccessful path switches for this RTP\n          connection due to errors.')
hprRtpOkOpPathSws = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 30), HprRtpCounter()).setUnits('path switches').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpOkOpPathSws.setDescription('The count of successful path switches for this RTP connection\n          due to operator requests.')
hprRtpBadOpPathSws = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 31), HprRtpCounter()).setUnits('path switches').setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpBadOpPathSws.setDescription('The count of unsuccessful path switches for this RTP\n          connection due to operator requests.  This counter is not\n          incremented by an implementation that does not support\n          operator-requested path switches, even if a Management Station\n          requests such a path switch by setting the\n          hprRtpPathSwitchTrigger object.')
hprRtpCounterDisconTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 2, 1, 32), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpCounterDisconTime.setDescription('The value of the sysUpTime object when the counters for this\n          RTP connection last experienced a discontinuity.  This will be\n          the more recent of two times:  the time at which the\n          connection was established or the time at which the HPR\n          counters were last turned on or off.')
hprRtpStatusTable = MibTable((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3), )
if mibBuilder.loadTexts: hprRtpStatusTable.setDescription('RTP Connection Status Table:  This table contains historical\n          information on RTP connections.  An entry is created in this\n          table when a path switch is completed, either successfully or\n          unsuccessfully.')
hprRtpStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1), ).setIndexNames((0, "HPR-MIB", "hprRtpStatusLocNceId"), (0, "HPR-MIB", "hprRtpStatusLocTcid"), (0, "HPR-MIB", "hprRtpStatusIndex"))
if mibBuilder.loadTexts: hprRtpStatusEntry.setDescription('This table is indexed by local NCE ID, local TCID, and an\n          integer hprRtpStatusIndex.  Thus the primary grouping of table\n          rows is by RTP connection, with the multiple entries for a\n          given RTP connection ordered by time.')
hprRtpStatusLocNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 1), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,8)))
if mibBuilder.loadTexts: hprRtpStatusLocNceId.setDescription('The local Network Connection Endpoint (NCE) of this RTP\n          connection.  NCEs identify CPs, LUs, Boundary Functions (BFs),\n          and Route Setup (RS) components.')
hprRtpStatusLocTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 2), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8,8)).setFixedLength(8))
if mibBuilder.loadTexts: hprRtpStatusLocTcid.setDescription('The local TCID of this RTP connection.')
hprRtpStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: hprRtpStatusIndex.setDescription('Table index.  This value begins at one and is incremented\n          when a new entry is added to the table.  It is an\n          implementation choice whether to run a single counter for\n          all entries in the table, or to run a separate counter for\n          the entries for each RTP connection.  In the unlikely event\n          of a wrap, it is assumed that Management Stations will have\n          the ability to order table entries correctly.')
hprRtpStatusStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusStartTime.setDescription('The time when the path switch began.')
hprRtpStatusEndTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusEndTime.setDescription('The time when the path switch was ended, either successfully\n          or unsuccessfully.')
hprRtpStatusRemCpName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 6), SnaControlPointName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusRemCpName.setDescription('Administratively assigned network name for the remote node of\n          this RTP connection.')
hprRtpStatusRemNceId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1,8))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusRemNceId.setDescription('The remote Network Connection Endpoint (NCE) of this RTP\n          connection.  NCEs identify CPs, LUs, Boundary Functions (BFs),\n          and Route Setup (RS) components.')
hprRtpStatusRemTcid = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 8), OctetString().subtype(subtypeSpec=ValueSizeConstraint(8,8)).setFixedLength(8)).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusRemTcid.setDescription('The remote TCID of this RTP connection.')
hprRtpStatusNewRscv = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusNewRscv.setDescription('The new Route Selection Control Vector for this RTP\n          connection.  A zero-length string indicates that no value is\n          available, perhaps because the implementation does not save\n          RSCVs.')
hprRtpStatusOldRscv = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusOldRscv.setDescription('The old Route Selection Control Vector for this RTP\n          connection.  A zero-length string indicates that no value is\n          available, perhaps because the implementation does not save\n          RSCVs.')
hprRtpStatusCause = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("other", 1), ("rtpConnFail", 2), ("locLinkFail", 3), ("remLinkFail", 4), ("operRequest", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusCause.setDescription('The reason for the path switch:\n\n               other(1)       - Reason other than those listed below,\n               rtpConnFail(2) - RTP connection failure detected,\n               locLinkFail(3) - Local link failure,\n               remLinkFail(4) - Remote link failure (learned from TDUs),\n               operRequest(5) - Operator requested path switch. ')
hprRtpStatusLastAttemptResult = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 6, 1, 4, 3, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("successful", 1), ("initiatorMoving", 2), ("directorySearchFailed", 3), ("rscvCalculationFailed", 4), ("negativeRouteSetupReply", 5), ("backoutRouteSetupReply", 6), ("timeoutDuringFirstAttempt", 7), ("otherUnsuccessful", 8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hprRtpStatusLastAttemptResult.setDescription("The result of the last completed path switch attempt.  If the\n          path switch is aborted in the middle of a path switch attempt\n          because the path switch timer expires, the result of the\n          previous path switch attempt is reported.\n\n          The values are defined as follows:\n\n             successful(1)                - The final path switch\n                                            attempt was successful.\n             initiatorMoving(2)           - The final path switch\n                                            attempt failed because the\n                                            initiator is mobile, and\n                                            there was no active link\n                                            out of this node.\n             directorySearchFailed(3)     - The final path switch\n                                            attempt failed because a\n                                            directory search for the\n                                            destination node's CP name\n                                            failed.\n             rscvCalculationFailed(4)     - The final path switch\n                                            attempt failed because an\n                                            RSCV to the node containing\n                                            the remote RTP endpoint\n                                            could not be calculated.\n             negativeRouteSetupReply(5)   - The final path switch\n                                            attempt failed because route\n                                            setup failed for the new\n                                            path.\n             backoutRouteSetupReply(6)    - The final path switch\n                                            attempt failed because the\n                                            remote RTP endpoint refused\n                                            to continue the RTP\n                                            connection.\n             timeoutDuringFirstAttempt(7) - The path switch timer\n                                            expired during the first\n                                            path switch attempt.\n             otherUnsuccessful(8)         - The final path switch\n                                            attempt failed for a reason\n                                            other than those listed\n                                            above.")
hprConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 2))
hprCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 2, 1))
hprGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 6, 2, 2))
hprCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 34, 6, 2, 1, 1)).setObjects(*(("HPR-MIB", "hprGlobalConfGroup"), ("HPR-MIB", "hprAnrRoutingConfGroup"), ("HPR-MIB", "hprTransportUserConfGroup"), ("HPR-MIB", "hprRtpConfGroup"),))
if mibBuilder.loadTexts: hprCompliance.setDescription('The compliance statement for the SNMPv2 entities that\n          implement the HPR MIB.')
hprGlobalConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 6, 2, 2, 1)).setObjects(*(("HPR-MIB", "hprNodeCpName"), ("HPR-MIB", "hprOperatorPathSwitchSupport"),))
if mibBuilder.loadTexts: hprGlobalConfGroup.setDescription('A collection of objects providing the instrumentation of HPR\n          general information and capabilities.')
hprAnrRoutingConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 6, 2, 2, 2)).setObjects(*(("HPR-MIB", "hprAnrsAssigned"), ("HPR-MIB", "hprAnrCounterState"), ("HPR-MIB", "hprAnrCounterStateTime"), ("HPR-MIB", "hprAnrType"), ("HPR-MIB", "hprAnrOutTgDest"), ("HPR-MIB", "hprAnrOutTgNum"), ("HPR-MIB", "hprAnrPacketsReceived"), ("HPR-MIB", "hprAnrCounterDisconTime"),))
if mibBuilder.loadTexts: hprAnrRoutingConfGroup.setDescription("A collection of objects providing instrumentation for the\n          node's ANR routing.")
hprTransportUserConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 6, 2, 2, 3)).setObjects(*(("HPR-MIB", "hprNceType"), ("HPR-MIB", "hprNceDefault"), ("HPR-MIB", "hprNceInstanceId"),))
if mibBuilder.loadTexts: hprTransportUserConfGroup.setDescription('A collection of objects providing information on the users of\n          the HPR transport known to the node.')
hprRtpConfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 6, 2, 2, 4)).setObjects(*(("HPR-MIB", "hprRtpGlobeConnSetups"), ("HPR-MIB", "hprRtpGlobeCtrState"), ("HPR-MIB", "hprRtpGlobeCtrStateTime"), ("HPR-MIB", "hprRtpRemCpName"), ("HPR-MIB", "hprRtpRemNceId"), ("HPR-MIB", "hprRtpRemTcid"), ("HPR-MIB", "hprRtpPathSwitchTrigger"), ("HPR-MIB", "hprRtpRscv"), ("HPR-MIB", "hprRtpTopic"), ("HPR-MIB", "hprRtpState"), ("HPR-MIB", "hprRtpUpTime"), ("HPR-MIB", "hprRtpLivenessTimer"), ("HPR-MIB", "hprRtpShortReqTimer"), ("HPR-MIB", "hprRtpPathSwTimer"), ("HPR-MIB", "hprRtpLivenessTimeouts"), ("HPR-MIB", "hprRtpShortReqTimeouts"), ("HPR-MIB", "hprRtpMaxSendRate"), ("HPR-MIB", "hprRtpMinSendRate"), ("HPR-MIB", "hprRtpCurSendRate"), ("HPR-MIB", "hprRtpSmRdTripDelay"), ("HPR-MIB", "hprRtpSendPackets"), ("HPR-MIB", "hprRtpRecvPackets"), ("HPR-MIB", "hprRtpSendBytes"), ("HPR-MIB", "hprRtpRecvBytes"), ("HPR-MIB", "hprRtpRetrPackets"), ("HPR-MIB", "hprRtpPacketsDiscarded"), ("HPR-MIB", "hprRtpDetectGaps"), ("HPR-MIB", "hprRtpRateReqSends"), ("HPR-MIB", "hprRtpOkErrPathSws"), ("HPR-MIB", "hprRtpBadErrPathSws"), ("HPR-MIB", "hprRtpOkOpPathSws"), ("HPR-MIB", "hprRtpBadOpPathSws"), ("HPR-MIB", "hprRtpCounterDisconTime"), ("HPR-MIB", "hprRtpStatusStartTime"), ("HPR-MIB", "hprRtpStatusEndTime"), ("HPR-MIB", "hprRtpStatusRemNceId"), ("HPR-MIB", "hprRtpStatusRemTcid"), ("HPR-MIB", "hprRtpStatusRemCpName"), ("HPR-MIB", "hprRtpStatusNewRscv"), ("HPR-MIB", "hprRtpStatusOldRscv"), ("HPR-MIB", "hprRtpStatusCause"), ("HPR-MIB", "hprRtpStatusLastAttemptResult"),))
if mibBuilder.loadTexts: hprRtpConfGroup.setDescription('A collection of objects providing the instrumentation for RTP\n          connection end points.')
mibBuilder.exportSymbols("HPR-MIB", hprRtpRateReqSends=hprRtpRateReqSends, hprRtpDetectGaps=hprRtpDetectGaps, hprOperatorPathSwitchSupport=hprOperatorPathSwitchSupport, hprRtpLivenessTimeouts=hprRtpLivenessTimeouts, hprRtpMaxSendRate=hprRtpMaxSendRate, hprAnrOutTgNum=hprAnrOutTgNum, hprGlobal=hprGlobal, hprRtpCurSendRate=hprRtpCurSendRate, hprTransportUserConfGroup=hprTransportUserConfGroup, hprRtpRecvBytes=hprRtpRecvBytes, hprAnrRoutingEntry=hprAnrRoutingEntry, hprRtpGlobeConnSetups=hprRtpGlobeConnSetups, hprRtpStatusNewRscv=hprRtpStatusNewRscv, hprNceTable=hprNceTable, hprNceType=hprNceType, hprConformance=hprConformance, hprRtpPacketsDiscarded=hprRtpPacketsDiscarded, hprTransportUser=hprTransportUser, hprGroups=hprGroups, hprAnrPacketsReceived=hprAnrPacketsReceived, hprRtpStatusIndex=hprRtpStatusIndex, hprRtpRscv=hprRtpRscv, hprAnrLabel=hprAnrLabel, hprRtpTopic=hprRtpTopic, HprRtpCounter=HprRtpCounter, hprRtpUpTime=hprRtpUpTime, hprRtpRecvPackets=hprRtpRecvPackets, hprRtpSendPackets=hprRtpSendPackets, PYSNMP_MODULE_ID=hprMIB, hprRtpGlobeCtrState=hprRtpGlobeCtrState, hprRtpStatusLastAttemptResult=hprRtpStatusLastAttemptResult, hprGlobalConfGroup=hprGlobalConfGroup, hprRtp=hprRtp, hprRtpPathSwTimer=hprRtpPathSwTimer, hprRtpCounterDisconTime=hprRtpCounterDisconTime, hprAnrCounterState=hprAnrCounterState, hprAnrOutTgDest=hprAnrOutTgDest, hprRtpState=hprRtpState, hprRtpEntry=hprRtpEntry, hprRtpRemNceId=hprRtpRemNceId, hprAnrRouting=hprAnrRouting, hprRtpOkOpPathSws=hprRtpOkOpPathSws, hprAnrsAssigned=hprAnrsAssigned, hprRtpShortReqTimer=hprRtpShortReqTimer, hprRtpStatusRemTcid=hprRtpStatusRemTcid, hprCompliances=hprCompliances, hprAnrRoutingTable=hprAnrRoutingTable, hprRtpRemTcid=hprRtpRemTcid, hprNodeCpName=hprNodeCpName, hprRtpOkErrPathSws=hprRtpOkErrPathSws, hprRtpStatusOldRscv=hprRtpStatusOldRscv, hprRtpSendBytes=hprRtpSendBytes, hprRtpStatusEndTime=hprRtpStatusEndTime, hprRtpGlobe=hprRtpGlobe, hprRtpBadOpPathSws=hprRtpBadOpPathSws, hprRtpSmRdTripDelay=hprRtpSmRdTripDelay, HprNceTypes=HprNceTypes, hprRtpStatusRemNceId=hprRtpStatusRemNceId, hprAnrType=hprAnrType, hprRtpStatusStartTime=hprRtpStatusStartTime, hprMIB=hprMIB, hprRtpConfGroup=hprRtpConfGroup, hprNceEntry=hprNceEntry, hprNceId=hprNceId, hprRtpStatusEntry=hprRtpStatusEntry, hprRtpGlobeCtrStateTime=hprRtpGlobeCtrStateTime, hprRtpStatusLocTcid=hprRtpStatusLocTcid, hprRtpStatusTable=hprRtpStatusTable, hprAnrCounterStateTime=hprAnrCounterStateTime, hprRtpPathSwitchTrigger=hprRtpPathSwitchTrigger, hprRtpStatusRemCpName=hprRtpStatusRemCpName, hprRtpLocNceId=hprRtpLocNceId, hprRtpRemCpName=hprRtpRemCpName, hprRtpBadErrPathSws=hprRtpBadErrPathSws, hprCompliance=hprCompliance, hprRtpStatusCause=hprRtpStatusCause, hprRtpTable=hprRtpTable, hprAnrRoutingConfGroup=hprAnrRoutingConfGroup, hprObjects=hprObjects, hprRtpRetrPackets=hprRtpRetrPackets, hprRtpLivenessTimer=hprRtpLivenessTimer, hprAnrCounterDisconTime=hprAnrCounterDisconTime, hprRtpShortReqTimeouts=hprRtpShortReqTimeouts, hprNceDefault=hprNceDefault, hprRtpStatusLocNceId=hprRtpStatusLocNceId, hprRtpLocTcid=hprRtpLocTcid, hprRtpMinSendRate=hprRtpMinSendRate, hprNceInstanceId=hprNceInstanceId)
