# Generated by OTF2 Template Engine

import _otf2

from . import events


def _generate_doc_from(event):
    def decorator(func):
        doc_str = "Writes a new :py:class:`otf2.events.{}` event to the corresponding location of \
                  the writer.\n".format(event.__name__)
        doc_str += "\n"

        for name, type, desc in event._fields:
            if type.endswith("Ref"):
                type = "otf2.definitions.{}".format(type[:-3])
            elif "int" in type:
                type = "int"
            elif type.startswith("dict"):
                pass
            elif type.startswith("array"):
                pass
            else:
                type = "otf2.{}".format(type)
            doc_str += ":param {type} {name}: {desc}\n".format(name=name, type=type, desc=desc)
        func.__doc__ = doc_str
        return func
    return decorator


class EventWriter(object):
    def __init__(self, archive, location):
        assert archive
        assert location
        self._archive = archive
        self._location = location

        # Not used yet, but to prevent false errors, when reading
        self._def_handle = _otf2.Archive_GetDefWriter(archive._handle, location._ref)

        self._handle = _otf2.Archive_GetEvtWriter(archive._handle, location._ref)

        location._number_of_events_written = 0

    def close(self):
        _otf2.Archive_CloseDefWriter(self._archive._handle, self._def_handle)
        _otf2.Archive_CloseEvtWriter(self._archive._handle, self._handle)

    def write(self, event):
        """
            Writes a given event to the corresponding location

            :param event: :py:class:`otf2.events._Event`
        """
        self._archive._update_timestamps(event.time)
        self._location._number_of_events_written += 1
        event._write(self)

    @property
    def handle(self):
        """
            Gives access to the underlaying OTF2 event writer
        """
        return self._handle

    def __call__(self, event):
        self.write(event)
@otf2 for event in events:

    @_generate_doc_from(events.@@event.name@@)
    def @@event.lower@@(self, time, *args, **kwargs):
        self.write(events.@@event.name@@(time, *args, **kwargs))
@otf2 endfor
@otf2 for event in events:

    def _@@event.lower@@(self, attribute_list, time@@event.py_funcargs(case='lower', attributes=event.all_value_attributes)@@):
        _otf2.EvtWriter_@@event.name@@(self._handle, attribute_list, time@@event.py_funcargs(case='lower', attributes=event.all_value_attributes)@@)
@otf2 endfor
