## Copyright (C) 2007 Muthiah Annamalai <muthiah.annamalai@uta.edu>
## Copyright (C) 2012 Carnë Draug <carandraug+dev@gmail.com>
##
## This program is free software; you can redistribute it and/or modify it under
## the terms of the GNU General Public License as published by the Free Software
## Foundation; either version 3 of the License, or (at your option) any later
## version.
##
## This program is distributed in the hope that it will be useful, but WITHOUT
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
## FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
## details.
##
## You should have received a copy of the GNU General Public License along with
## this program; if not, see <http://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {Function File} {[@var{names}] =} physical_constant
## @deftypefnx {Function File} {[@var{val}, @var{uncertainty}, @var{unit}] =} physical_constant (@var{name})
## @deftypefnx {Function File} {[@var{constants}] =} physical_constant ("all")
## Get physical constant @var{arg}.
##
## If no arguments are given, returns a cell array with all possible @var{name}s.
## Alternatively, @var{name} can be `all' in which case @var{val} is a structure
## array with 4 fields (name, value, uncertainty, units).
##
## Since the long list of values needs to be parsed on each call to this function
## it is much more efficient to store the values in a variable rather make multiple
## calls to this function with the same argument
##
## The values are the ones recommended by CODATA. This function was autogenerated
## on Tue Jan 10 14:20:56 2017 from NIST database at @uref{http://physics.nist.gov/constants}
## @end deftypefn

## DO NOT EDIT THIS FILE
## This function file is generated automatically by physical_constant.py

function [rval, uncert, unit] = physical_constant (arg)

  persistent unit_data;
  if (isempty(unit_data))
    unit_data = get_data;
  endif

  if (nargin > 1 || (nargin == 1 && !ischar (arg)))
    print_usage;
  elseif (nargin == 0)
    rval = reshape ({unit_data(:).name}, size (unit_data));
    return
  elseif (nargin == 1 && strcmpi (arg, "all"))
    rval = unit_data;
    return
  endif

  val = reshape ({unit_data(:).name}, size (unit_data));
  map = strcmpi (val, arg);
  if (any (map))
    val     = unit_data(map);
    rval    = val.value;
    uncert  = val.uncertainty;
    unit    = val.units;
  else
    error ("No constant with name '%s' found", arg)
  endif
endfunction

function unit_data = get_data
  unit_data(1).name        = "Angstrom star";
  unit_data(1).value       = 1.00001495e-10;
  unit_data(1).uncertainty = 0.00000090e-10;
  unit_data(1).units       = "m";

  unit_data(2).name        = "Avogadro constant";
  unit_data(2).value       = 6.022140857e23;
  unit_data(2).uncertainty = 0.000000074e23;
  unit_data(2).units       = "mol^-1";

  unit_data(3).name        = "Bohr magneton";
  unit_data(3).value       = 927.4009994e-26;
  unit_data(3).uncertainty = 0.0000057e-26;
  unit_data(3).units       = "J T^-1";

  unit_data(4).name        = "Bohr magneton in Hz/T";
  unit_data(4).value       = 13.996245042e9;
  unit_data(4).uncertainty = 0.000000086e9;
  unit_data(4).units       = "Hz T^-1";

  unit_data(5).name        = "Bohr magneton in K/T";
  unit_data(5).value       = 0.67171405;
  unit_data(5).uncertainty = 0.00000039;
  unit_data(5).units       = "K T^-1";

  unit_data(6).name        = "Bohr magneton in eV/T";
  unit_data(6).value       = 5.7883818012e-5;
  unit_data(6).uncertainty = 0.0000000026e-5;
  unit_data(6).units       = "eV T^-1";

  unit_data(7).name        = "Bohr magneton in inverse meters per tesla";
  unit_data(7).value       = 46.68644814;
  unit_data(7).uncertainty = 0.00000029;
  unit_data(7).units       = "m^-1 T^-1";

  unit_data(8).name        = "Bohr radius";
  unit_data(8).value       = 0.52917721067e-10;
  unit_data(8).uncertainty = 0.00000000012e-10;
  unit_data(8).units       = "m";

  unit_data(9).name        = "Boltzmann constant";
  unit_data(9).value       = 1.38064852e-23;
  unit_data(9).uncertainty = 0.00000079e-23;
  unit_data(9).units       = "J K^-1";

  unit_data(10).name        = "Boltzmann constant in Hz/K";
  unit_data(10).value       = 2.0836612e10;
  unit_data(10).uncertainty = 0.0000012e10;
  unit_data(10).units       = "Hz K^-1";

  unit_data(11).name        = "Boltzmann constant in eV/K";
  unit_data(11).value       = 8.6173303e-5;
  unit_data(11).uncertainty = 0.0000050e-5;
  unit_data(11).units       = "eV K^-1";

  unit_data(12).name        = "Boltzmann constant in inverse meters per kelvin";
  unit_data(12).value       = 69.503457;
  unit_data(12).uncertainty = 0.000040;
  unit_data(12).units       = "m^-1 K^-1";

  unit_data(13).name        = "Compton wavelength";
  unit_data(13).value       = 2.4263102367e-12;
  unit_data(13).uncertainty = 0.0000000011e-12;
  unit_data(13).units       = "m";

  unit_data(14).name        = "Compton wavelength over 2 pi";
  unit_data(14).value       = 386.15926764e-15;
  unit_data(14).uncertainty = 0.00000018e-15;
  unit_data(14).units       = "m";

  unit_data(15).name        = "Cu x unit";
  unit_data(15).value       = 1.00207697e-13;
  unit_data(15).uncertainty = 0.00000028e-13;
  unit_data(15).units       = "m";

  unit_data(16).name        = "Faraday constant";
  unit_data(16).value       = 96485.33289;
  unit_data(16).uncertainty = 0.00059;
  unit_data(16).units       = "C mol^-1";

  unit_data(17).name        = "Faraday constant for conventional electric current";
  unit_data(17).value       = 96485.3251;
  unit_data(17).uncertainty = 0.0012;
  unit_data(17).units       = "C_90 mol^-1";

  unit_data(18).name        = "Fermi coupling constant";
  unit_data(18).value       = 1.1663787e-5;
  unit_data(18).uncertainty = 0.0000006e-5;
  unit_data(18).units       = "GeV^-2";

  unit_data(19).name        = "Hartree energy";
  unit_data(19).value       = 4.359744650e-18;
  unit_data(19).uncertainty = 0.000000054e-18;
  unit_data(19).units       = "J";

  unit_data(20).name        = "Hartree energy in eV";
  unit_data(20).value       = 27.21138602;
  unit_data(20).uncertainty = 0.00000017;
  unit_data(20).units       = "eV";

  unit_data(21).name        = "Josephson constant";
  unit_data(21).value       = 483597.8525e9;
  unit_data(21).uncertainty = 0.0030e9;
  unit_data(21).units       = "Hz V^-1";

  unit_data(22).name        = "Loschmidt constant (273.15 K, 100 kPa)";
  unit_data(22).value       = 2.6516467e25;
  unit_data(22).uncertainty = 0.0000015e25;
  unit_data(22).units       = "m^-3";

  unit_data(23).name        = "Loschmidt constant (273.15 K, 101.325 kPa)";
  unit_data(23).value       = 2.6867811e25;
  unit_data(23).uncertainty = 0.0000015e25;
  unit_data(23).units       = "m^-3";

  unit_data(24).name        = "Mo x unit";
  unit_data(24).value       = 1.00209952e-13;
  unit_data(24).uncertainty = 0.00000053e-13;
  unit_data(24).units       = "m";

  unit_data(25).name        = "Newtonian constant of gravitation";
  unit_data(25).value       = 6.67408e-11;
  unit_data(25).uncertainty = 0.00031e-11;
  unit_data(25).units       = "m^3 kg^-1 s^-2";

  unit_data(26).name        = "Newtonian constant of gravitation over h-bar c";
  unit_data(26).value       = 6.70861e-39;
  unit_data(26).uncertainty = 0.00031e-39;
  unit_data(26).units       = "(GeV/c^2)^-2";

  unit_data(27).name        = "Planck constant";
  unit_data(27).value       = 6.626070040e-34;
  unit_data(27).uncertainty = 0.000000081e-34;
  unit_data(27).units       = "J s";

  unit_data(28).name        = "Planck constant in eV s";
  unit_data(28).value       = 4.135667662e-15;
  unit_data(28).uncertainty = 0.000000025e-15;
  unit_data(28).units       = "eV s";

  unit_data(29).name        = "Planck constant over 2 pi";
  unit_data(29).value       = 1.054571800e-34;
  unit_data(29).uncertainty = 0.000000013e-34;
  unit_data(29).units       = "J s";

  unit_data(30).name        = "Planck constant over 2 pi in eV s";
  unit_data(30).value       = 6.582119514e-16;
  unit_data(30).uncertainty = 0.000000040e-16;
  unit_data(30).units       = "eV s";

  unit_data(31).name        = "Planck constant over 2 pi times c in MeV fm";
  unit_data(31).value       = 197.3269788;
  unit_data(31).uncertainty = 0.0000012;
  unit_data(31).units       = "MeV fm";

  unit_data(32).name        = "Planck length";
  unit_data(32).value       = 1.616229e-35;
  unit_data(32).uncertainty = 0.000038e-35;
  unit_data(32).units       = "m";

  unit_data(33).name        = "Planck mass";
  unit_data(33).value       = 2.176470e-8;
  unit_data(33).uncertainty = 0.000051e-8;
  unit_data(33).units       = "kg";

  unit_data(34).name        = "Planck mass energy equivalent in GeV";
  unit_data(34).value       = 1.220910e19;
  unit_data(34).uncertainty = 0.000029e19;
  unit_data(34).units       = "GeV";

  unit_data(35).name        = "Planck temperature";
  unit_data(35).value       = 1.416808e32;
  unit_data(35).uncertainty = 0.000033e32;
  unit_data(35).units       = "K";

  unit_data(36).name        = "Planck time";
  unit_data(36).value       = 5.39116e-44;
  unit_data(36).uncertainty = 0.00013e-44;
  unit_data(36).units       = "s";

  unit_data(37).name        = "Rydberg constant";
  unit_data(37).value       = 10973731.568508;
  unit_data(37).uncertainty = 0.000065;
  unit_data(37).units       = "m^-1";

  unit_data(38).name        = "Rydberg constant times c in Hz";
  unit_data(38).value       = 3.289841960355e15;
  unit_data(38).uncertainty = 0.000000000019e15;
  unit_data(38).units       = "Hz";

  unit_data(39).name        = "Rydberg constant times hc in J";
  unit_data(39).value       = 2.179872325e-18;
  unit_data(39).uncertainty = 0.000000027e-18;
  unit_data(39).units       = "J";

  unit_data(40).name        = "Rydberg constant times hc in eV";
  unit_data(40).value       = 13.605693009;
  unit_data(40).uncertainty = 0.000000084;
  unit_data(40).units       = "eV";

  unit_data(41).name        = "Sackur-Tetrode constant (1 K, 100 kPa)";
  unit_data(41).value       = -1.1517084;
  unit_data(41).uncertainty = 0.0000014;
  unit_data(41).units       = "";

  unit_data(42).name        = "Sackur-Tetrode constant (1 K, 101.325 kPa)";
  unit_data(42).value       = -1.1648714;
  unit_data(42).uncertainty = 0.0000014;
  unit_data(42).units       = "";

  unit_data(43).name        = "Stefan-Boltzmann constant";
  unit_data(43).value       = 5.670367e-8;
  unit_data(43).uncertainty = 0.000013e-8;
  unit_data(43).units       = "W m^-2 K^-4";

  unit_data(44).name        = "Thomson cross section";
  unit_data(44).value       = 0.66524587158e-28;
  unit_data(44).uncertainty = 0.00000000091e-28;
  unit_data(44).units       = "m^2";

  unit_data(45).name        = "Wien frequency displacement law constant";
  unit_data(45).value       = 5.8789238e10;
  unit_data(45).uncertainty = 0.0000034e10;
  unit_data(45).units       = "Hz K^-1";

  unit_data(46).name        = "Wien wavelength displacement law constant";
  unit_data(46).value       = 2.8977729e-3;
  unit_data(46).uncertainty = 0.0000017e-3;
  unit_data(46).units       = "m K";

  unit_data(47).name        = "alpha particle mass";
  unit_data(47).value       = 6.644657230e-27;
  unit_data(47).uncertainty = 0.000000082e-27;
  unit_data(47).units       = "kg";

  unit_data(48).name        = "alpha particle mass energy equivalent";
  unit_data(48).value       = 5.971920097e-10;
  unit_data(48).uncertainty = 0.000000073e-10;
  unit_data(48).units       = "J";

  unit_data(49).name        = "alpha particle mass energy equivalent in MeV";
  unit_data(49).value       = 3727.379378;
  unit_data(49).uncertainty = 0.000023;
  unit_data(49).units       = "MeV";

  unit_data(50).name        = "alpha particle mass in u";
  unit_data(50).value       = 4.001506179127;
  unit_data(50).uncertainty = 0.000000000063;
  unit_data(50).units       = "u";

  unit_data(51).name        = "alpha particle molar mass";
  unit_data(51).value       = 4.001506179127e-3;
  unit_data(51).uncertainty = 0.000000000063e-3;
  unit_data(51).units       = "kg mol^-1";

  unit_data(52).name        = "alpha particle-electron mass ratio";
  unit_data(52).value       = 7294.29954136;
  unit_data(52).uncertainty = 0.00000024;
  unit_data(52).units       = "";

  unit_data(53).name        = "alpha particle-proton mass ratio";
  unit_data(53).value       = 3.97259968907;
  unit_data(53).uncertainty = 0.00000000036;
  unit_data(53).units       = "";

  unit_data(54).name        = "atomic mass constant";
  unit_data(54).value       = 1.660539040e-27;
  unit_data(54).uncertainty = 0.000000020e-27;
  unit_data(54).units       = "kg";

  unit_data(55).name        = "atomic mass constant energy equivalent";
  unit_data(55).value       = 1.492418062e-10;
  unit_data(55).uncertainty = 0.000000018e-10;
  unit_data(55).units       = "J";

  unit_data(56).name        = "atomic mass constant energy equivalent in MeV";
  unit_data(56).value       = 931.4940954;
  unit_data(56).uncertainty = 0.0000057;
  unit_data(56).units       = "MeV";

  unit_data(57).name        = "atomic mass unit-electron volt relationship";
  unit_data(57).value       = 931.4940954e6;
  unit_data(57).uncertainty = 0.0000057e6;
  unit_data(57).units       = "eV";

  unit_data(58).name        = "atomic mass unit-hartree relationship";
  unit_data(58).value       = 3.4231776902e7;
  unit_data(58).uncertainty = 0.0000000016e7;
  unit_data(58).units       = "E_h";

  unit_data(59).name        = "atomic mass unit-hertz relationship";
  unit_data(59).value       = 2.2523427206e23;
  unit_data(59).uncertainty = 0.0000000010e23;
  unit_data(59).units       = "Hz";

  unit_data(60).name        = "atomic mass unit-inverse meter relationship";
  unit_data(60).value       = 7.5130066166e14;
  unit_data(60).uncertainty = 0.0000000034e14;
  unit_data(60).units       = "m^-1";

  unit_data(61).name        = "atomic mass unit-joule relationship";
  unit_data(61).value       = 1.492418062e-10;
  unit_data(61).uncertainty = 0.000000018e-10;
  unit_data(61).units       = "J";

  unit_data(62).name        = "atomic mass unit-kelvin relationship";
  unit_data(62).value       = 1.08095438e13;
  unit_data(62).uncertainty = 0.00000062e13;
  unit_data(62).units       = "K";

  unit_data(63).name        = "atomic mass unit-kilogram relationship";
  unit_data(63).value       = 1.660539040e-27;
  unit_data(63).uncertainty = 0.000000020e-27;
  unit_data(63).units       = "kg";

  unit_data(64).name        = "atomic unit of 1st hyperpolarizability";
  unit_data(64).value       = 3.206361329e-53;
  unit_data(64).uncertainty = 0.000000020e-53;
  unit_data(64).units       = "C^3 m^3 J^-2";

  unit_data(65).name        = "atomic unit of 2nd hyperpolarizability";
  unit_data(65).value       = 6.235380085e-65;
  unit_data(65).uncertainty = 0.000000077e-65;
  unit_data(65).units       = "C^4 m^4 J^-3";

  unit_data(66).name        = "atomic unit of action";
  unit_data(66).value       = 1.054571800e-34;
  unit_data(66).uncertainty = 0.000000013e-34;
  unit_data(66).units       = "J s";

  unit_data(67).name        = "atomic unit of charge";
  unit_data(67).value       = 1.6021766208e-19;
  unit_data(67).uncertainty = 0.0000000098e-19;
  unit_data(67).units       = "C";

  unit_data(68).name        = "atomic unit of charge density";
  unit_data(68).value       = 1.0812023770e12;
  unit_data(68).uncertainty = 0.0000000067e12;
  unit_data(68).units       = "C m^-3";

  unit_data(69).name        = "atomic unit of current";
  unit_data(69).value       = 6.623618183e-3;
  unit_data(69).uncertainty = 0.000000041e-3;
  unit_data(69).units       = "A";

  unit_data(70).name        = "atomic unit of electric dipole mom.";
  unit_data(70).value       = 8.478353552e-30;
  unit_data(70).uncertainty = 0.000000052e-30;
  unit_data(70).units       = "C m";

  unit_data(71).name        = "atomic unit of electric field";
  unit_data(71).value       = 5.142206707e11;
  unit_data(71).uncertainty = 0.000000032e11;
  unit_data(71).units       = "V m^-1";

  unit_data(72).name        = "atomic unit of electric field gradient";
  unit_data(72).value       = 9.717362356e21;
  unit_data(72).uncertainty = 0.000000060e21;
  unit_data(72).units       = "V m^-2";

  unit_data(73).name        = "atomic unit of electric polarizability";
  unit_data(73).value       = 1.6487772731e-41;
  unit_data(73).uncertainty = 0.0000000011e-41;
  unit_data(73).units       = "C^2 m^2 J^-1";

  unit_data(74).name        = "atomic unit of electric potential";
  unit_data(74).value       = 27.21138602;
  unit_data(74).uncertainty = 0.00000017;
  unit_data(74).units       = "V";

  unit_data(75).name        = "atomic unit of electric quadrupole mom.";
  unit_data(75).value       = 4.486551484e-40;
  unit_data(75).uncertainty = 0.000000028e-40;
  unit_data(75).units       = "C m^2";

  unit_data(76).name        = "atomic unit of energy";
  unit_data(76).value       = 4.359744650e-18;
  unit_data(76).uncertainty = 0.000000054e-18;
  unit_data(76).units       = "J";

  unit_data(77).name        = "atomic unit of force";
  unit_data(77).value       = 8.23872336e-8;
  unit_data(77).uncertainty = 0.00000010e-8;
  unit_data(77).units       = "N";

  unit_data(78).name        = "atomic unit of length";
  unit_data(78).value       = 0.52917721067e-10;
  unit_data(78).uncertainty = 0.00000000012e-10;
  unit_data(78).units       = "m";

  unit_data(79).name        = "atomic unit of mag. dipole mom.";
  unit_data(79).value       = 1.854801999e-23;
  unit_data(79).uncertainty = 0.000000011e-23;
  unit_data(79).units       = "J T^-1";

  unit_data(80).name        = "atomic unit of mag. flux density";
  unit_data(80).value       = 2.350517550e5;
  unit_data(80).uncertainty = 0.000000014e5;
  unit_data(80).units       = "T";

  unit_data(81).name        = "atomic unit of magnetizability";
  unit_data(81).value       = 7.8910365886e-29;
  unit_data(81).uncertainty = 0.0000000090e-29;
  unit_data(81).units       = "J T^-2";

  unit_data(82).name        = "atomic unit of mass";
  unit_data(82).value       = 9.10938356e-31;
  unit_data(82).uncertainty = 0.00000011e-31;
  unit_data(82).units       = "kg";

  unit_data(83).name        = "atomic unit of mom.um";
  unit_data(83).value       = 1.992851882e-24;
  unit_data(83).uncertainty = 0.000000024e-24;
  unit_data(83).units       = "kg m s^-1";

  unit_data(84).name        = "atomic unit of permittivity";
  unit_data(84).value       = 1.112650056e-10;
  unit_data(84).uncertainty = 0.0;
  unit_data(84).units       = "F m^-1";

  unit_data(85).name        = "atomic unit of time";
  unit_data(85).value       = 2.418884326509e-17;
  unit_data(85).uncertainty = 0.000000000014e-17;
  unit_data(85).units       = "s";

  unit_data(86).name        = "atomic unit of velocity";
  unit_data(86).value       = 2.18769126277e6;
  unit_data(86).uncertainty = 0.00000000050e6;
  unit_data(86).units       = "m s^-1";

  unit_data(87).name        = "characteristic impedance of vacuum";
  unit_data(87).value       = 376.730313461;
  unit_data(87).uncertainty = 0.0;
  unit_data(87).units       = "ohm";

  unit_data(88).name        = "classical electron radius";
  unit_data(88).value       = 2.8179403227e-15;
  unit_data(88).uncertainty = 0.0000000019e-15;
  unit_data(88).units       = "m";

  unit_data(89).name        = "conductance quantum";
  unit_data(89).value       = 7.7480917310e-5;
  unit_data(89).uncertainty = 0.0000000018e-5;
  unit_data(89).units       = "S";

  unit_data(90).name        = "conventional value of Josephson constant";
  unit_data(90).value       = 483597.9e9;
  unit_data(90).uncertainty = 0.0;
  unit_data(90).units       = "Hz V^-1";

  unit_data(91).name        = "conventional value of von Klitzing constant";
  unit_data(91).value       = 25812.807;
  unit_data(91).uncertainty = 0.0;
  unit_data(91).units       = "ohm";

  unit_data(92).name        = "deuteron g factor";
  unit_data(92).value       = 0.8574382311;
  unit_data(92).uncertainty = 0.0000000048;
  unit_data(92).units       = "";

  unit_data(93).name        = "deuteron mag. mom.";
  unit_data(93).value       = 0.4330735040e-26;
  unit_data(93).uncertainty = 0.0000000036e-26;
  unit_data(93).units       = "J T^-1";

  unit_data(94).name        = "deuteron mag. mom. to Bohr magneton ratio";
  unit_data(94).value       = 0.4669754554e-3;
  unit_data(94).uncertainty = 0.0000000026e-3;
  unit_data(94).units       = "";

  unit_data(95).name        = "deuteron mag. mom. to nuclear magneton ratio";
  unit_data(95).value       = 0.8574382311;
  unit_data(95).uncertainty = 0.0000000048;
  unit_data(95).units       = "";

  unit_data(96).name        = "deuteron mass";
  unit_data(96).value       = 3.343583719e-27;
  unit_data(96).uncertainty = 0.000000041e-27;
  unit_data(96).units       = "kg";

  unit_data(97).name        = "deuteron mass energy equivalent";
  unit_data(97).value       = 3.005063183e-10;
  unit_data(97).uncertainty = 0.000000037e-10;
  unit_data(97).units       = "J";

  unit_data(98).name        = "deuteron mass energy equivalent in MeV";
  unit_data(98).value       = 1875.612928;
  unit_data(98).uncertainty = 0.000012;
  unit_data(98).units       = "MeV";

  unit_data(99).name        = "deuteron mass in u";
  unit_data(99).value       = 2.013553212745;
  unit_data(99).uncertainty = 0.000000000040;
  unit_data(99).units       = "u";

  unit_data(100).name        = "deuteron molar mass";
  unit_data(100).value       = 2.013553212745e-3;
  unit_data(100).uncertainty = 0.000000000040e-3;
  unit_data(100).units       = "kg mol^-1";

  unit_data(101).name        = "deuteron rms charge radius";
  unit_data(101).value       = 2.1413e-15;
  unit_data(101).uncertainty = 0.0025e-15;
  unit_data(101).units       = "m";

  unit_data(102).name        = "deuteron-electron mag. mom. ratio";
  unit_data(102).value       = -4.664345535e-4;
  unit_data(102).uncertainty = 0.000000026e-4;
  unit_data(102).units       = "";

  unit_data(103).name        = "deuteron-electron mass ratio";
  unit_data(103).value       = 3670.48296785;
  unit_data(103).uncertainty = 0.00000013;
  unit_data(103).units       = "";

  unit_data(104).name        = "deuteron-neutron mag. mom. ratio";
  unit_data(104).value       = -0.44820652;
  unit_data(104).uncertainty = 0.00000011;
  unit_data(104).units       = "";

  unit_data(105).name        = "deuteron-proton mag. mom. ratio";
  unit_data(105).value       = 0.3070122077;
  unit_data(105).uncertainty = 0.0000000015;
  unit_data(105).units       = "";

  unit_data(106).name        = "deuteron-proton mass ratio";
  unit_data(106).value       = 1.99900750087;
  unit_data(106).uncertainty = 0.00000000019;
  unit_data(106).units       = "";

  unit_data(107).name        = "electric constant";
  unit_data(107).value       = 8.854187817e-12;
  unit_data(107).uncertainty = 0.0;
  unit_data(107).units       = "F m^-1";

  unit_data(108).name        = "electron charge to mass quotient";
  unit_data(108).value       = -1.758820024e11;
  unit_data(108).uncertainty = 0.000000011e11;
  unit_data(108).units       = "C kg^-1";

  unit_data(109).name        = "electron g factor";
  unit_data(109).value       = -2.00231930436182;
  unit_data(109).uncertainty = 0.00000000000052;
  unit_data(109).units       = "";

  unit_data(110).name        = "electron gyromag. ratio";
  unit_data(110).value       = 1.760859644e11;
  unit_data(110).uncertainty = 0.000000011e11;
  unit_data(110).units       = "s^-1 T^-1";

  unit_data(111).name        = "electron gyromag. ratio over 2 pi";
  unit_data(111).value       = 28024.95164;
  unit_data(111).uncertainty = 0.00017;
  unit_data(111).units       = "MHz T^-1";

  unit_data(112).name        = "electron mag. mom.";
  unit_data(112).value       = -928.4764620e-26;
  unit_data(112).uncertainty = 0.0000057e-26;
  unit_data(112).units       = "J T^-1";

  unit_data(113).name        = "electron mag. mom. anomaly";
  unit_data(113).value       = 1.15965218091e-3;
  unit_data(113).uncertainty = 0.00000000026e-3;
  unit_data(113).units       = "";

  unit_data(114).name        = "electron mag. mom. to Bohr magneton ratio";
  unit_data(114).value       = -1.00115965218091;
  unit_data(114).uncertainty = 0.00000000000026;
  unit_data(114).units       = "";

  unit_data(115).name        = "electron mag. mom. to nuclear magneton ratio";
  unit_data(115).value       = -1838.28197234;
  unit_data(115).uncertainty = 0.00000017;
  unit_data(115).units       = "";

  unit_data(116).name        = "electron mass";
  unit_data(116).value       = 9.10938356e-31;
  unit_data(116).uncertainty = 0.00000011e-31;
  unit_data(116).units       = "kg";

  unit_data(117).name        = "electron mass energy equivalent";
  unit_data(117).value       = 8.18710565e-14;
  unit_data(117).uncertainty = 0.00000010e-14;
  unit_data(117).units       = "J";

  unit_data(118).name        = "electron mass energy equivalent in MeV";
  unit_data(118).value       = 0.5109989461;
  unit_data(118).uncertainty = 0.0000000031;
  unit_data(118).units       = "MeV";

  unit_data(119).name        = "electron mass in u";
  unit_data(119).value       = 5.48579909070e-4;
  unit_data(119).uncertainty = 0.00000000016e-4;
  unit_data(119).units       = "u";

  unit_data(120).name        = "electron molar mass";
  unit_data(120).value       = 5.48579909070e-7;
  unit_data(120).uncertainty = 0.00000000016e-7;
  unit_data(120).units       = "kg mol^-1";

  unit_data(121).name        = "electron to alpha particle mass ratio";
  unit_data(121).value       = 1.370933554798e-4;
  unit_data(121).uncertainty = 0.000000000045e-4;
  unit_data(121).units       = "";

  unit_data(122).name        = "electron to shielded helion mag. mom. ratio";
  unit_data(122).value       = 864.058257;
  unit_data(122).uncertainty = 0.000010;
  unit_data(122).units       = "";

  unit_data(123).name        = "electron to shielded proton mag. mom. ratio";
  unit_data(123).value       = -658.2275971;
  unit_data(123).uncertainty = 0.0000072;
  unit_data(123).units       = "";

  unit_data(124).name        = "electron volt";
  unit_data(124).value       = 1.6021766208e-19;
  unit_data(124).uncertainty = 0.0000000098e-19;
  unit_data(124).units       = "J";

  unit_data(125).name        = "electron volt-atomic mass unit relationship";
  unit_data(125).value       = 1.0735441105e-9;
  unit_data(125).uncertainty = 0.0000000066e-9;
  unit_data(125).units       = "u";

  unit_data(126).name        = "electron volt-hartree relationship";
  unit_data(126).value       = 3.674932248e-2;
  unit_data(126).uncertainty = 0.000000023e-2;
  unit_data(126).units       = "E_h";

  unit_data(127).name        = "electron volt-hertz relationship";
  unit_data(127).value       = 2.417989262e14;
  unit_data(127).uncertainty = 0.000000015e14;
  unit_data(127).units       = "Hz";

  unit_data(128).name        = "electron volt-inverse meter relationship";
  unit_data(128).value       = 8.065544005e5;
  unit_data(128).uncertainty = 0.000000050e5;
  unit_data(128).units       = "m^-1";

  unit_data(129).name        = "electron volt-joule relationship";
  unit_data(129).value       = 1.6021766208e-19;
  unit_data(129).uncertainty = 0.0000000098e-19;
  unit_data(129).units       = "J";

  unit_data(130).name        = "electron volt-kelvin relationship";
  unit_data(130).value       = 1.16045221e4;
  unit_data(130).uncertainty = 0.00000067e4;
  unit_data(130).units       = "K";

  unit_data(131).name        = "electron volt-kilogram relationship";
  unit_data(131).value       = 1.782661907e-36;
  unit_data(131).uncertainty = 0.000000011e-36;
  unit_data(131).units       = "kg";

  unit_data(132).name        = "electron-deuteron mag. mom. ratio";
  unit_data(132).value       = -2143.923499;
  unit_data(132).uncertainty = 0.000012;
  unit_data(132).units       = "";

  unit_data(133).name        = "electron-deuteron mass ratio";
  unit_data(133).value       = 2.724437107484e-4;
  unit_data(133).uncertainty = 0.000000000096e-4;
  unit_data(133).units       = "";

  unit_data(134).name        = "electron-helion mass ratio";
  unit_data(134).value       = 1.819543074854e-4;
  unit_data(134).uncertainty = 0.000000000088e-4;
  unit_data(134).units       = "";

  unit_data(135).name        = "electron-muon mag. mom. ratio";
  unit_data(135).value       = 206.7669880;
  unit_data(135).uncertainty = 0.0000046;
  unit_data(135).units       = "";

  unit_data(136).name        = "electron-muon mass ratio";
  unit_data(136).value       = 4.83633170e-3;
  unit_data(136).uncertainty = 0.00000011e-3;
  unit_data(136).units       = "";

  unit_data(137).name        = "electron-neutron mag. mom. ratio";
  unit_data(137).value       = 960.92050;
  unit_data(137).uncertainty = 0.00023;
  unit_data(137).units       = "";

  unit_data(138).name        = "electron-neutron mass ratio";
  unit_data(138).value       = 5.4386734428e-4;
  unit_data(138).uncertainty = 0.0000000027e-4;
  unit_data(138).units       = "";

  unit_data(139).name        = "electron-proton mag. mom. ratio";
  unit_data(139).value       = -658.2106866;
  unit_data(139).uncertainty = 0.0000020;
  unit_data(139).units       = "";

  unit_data(140).name        = "electron-proton mass ratio";
  unit_data(140).value       = 5.44617021352e-4;
  unit_data(140).uncertainty = 0.00000000052e-4;
  unit_data(140).units       = "";

  unit_data(141).name        = "electron-tau mass ratio";
  unit_data(141).value       = 2.87592e-4;
  unit_data(141).uncertainty = 0.00026e-4;
  unit_data(141).units       = "";

  unit_data(142).name        = "electron-triton mass ratio";
  unit_data(142).value       = 1.819200062203e-4;
  unit_data(142).uncertainty = 0.000000000084e-4;
  unit_data(142).units       = "";

  unit_data(143).name        = "elementary charge";
  unit_data(143).value       = 1.6021766208e-19;
  unit_data(143).uncertainty = 0.0000000098e-19;
  unit_data(143).units       = "C";

  unit_data(144).name        = "elementary charge over h";
  unit_data(144).value       = 2.417989262e14;
  unit_data(144).uncertainty = 0.000000015e14;
  unit_data(144).units       = "A J^-1";

  unit_data(145).name        = "fine-structure constant";
  unit_data(145).value       = 7.2973525664e-3;
  unit_data(145).uncertainty = 0.0000000017e-3;
  unit_data(145).units       = "";

  unit_data(146).name        = "first radiation constant";
  unit_data(146).value       = 3.741771790e-16;
  unit_data(146).uncertainty = 0.000000046e-16;
  unit_data(146).units       = "W m^2";

  unit_data(147).name        = "first radiation constant for spectral radiance";
  unit_data(147).value       = 1.191042953e-16;
  unit_data(147).uncertainty = 0.000000015e-16;
  unit_data(147).units       = "W m^2 sr^-1";

  unit_data(148).name        = "hartree-atomic mass unit relationship";
  unit_data(148).value       = 2.9212623197e-8;
  unit_data(148).uncertainty = 0.0000000013e-8;
  unit_data(148).units       = "u";

  unit_data(149).name        = "hartree-electron volt relationship";
  unit_data(149).value       = 27.21138602;
  unit_data(149).uncertainty = 0.00000017;
  unit_data(149).units       = "eV";

  unit_data(150).name        = "hartree-hertz relationship";
  unit_data(150).value       = 6.579683920711e15;
  unit_data(150).uncertainty = 0.000000000039e15;
  unit_data(150).units       = "Hz";

  unit_data(151).name        = "hartree-inverse meter relationship";
  unit_data(151).value       = 2.194746313702e7;
  unit_data(151).uncertainty = 0.000000000013e7;
  unit_data(151).units       = "m^-1";

  unit_data(152).name        = "hartree-joule relationship";
  unit_data(152).value       = 4.359744650e-18;
  unit_data(152).uncertainty = 0.000000054e-18;
  unit_data(152).units       = "J";

  unit_data(153).name        = "hartree-kelvin relationship";
  unit_data(153).value       = 3.1577513e5;
  unit_data(153).uncertainty = 0.0000018e5;
  unit_data(153).units       = "K";

  unit_data(154).name        = "hartree-kilogram relationship";
  unit_data(154).value       = 4.850870129e-35;
  unit_data(154).uncertainty = 0.000000060e-35;
  unit_data(154).units       = "kg";

  unit_data(155).name        = "helion g factor";
  unit_data(155).value       = -4.255250616;
  unit_data(155).uncertainty = 0.000000050;
  unit_data(155).units       = "";

  unit_data(156).name        = "helion mag. mom.";
  unit_data(156).value       = -1.074617522e-26;
  unit_data(156).uncertainty = 0.000000014e-26;
  unit_data(156).units       = "J T^-1";

  unit_data(157).name        = "helion mag. mom. to Bohr magneton ratio";
  unit_data(157).value       = -1.158740958e-3;
  unit_data(157).uncertainty = 0.000000014e-3;
  unit_data(157).units       = "";

  unit_data(158).name        = "helion mag. mom. to nuclear magneton ratio";
  unit_data(158).value       = -2.127625308;
  unit_data(158).uncertainty = 0.000000025;
  unit_data(158).units       = "";

  unit_data(159).name        = "helion mass";
  unit_data(159).value       = 5.006412700e-27;
  unit_data(159).uncertainty = 0.000000062e-27;
  unit_data(159).units       = "kg";

  unit_data(160).name        = "helion mass energy equivalent";
  unit_data(160).value       = 4.499539341e-10;
  unit_data(160).uncertainty = 0.000000055e-10;
  unit_data(160).units       = "J";

  unit_data(161).name        = "helion mass energy equivalent in MeV";
  unit_data(161).value       = 2808.391586;
  unit_data(161).uncertainty = 0.000017;
  unit_data(161).units       = "MeV";

  unit_data(162).name        = "helion mass in u";
  unit_data(162).value       = 3.01493224673;
  unit_data(162).uncertainty = 0.00000000012;
  unit_data(162).units       = "u";

  unit_data(163).name        = "helion molar mass";
  unit_data(163).value       = 3.01493224673e-3;
  unit_data(163).uncertainty = 0.00000000012e-3;
  unit_data(163).units       = "kg mol^-1";

  unit_data(164).name        = "helion-electron mass ratio";
  unit_data(164).value       = 5495.88527922;
  unit_data(164).uncertainty = 0.00000027;
  unit_data(164).units       = "";

  unit_data(165).name        = "helion-proton mass ratio";
  unit_data(165).value       = 2.99315267046;
  unit_data(165).uncertainty = 0.00000000029;
  unit_data(165).units       = "";

  unit_data(166).name        = "hertz-atomic mass unit relationship";
  unit_data(166).value       = 4.4398216616e-24;
  unit_data(166).uncertainty = 0.0000000020e-24;
  unit_data(166).units       = "u";

  unit_data(167).name        = "hertz-electron volt relationship";
  unit_data(167).value       = 4.135667662e-15;
  unit_data(167).uncertainty = 0.000000025e-15;
  unit_data(167).units       = "eV";

  unit_data(168).name        = "hertz-hartree relationship";
  unit_data(168).value       = 1.5198298460088e-16;
  unit_data(168).uncertainty = 0.0000000000090e-16;
  unit_data(168).units       = "E_h";

  unit_data(169).name        = "hertz-inverse meter relationship";
  unit_data(169).value       = 3.335640951e-9;
  unit_data(169).uncertainty = 0.0;
  unit_data(169).units       = "m^-1";

  unit_data(170).name        = "hertz-joule relationship";
  unit_data(170).value       = 6.626070040e-34;
  unit_data(170).uncertainty = 0.000000081e-34;
  unit_data(170).units       = "J";

  unit_data(171).name        = "hertz-kelvin relationship";
  unit_data(171).value       = 4.7992447e-11;
  unit_data(171).uncertainty = 0.0000028e-11;
  unit_data(171).units       = "K";

  unit_data(172).name        = "hertz-kilogram relationship";
  unit_data(172).value       = 7.372497201e-51;
  unit_data(172).uncertainty = 0.000000091e-51;
  unit_data(172).units       = "kg";

  unit_data(173).name        = "inverse fine-structure constant";
  unit_data(173).value       = 137.035999139;
  unit_data(173).uncertainty = 0.000000031;
  unit_data(173).units       = "";

  unit_data(174).name        = "inverse meter-atomic mass unit relationship";
  unit_data(174).value       = 1.33102504900e-15;
  unit_data(174).uncertainty = 0.00000000061e-15;
  unit_data(174).units       = "u";

  unit_data(175).name        = "inverse meter-electron volt relationship";
  unit_data(175).value       = 1.2398419739e-6;
  unit_data(175).uncertainty = 0.0000000076e-6;
  unit_data(175).units       = "eV";

  unit_data(176).name        = "inverse meter-hartree relationship";
  unit_data(176).value       = 4.556335252767e-8;
  unit_data(176).uncertainty = 0.000000000027e-8;
  unit_data(176).units       = "E_h";

  unit_data(177).name        = "inverse meter-hertz relationship";
  unit_data(177).value       = 299792458;
  unit_data(177).uncertainty = 0.0;
  unit_data(177).units       = "Hz";

  unit_data(178).name        = "inverse meter-joule relationship";
  unit_data(178).value       = 1.986445824e-25;
  unit_data(178).uncertainty = 0.000000024e-25;
  unit_data(178).units       = "J";

  unit_data(179).name        = "inverse meter-kelvin relationship";
  unit_data(179).value       = 1.43877736e-2;
  unit_data(179).uncertainty = 0.00000083e-2;
  unit_data(179).units       = "K";

  unit_data(180).name        = "inverse meter-kilogram relationship";
  unit_data(180).value       = 2.210219057e-42;
  unit_data(180).uncertainty = 0.000000027e-42;
  unit_data(180).units       = "kg";

  unit_data(181).name        = "inverse of conductance quantum";
  unit_data(181).value       = 12906.4037278;
  unit_data(181).uncertainty = 0.0000029;
  unit_data(181).units       = "ohm";

  unit_data(182).name        = "joule-atomic mass unit relationship";
  unit_data(182).value       = 6.700535363e9;
  unit_data(182).uncertainty = 0.000000082e9;
  unit_data(182).units       = "u";

  unit_data(183).name        = "joule-electron volt relationship";
  unit_data(183).value       = 6.241509126e18;
  unit_data(183).uncertainty = 0.000000038e18;
  unit_data(183).units       = "eV";

  unit_data(184).name        = "joule-hartree relationship";
  unit_data(184).value       = 2.293712317e17;
  unit_data(184).uncertainty = 0.000000028e17;
  unit_data(184).units       = "E_h";

  unit_data(185).name        = "joule-hertz relationship";
  unit_data(185).value       = 1.509190205e33;
  unit_data(185).uncertainty = 0.000000019e33;
  unit_data(185).units       = "Hz";

  unit_data(186).name        = "joule-inverse meter relationship";
  unit_data(186).value       = 5.034116651e24;
  unit_data(186).uncertainty = 0.000000062e24;
  unit_data(186).units       = "m^-1";

  unit_data(187).name        = "joule-kelvin relationship";
  unit_data(187).value       = 7.2429731e22;
  unit_data(187).uncertainty = 0.0000042e22;
  unit_data(187).units       = "K";

  unit_data(188).name        = "joule-kilogram relationship";
  unit_data(188).value       = 1.112650056e-17;
  unit_data(188).uncertainty = 0.0;
  unit_data(188).units       = "kg";

  unit_data(189).name        = "kelvin-atomic mass unit relationship";
  unit_data(189).value       = 9.2510842e-14;
  unit_data(189).uncertainty = 0.0000053e-14;
  unit_data(189).units       = "u";

  unit_data(190).name        = "kelvin-electron volt relationship";
  unit_data(190).value       = 8.6173303e-5;
  unit_data(190).uncertainty = 0.0000050e-5;
  unit_data(190).units       = "eV";

  unit_data(191).name        = "kelvin-hartree relationship";
  unit_data(191).value       = 3.1668105e-6;
  unit_data(191).uncertainty = 0.0000018e-6;
  unit_data(191).units       = "E_h";

  unit_data(192).name        = "kelvin-hertz relationship";
  unit_data(192).value       = 2.0836612e10;
  unit_data(192).uncertainty = 0.0000012e10;
  unit_data(192).units       = "Hz";

  unit_data(193).name        = "kelvin-inverse meter relationship";
  unit_data(193).value       = 69.503457;
  unit_data(193).uncertainty = 0.000040;
  unit_data(193).units       = "m^-1";

  unit_data(194).name        = "kelvin-joule relationship";
  unit_data(194).value       = 1.38064852e-23;
  unit_data(194).uncertainty = 0.00000079e-23;
  unit_data(194).units       = "J";

  unit_data(195).name        = "kelvin-kilogram relationship";
  unit_data(195).value       = 1.53617865e-40;
  unit_data(195).uncertainty = 0.00000088e-40;
  unit_data(195).units       = "kg";

  unit_data(196).name        = "kilogram-atomic mass unit relationship";
  unit_data(196).value       = 6.022140857e26;
  unit_data(196).uncertainty = 0.000000074e26;
  unit_data(196).units       = "u";

  unit_data(197).name        = "kilogram-electron volt relationship";
  unit_data(197).value       = 5.609588650e35;
  unit_data(197).uncertainty = 0.000000034e35;
  unit_data(197).units       = "eV";

  unit_data(198).name        = "kilogram-hartree relationship";
  unit_data(198).value       = 2.061485823e34;
  unit_data(198).uncertainty = 0.000000025e34;
  unit_data(198).units       = "E_h";

  unit_data(199).name        = "kilogram-hertz relationship";
  unit_data(199).value       = 1.356392512e50;
  unit_data(199).uncertainty = 0.000000017e50;
  unit_data(199).units       = "Hz";

  unit_data(200).name        = "kilogram-inverse meter relationship";
  unit_data(200).value       = 4.524438411e41;
  unit_data(200).uncertainty = 0.000000056e41;
  unit_data(200).units       = "m^-1";

  unit_data(201).name        = "kilogram-joule relationship";
  unit_data(201).value       = 8.987551787e16;
  unit_data(201).uncertainty = 0.0;
  unit_data(201).units       = "J";

  unit_data(202).name        = "kilogram-kelvin relationship";
  unit_data(202).value       = 6.5096595e39;
  unit_data(202).uncertainty = 0.0000037e39;
  unit_data(202).units       = "K";

  unit_data(203).name        = "lattice parameter of silicon";
  unit_data(203).value       = 543.1020504e-12;
  unit_data(203).uncertainty = 0.0000089e-12;
  unit_data(203).units       = "m";

  unit_data(204).name        = "mag. constant";
  unit_data(204).value       = 12.566370614e-7;
  unit_data(204).uncertainty = 0.0;
  unit_data(204).units       = "N A^-2";

  unit_data(205).name        = "mag. flux quantum";
  unit_data(205).value       = 2.067833831e-15;
  unit_data(205).uncertainty = 0.000000013e-15;
  unit_data(205).units       = "Wb";

  unit_data(206).name        = "molar Planck constant";
  unit_data(206).value       = 3.9903127110e-10;
  unit_data(206).uncertainty = 0.0000000018e-10;
  unit_data(206).units       = "J s mol^-1";

  unit_data(207).name        = "molar Planck constant times c";
  unit_data(207).value       = 0.119626565582;
  unit_data(207).uncertainty = 0.000000000054;
  unit_data(207).units       = "J m mol^-1";

  unit_data(208).name        = "molar gas constant";
  unit_data(208).value       = 8.3144598;
  unit_data(208).uncertainty = 0.0000048;
  unit_data(208).units       = "J mol^-1 K^-1";

  unit_data(209).name        = "molar mass constant";
  unit_data(209).value       = 1e-3;
  unit_data(209).uncertainty = 0.0;
  unit_data(209).units       = "kg mol^-1";

  unit_data(210).name        = "molar mass of carbon-12";
  unit_data(210).value       = 12e-3;
  unit_data(210).uncertainty = 0.0;
  unit_data(210).units       = "kg mol^-1";

  unit_data(211).name        = "molar volume of ideal gas (273.15 K, 100 kPa)";
  unit_data(211).value       = 22.710947e-3;
  unit_data(211).uncertainty = 0.000013e-3;
  unit_data(211).units       = "m^3 mol^-1";

  unit_data(212).name        = "molar volume of ideal gas (273.15 K, 101.325 kPa)";
  unit_data(212).value       = 22.413962e-3;
  unit_data(212).uncertainty = 0.000013e-3;
  unit_data(212).units       = "m^3 mol^-1";

  unit_data(213).name        = "molar volume of silicon";
  unit_data(213).value       = 12.05883214e-6;
  unit_data(213).uncertainty = 0.00000061e-6;
  unit_data(213).units       = "m^3 mol^-1";

  unit_data(214).name        = "muon Compton wavelength";
  unit_data(214).value       = 11.73444111e-15;
  unit_data(214).uncertainty = 0.00000026e-15;
  unit_data(214).units       = "m";

  unit_data(215).name        = "muon Compton wavelength over 2 pi";
  unit_data(215).value       = 1.867594308e-15;
  unit_data(215).uncertainty = 0.000000042e-15;
  unit_data(215).units       = "m";

  unit_data(216).name        = "muon g factor";
  unit_data(216).value       = -2.0023318418;
  unit_data(216).uncertainty = 0.0000000013;
  unit_data(216).units       = "";

  unit_data(217).name        = "muon mag. mom.";
  unit_data(217).value       = -4.49044826e-26;
  unit_data(217).uncertainty = 0.00000010e-26;
  unit_data(217).units       = "J T^-1";

  unit_data(218).name        = "muon mag. mom. anomaly";
  unit_data(218).value       = 1.16592089e-3;
  unit_data(218).uncertainty = 0.00000063e-3;
  unit_data(218).units       = "";

  unit_data(219).name        = "muon mag. mom. to Bohr magneton ratio";
  unit_data(219).value       = -4.84197048e-3;
  unit_data(219).uncertainty = 0.00000011e-3;
  unit_data(219).units       = "";

  unit_data(220).name        = "muon mag. mom. to nuclear magneton ratio";
  unit_data(220).value       = -8.89059705;
  unit_data(220).uncertainty = 0.00000020;
  unit_data(220).units       = "";

  unit_data(221).name        = "muon mass";
  unit_data(221).value       = 1.883531594e-28;
  unit_data(221).uncertainty = 0.000000048e-28;
  unit_data(221).units       = "kg";

  unit_data(222).name        = "muon mass energy equivalent";
  unit_data(222).value       = 1.692833774e-11;
  unit_data(222).uncertainty = 0.000000043e-11;
  unit_data(222).units       = "J";

  unit_data(223).name        = "muon mass energy equivalent in MeV";
  unit_data(223).value       = 105.6583745;
  unit_data(223).uncertainty = 0.0000024;
  unit_data(223).units       = "MeV";

  unit_data(224).name        = "muon mass in u";
  unit_data(224).value       = 0.1134289257;
  unit_data(224).uncertainty = 0.0000000025;
  unit_data(224).units       = "u";

  unit_data(225).name        = "muon molar mass";
  unit_data(225).value       = 0.1134289257e-3;
  unit_data(225).uncertainty = 0.0000000025e-3;
  unit_data(225).units       = "kg mol^-1";

  unit_data(226).name        = "muon-electron mass ratio";
  unit_data(226).value       = 206.7682826;
  unit_data(226).uncertainty = 0.0000046;
  unit_data(226).units       = "";

  unit_data(227).name        = "muon-neutron mass ratio";
  unit_data(227).value       = 0.1124545167;
  unit_data(227).uncertainty = 0.0000000025;
  unit_data(227).units       = "";

  unit_data(228).name        = "muon-proton mag. mom. ratio";
  unit_data(228).value       = -3.183345142;
  unit_data(228).uncertainty = 0.000000071;
  unit_data(228).units       = "";

  unit_data(229).name        = "muon-proton mass ratio";
  unit_data(229).value       = 0.1126095262;
  unit_data(229).uncertainty = 0.0000000025;
  unit_data(229).units       = "";

  unit_data(230).name        = "muon-tau mass ratio";
  unit_data(230).value       = 5.94649e-2;
  unit_data(230).uncertainty = 0.00054e-2;
  unit_data(230).units       = "";

  unit_data(231).name        = "natural unit of action";
  unit_data(231).value       = 1.054571800e-34;
  unit_data(231).uncertainty = 0.000000013e-34;
  unit_data(231).units       = "J s";

  unit_data(232).name        = "natural unit of action in eV s";
  unit_data(232).value       = 6.582119514e-16;
  unit_data(232).uncertainty = 0.000000040e-16;
  unit_data(232).units       = "eV s";

  unit_data(233).name        = "natural unit of energy";
  unit_data(233).value       = 8.18710565e-14;
  unit_data(233).uncertainty = 0.00000010e-14;
  unit_data(233).units       = "J";

  unit_data(234).name        = "natural unit of energy in MeV";
  unit_data(234).value       = 0.5109989461;
  unit_data(234).uncertainty = 0.0000000031;
  unit_data(234).units       = "MeV";

  unit_data(235).name        = "natural unit of length";
  unit_data(235).value       = 386.15926764e-15;
  unit_data(235).uncertainty = 0.00000018e-15;
  unit_data(235).units       = "m";

  unit_data(236).name        = "natural unit of mass";
  unit_data(236).value       = 9.10938356e-31;
  unit_data(236).uncertainty = 0.00000011e-31;
  unit_data(236).units       = "kg";

  unit_data(237).name        = "natural unit of mom.um";
  unit_data(237).value       = 2.730924488e-22;
  unit_data(237).uncertainty = 0.000000034e-22;
  unit_data(237).units       = "kg m s^-1";

  unit_data(238).name        = "natural unit of mom.um in MeV/c";
  unit_data(238).value       = 0.5109989461;
  unit_data(238).uncertainty = 0.0000000031;
  unit_data(238).units       = "MeV/c";

  unit_data(239).name        = "natural unit of time";
  unit_data(239).value       = 1.28808866712e-21;
  unit_data(239).uncertainty = 0.00000000058e-21;
  unit_data(239).units       = "s";

  unit_data(240).name        = "natural unit of velocity";
  unit_data(240).value       = 299792458;
  unit_data(240).uncertainty = 0.0;
  unit_data(240).units       = "m s^-1";

  unit_data(241).name        = "neutron Compton wavelength";
  unit_data(241).value       = 1.31959090481e-15;
  unit_data(241).uncertainty = 0.00000000088e-15;
  unit_data(241).units       = "m";

  unit_data(242).name        = "neutron Compton wavelength over 2 pi";
  unit_data(242).value       = 0.21001941536e-15;
  unit_data(242).uncertainty = 0.00000000014e-15;
  unit_data(242).units       = "m";

  unit_data(243).name        = "neutron g factor";
  unit_data(243).value       = -3.82608545;
  unit_data(243).uncertainty = 0.00000090;
  unit_data(243).units       = "";

  unit_data(244).name        = "neutron gyromag. ratio";
  unit_data(244).value       = 1.83247172e8;
  unit_data(244).uncertainty = 0.00000043e8;
  unit_data(244).units       = "s^-1 T^-1";

  unit_data(245).name        = "neutron gyromag. ratio over 2 pi";
  unit_data(245).value       = 29.1646933;
  unit_data(245).uncertainty = 0.0000069;
  unit_data(245).units       = "MHz T^-1";

  unit_data(246).name        = "neutron mag. mom.";
  unit_data(246).value       = -0.96623650e-26;
  unit_data(246).uncertainty = 0.00000023e-26;
  unit_data(246).units       = "J T^-1";

  unit_data(247).name        = "neutron mag. mom. to Bohr magneton ratio";
  unit_data(247).value       = -1.04187563e-3;
  unit_data(247).uncertainty = 0.00000025e-3;
  unit_data(247).units       = "";

  unit_data(248).name        = "neutron mag. mom. to nuclear magneton ratio";
  unit_data(248).value       = -1.91304273;
  unit_data(248).uncertainty = 0.00000045;
  unit_data(248).units       = "";

  unit_data(249).name        = "neutron mass";
  unit_data(249).value       = 1.674927471e-27;
  unit_data(249).uncertainty = 0.000000021e-27;
  unit_data(249).units       = "kg";

  unit_data(250).name        = "neutron mass energy equivalent";
  unit_data(250).value       = 1.505349739e-10;
  unit_data(250).uncertainty = 0.000000019e-10;
  unit_data(250).units       = "J";

  unit_data(251).name        = "neutron mass energy equivalent in MeV";
  unit_data(251).value       = 939.5654133;
  unit_data(251).uncertainty = 0.0000058;
  unit_data(251).units       = "MeV";

  unit_data(252).name        = "neutron mass in u";
  unit_data(252).value       = 1.00866491588;
  unit_data(252).uncertainty = 0.00000000049;
  unit_data(252).units       = "u";

  unit_data(253).name        = "neutron molar mass";
  unit_data(253).value       = 1.00866491588e-3;
  unit_data(253).uncertainty = 0.00000000049e-3;
  unit_data(253).units       = "kg mol^-1";

  unit_data(254).name        = "neutron to shielded proton mag. mom. ratio";
  unit_data(254).value       = -0.68499694;
  unit_data(254).uncertainty = 0.00000016;
  unit_data(254).units       = "";

  unit_data(255).name        = "neutron-electron mag. mom. ratio";
  unit_data(255).value       = 1.04066882e-3;
  unit_data(255).uncertainty = 0.00000025e-3;
  unit_data(255).units       = "";

  unit_data(256).name        = "neutron-electron mass ratio";
  unit_data(256).value       = 1838.68366158;
  unit_data(256).uncertainty = 0.00000090;
  unit_data(256).units       = "";

  unit_data(257).name        = "neutron-muon mass ratio";
  unit_data(257).value       = 8.89248408;
  unit_data(257).uncertainty = 0.00000020;
  unit_data(257).units       = "";

  unit_data(258).name        = "neutron-proton mag. mom. ratio";
  unit_data(258).value       = -0.68497934;
  unit_data(258).uncertainty = 0.00000016;
  unit_data(258).units       = "";

  unit_data(259).name        = "neutron-proton mass difference";
  unit_data(259).value       = 2.30557377e-30;
  unit_data(259).uncertainty = 0.00000085e-30;
  unit_data(259).units       = "";

  unit_data(260).name        = "neutron-proton mass difference energy equivalent";
  unit_data(260).value       = 2.07214637e-13;
  unit_data(260).uncertainty = 0.00000076e-13;
  unit_data(260).units       = "";

  unit_data(261).name        = "neutron-proton mass difference energy equivalent in MeV";
  unit_data(261).value       = 1.29333205;
  unit_data(261).uncertainty = 0.00000048;
  unit_data(261).units       = "";

  unit_data(262).name        = "neutron-proton mass difference in u";
  unit_data(262).value       = 0.00138844900;
  unit_data(262).uncertainty = 0.00000000051;
  unit_data(262).units       = "";

  unit_data(263).name        = "neutron-proton mass ratio";
  unit_data(263).value       = 1.00137841898;
  unit_data(263).uncertainty = 0.00000000051;
  unit_data(263).units       = "";

  unit_data(264).name        = "neutron-tau mass ratio";
  unit_data(264).value       = 0.528790;
  unit_data(264).uncertainty = 0.000048;
  unit_data(264).units       = "";

  unit_data(265).name        = "nuclear magneton";
  unit_data(265).value       = 5.050783699e-27;
  unit_data(265).uncertainty = 0.000000031e-27;
  unit_data(265).units       = "J T^-1";

  unit_data(266).name        = "nuclear magneton in K/T";
  unit_data(266).value       = 3.6582690e-4;
  unit_data(266).uncertainty = 0.0000021e-4;
  unit_data(266).units       = "K T^-1";

  unit_data(267).name        = "nuclear magneton in MHz/T";
  unit_data(267).value       = 7.622593285;
  unit_data(267).uncertainty = 0.000000047;
  unit_data(267).units       = "MHz T^-1";

  unit_data(268).name        = "nuclear magneton in eV/T";
  unit_data(268).value       = 3.1524512550e-8;
  unit_data(268).uncertainty = 0.0000000015e-8;
  unit_data(268).units       = "eV T^-1";

  unit_data(269).name        = "nuclear magneton in inverse meters per tesla";
  unit_data(269).value       = 2.542623432e-2;
  unit_data(269).uncertainty = 0.000000016e-2;
  unit_data(269).units       = "m^-1 T^-1";

  unit_data(270).name        = "proton Compton wavelength";
  unit_data(270).value       = 1.32140985396e-15;
  unit_data(270).uncertainty = 0.00000000061e-15;
  unit_data(270).units       = "m";

  unit_data(271).name        = "proton Compton wavelength over 2 pi";
  unit_data(271).value       = 0.210308910109e-15;
  unit_data(271).uncertainty = 0.000000000097e-15;
  unit_data(271).units       = "m";

  unit_data(272).name        = "proton charge to mass quotient";
  unit_data(272).value       = 9.578833226e7;
  unit_data(272).uncertainty = 0.000000059e7;
  unit_data(272).units       = "C kg^-1";

  unit_data(273).name        = "proton g factor";
  unit_data(273).value       = 5.585694702;
  unit_data(273).uncertainty = 0.000000017;
  unit_data(273).units       = "";

  unit_data(274).name        = "proton gyromag. ratio";
  unit_data(274).value       = 2.675221900e8;
  unit_data(274).uncertainty = 0.000000018e8;
  unit_data(274).units       = "s^-1 T^-1";

  unit_data(275).name        = "proton gyromag. ratio over 2 pi";
  unit_data(275).value       = 42.57747892;
  unit_data(275).uncertainty = 0.00000029;
  unit_data(275).units       = "MHz T^-1";

  unit_data(276).name        = "proton mag. mom.";
  unit_data(276).value       = 1.4106067873e-26;
  unit_data(276).uncertainty = 0.0000000097e-26;
  unit_data(276).units       = "J T^-1";

  unit_data(277).name        = "proton mag. mom. to Bohr magneton ratio";
  unit_data(277).value       = 1.5210322053e-3;
  unit_data(277).uncertainty = 0.0000000046e-3;
  unit_data(277).units       = "";

  unit_data(278).name        = "proton mag. mom. to nuclear magneton ratio";
  unit_data(278).value       = 2.7928473508;
  unit_data(278).uncertainty = 0.0000000085;
  unit_data(278).units       = "";

  unit_data(279).name        = "proton mag. shielding correction";
  unit_data(279).value       = 25.691e-6;
  unit_data(279).uncertainty = 0.011e-6;
  unit_data(279).units       = "";

  unit_data(280).name        = "proton mass";
  unit_data(280).value       = 1.672621898e-27;
  unit_data(280).uncertainty = 0.000000021e-27;
  unit_data(280).units       = "kg";

  unit_data(281).name        = "proton mass energy equivalent";
  unit_data(281).value       = 1.503277593e-10;
  unit_data(281).uncertainty = 0.000000018e-10;
  unit_data(281).units       = "J";

  unit_data(282).name        = "proton mass energy equivalent in MeV";
  unit_data(282).value       = 938.2720813;
  unit_data(282).uncertainty = 0.0000058;
  unit_data(282).units       = "MeV";

  unit_data(283).name        = "proton mass in u";
  unit_data(283).value       = 1.007276466879;
  unit_data(283).uncertainty = 0.000000000091;
  unit_data(283).units       = "u";

  unit_data(284).name        = "proton molar mass";
  unit_data(284).value       = 1.007276466879e-3;
  unit_data(284).uncertainty = 0.000000000091e-3;
  unit_data(284).units       = "kg mol^-1";

  unit_data(285).name        = "proton rms charge radius";
  unit_data(285).value       = 0.8751e-15;
  unit_data(285).uncertainty = 0.0061e-15;
  unit_data(285).units       = "m";

  unit_data(286).name        = "proton-electron mass ratio";
  unit_data(286).value       = 1836.15267389;
  unit_data(286).uncertainty = 0.00000017;
  unit_data(286).units       = "";

  unit_data(287).name        = "proton-muon mass ratio";
  unit_data(287).value       = 8.88024338;
  unit_data(287).uncertainty = 0.00000020;
  unit_data(287).units       = "";

  unit_data(288).name        = "proton-neutron mag. mom. ratio";
  unit_data(288).value       = -1.45989805;
  unit_data(288).uncertainty = 0.00000034;
  unit_data(288).units       = "";

  unit_data(289).name        = "proton-neutron mass ratio";
  unit_data(289).value       = 0.99862347844;
  unit_data(289).uncertainty = 0.00000000051;
  unit_data(289).units       = "";

  unit_data(290).name        = "proton-tau mass ratio";
  unit_data(290).value       = 0.528063;
  unit_data(290).uncertainty = 0.000048;
  unit_data(290).units       = "";

  unit_data(291).name        = "quantum of circulation";
  unit_data(291).value       = 3.6369475486e-4;
  unit_data(291).uncertainty = 0.0000000017e-4;
  unit_data(291).units       = "m^2 s^-1";

  unit_data(292).name        = "quantum of circulation times 2";
  unit_data(292).value       = 7.2738950972e-4;
  unit_data(292).uncertainty = 0.0000000033e-4;
  unit_data(292).units       = "m^2 s^-1";

  unit_data(293).name        = "second radiation constant";
  unit_data(293).value       = 1.43877736e-2;
  unit_data(293).uncertainty = 0.00000083e-2;
  unit_data(293).units       = "m K";

  unit_data(294).name        = "shielded helion gyromag. ratio";
  unit_data(294).value       = 2.037894585e8;
  unit_data(294).uncertainty = 0.000000027e8;
  unit_data(294).units       = "s^-1 T^-1";

  unit_data(295).name        = "shielded helion gyromag. ratio over 2 pi";
  unit_data(295).value       = 32.43409966;
  unit_data(295).uncertainty = 0.00000043;
  unit_data(295).units       = "MHz T^-1";

  unit_data(296).name        = "shielded helion mag. mom.";
  unit_data(296).value       = -1.074553080e-26;
  unit_data(296).uncertainty = 0.000000014e-26;
  unit_data(296).units       = "J T^-1";

  unit_data(297).name        = "shielded helion mag. mom. to Bohr magneton ratio";
  unit_data(297).value       = -1.158671471e-3;
  unit_data(297).uncertainty = 0.000000014e-3;
  unit_data(297).units       = "";

  unit_data(298).name        = "shielded helion mag. mom. to nuclear magneton ratio";
  unit_data(298).value       = -2.127497720;
  unit_data(298).uncertainty = 0.000000025;
  unit_data(298).units       = "";

  unit_data(299).name        = "shielded helion to proton mag. mom. ratio";
  unit_data(299).value       = -0.7617665603;
  unit_data(299).uncertainty = 0.0000000092;
  unit_data(299).units       = "";

  unit_data(300).name        = "shielded helion to shielded proton mag. mom. ratio";
  unit_data(300).value       = -0.7617861313;
  unit_data(300).uncertainty = 0.0000000033;
  unit_data(300).units       = "";

  unit_data(301).name        = "shielded proton gyromag. ratio";
  unit_data(301).value       = 2.675153171e8;
  unit_data(301).uncertainty = 0.000000033e8;
  unit_data(301).units       = "s^-1 T^-1";

  unit_data(302).name        = "shielded proton gyromag. ratio over 2 pi";
  unit_data(302).value       = 42.57638507;
  unit_data(302).uncertainty = 0.00000053;
  unit_data(302).units       = "MHz T^-1";

  unit_data(303).name        = "shielded proton mag. mom.";
  unit_data(303).value       = 1.410570547e-26;
  unit_data(303).uncertainty = 0.000000018e-26;
  unit_data(303).units       = "J T^-1";

  unit_data(304).name        = "shielded proton mag. mom. to Bohr magneton ratio";
  unit_data(304).value       = 1.520993128e-3;
  unit_data(304).uncertainty = 0.000000017e-3;
  unit_data(304).units       = "";

  unit_data(305).name        = "shielded proton mag. mom. to nuclear magneton ratio";
  unit_data(305).value       = 2.792775600;
  unit_data(305).uncertainty = 0.000000030;
  unit_data(305).units       = "";

  unit_data(306).name        = "speed of light in vacuum";
  unit_data(306).value       = 299792458;
  unit_data(306).uncertainty = 0.0;
  unit_data(306).units       = "m s^-1";

  unit_data(307).name        = "standard acceleration of gravity";
  unit_data(307).value       = 9.80665;
  unit_data(307).uncertainty = 0.0;
  unit_data(307).units       = "m s^-2";

  unit_data(308).name        = "standard atmosphere";
  unit_data(308).value       = 101325;
  unit_data(308).uncertainty = 0.0;
  unit_data(308).units       = "Pa";

  unit_data(309).name        = "standard-state pressure";
  unit_data(309).value       = 100000;
  unit_data(309).uncertainty = 0.0;
  unit_data(309).units       = "Pa";

  unit_data(310).name        = "tau Compton wavelength";
  unit_data(310).value       = 0.697787e-15;
  unit_data(310).uncertainty = 0.000063e-15;
  unit_data(310).units       = "m";

  unit_data(311).name        = "tau Compton wavelength over 2 pi";
  unit_data(311).value       = 0.111056e-15;
  unit_data(311).uncertainty = 0.000010e-15;
  unit_data(311).units       = "m";

  unit_data(312).name        = "tau mass";
  unit_data(312).value       = 3.16747e-27;
  unit_data(312).uncertainty = 0.00029e-27;
  unit_data(312).units       = "kg";

  unit_data(313).name        = "tau mass energy equivalent";
  unit_data(313).value       = 2.84678e-10;
  unit_data(313).uncertainty = 0.00026e-10;
  unit_data(313).units       = "J";

  unit_data(314).name        = "tau mass energy equivalent in MeV";
  unit_data(314).value       = 1776.82;
  unit_data(314).uncertainty = 0.16;
  unit_data(314).units       = "MeV";

  unit_data(315).name        = "tau mass in u";
  unit_data(315).value       = 1.90749;
  unit_data(315).uncertainty = 0.00017;
  unit_data(315).units       = "u";

  unit_data(316).name        = "tau molar mass";
  unit_data(316).value       = 1.90749e-3;
  unit_data(316).uncertainty = 0.00017e-3;
  unit_data(316).units       = "kg mol^-1";

  unit_data(317).name        = "tau-electron mass ratio";
  unit_data(317).value       = 3477.15;
  unit_data(317).uncertainty = 0.31;
  unit_data(317).units       = "";

  unit_data(318).name        = "tau-muon mass ratio";
  unit_data(318).value       = 16.8167;
  unit_data(318).uncertainty = 0.0015;
  unit_data(318).units       = "";

  unit_data(319).name        = "tau-neutron mass ratio";
  unit_data(319).value       = 1.89111;
  unit_data(319).uncertainty = 0.00017;
  unit_data(319).units       = "";

  unit_data(320).name        = "tau-proton mass ratio";
  unit_data(320).value       = 1.89372;
  unit_data(320).uncertainty = 0.00017;
  unit_data(320).units       = "";

  unit_data(321).name        = "triton g factor";
  unit_data(321).value       = 5.957924920;
  unit_data(321).uncertainty = 0.000000028;
  unit_data(321).units       = "";

  unit_data(322).name        = "triton mag. mom.";
  unit_data(322).value       = 1.504609503e-26;
  unit_data(322).uncertainty = 0.000000012e-26;
  unit_data(322).units       = "J T^-1";

  unit_data(323).name        = "triton mag. mom. to Bohr magneton ratio";
  unit_data(323).value       = 1.6223936616e-3;
  unit_data(323).uncertainty = 0.0000000076e-3;
  unit_data(323).units       = "";

  unit_data(324).name        = "triton mag. mom. to nuclear magneton ratio";
  unit_data(324).value       = 2.978962460;
  unit_data(324).uncertainty = 0.000000014;
  unit_data(324).units       = "";

  unit_data(325).name        = "triton mass";
  unit_data(325).value       = 5.007356665e-27;
  unit_data(325).uncertainty = 0.000000062e-27;
  unit_data(325).units       = "kg";

  unit_data(326).name        = "triton mass energy equivalent";
  unit_data(326).value       = 4.500387735e-10;
  unit_data(326).uncertainty = 0.000000055e-10;
  unit_data(326).units       = "J";

  unit_data(327).name        = "triton mass energy equivalent in MeV";
  unit_data(327).value       = 2808.921112;
  unit_data(327).uncertainty = 0.000017;
  unit_data(327).units       = "MeV";

  unit_data(328).name        = "triton mass in u";
  unit_data(328).value       = 3.01550071632;
  unit_data(328).uncertainty = 0.00000000011;
  unit_data(328).units       = "u";

  unit_data(329).name        = "triton molar mass";
  unit_data(329).value       = 3.01550071632e-3;
  unit_data(329).uncertainty = 0.00000000011e-3;
  unit_data(329).units       = "kg mol^-1";

  unit_data(330).name        = "triton-electron mass ratio";
  unit_data(330).value       = 5496.92153588;
  unit_data(330).uncertainty = 0.00000026;
  unit_data(330).units       = "";

  unit_data(331).name        = "triton-proton mass ratio";
  unit_data(331).value       = 2.99371703348;
  unit_data(331).uncertainty = 0.00000000022;
  unit_data(331).units       = "";

  unit_data(332).name        = "unified atomic mass unit";
  unit_data(332).value       = 1.660539040e-27;
  unit_data(332).uncertainty = 0.000000020e-27;
  unit_data(332).units       = "kg";

  unit_data(333).name        = "von Klitzing constant";
  unit_data(333).value       = 25812.8074555;
  unit_data(333).uncertainty = 0.0000059;
  unit_data(333).units       = "ohm";

  unit_data(334).name        = "weak mixing angle";
  unit_data(334).value       = 0.2223;
  unit_data(334).uncertainty = 0.0021;
  unit_data(334).units       = "";

  unit_data(335).name        = "{220} lattice spacing of silicon";
  unit_data(335).value       = 192.0155714e-12;
  unit_data(335).uncertainty = 0.0000032e-12;
  unit_data(335).units       = "m";

endfunction
%!assert(physical_constant("Angstrom star"), 1.00001495e-10);
%!assert(physical_constant("Avogadro constant"), 6.022140857e23);
%!assert(physical_constant("Bohr magneton"), 927.4009994e-26);
%!assert(physical_constant("Bohr magneton in Hz/T"), 13.996245042e9);
%!assert(physical_constant("Bohr magneton in K/T"), 0.67171405);
%!assert(physical_constant("Bohr magneton in eV/T"), 5.7883818012e-5);
%!assert(physical_constant("Bohr magneton in inverse meters per tesla"), 46.68644814);
%!assert(physical_constant("Bohr radius"), 0.52917721067e-10);
%!assert(physical_constant("Boltzmann constant"), 1.38064852e-23);
%!assert(physical_constant("Boltzmann constant in Hz/K"), 2.0836612e10);
%!assert(physical_constant("Boltzmann constant in eV/K"), 8.6173303e-5);
%!assert(physical_constant("Boltzmann constant in inverse meters per kelvin"), 69.503457);
%!assert(physical_constant("Compton wavelength"), 2.4263102367e-12);
%!assert(physical_constant("Compton wavelength over 2 pi"), 386.15926764e-15);
%!assert(physical_constant("Cu x unit"), 1.00207697e-13);
%!assert(physical_constant("Faraday constant"), 96485.33289);
%!assert(physical_constant("Faraday constant for conventional electric current"), 96485.3251);
%!assert(physical_constant("Fermi coupling constant"), 1.1663787e-5);
%!assert(physical_constant("Hartree energy"), 4.359744650e-18);
%!assert(physical_constant("Hartree energy in eV"), 27.21138602);
%!assert(physical_constant("Josephson constant"), 483597.8525e9);
%!assert(physical_constant("Loschmidt constant (273.15 K, 100 kPa)"), 2.6516467e25);
%!assert(physical_constant("Loschmidt constant (273.15 K, 101.325 kPa)"), 2.6867811e25);
%!assert(physical_constant("Mo x unit"), 1.00209952e-13);
%!assert(physical_constant("Newtonian constant of gravitation"), 6.67408e-11);
%!assert(physical_constant("Newtonian constant of gravitation over h-bar c"), 6.70861e-39);
%!assert(physical_constant("Planck constant"), 6.626070040e-34);
%!assert(physical_constant("Planck constant in eV s"), 4.135667662e-15);
%!assert(physical_constant("Planck constant over 2 pi"), 1.054571800e-34);
%!assert(physical_constant("Planck constant over 2 pi in eV s"), 6.582119514e-16);
%!assert(physical_constant("Planck constant over 2 pi times c in MeV fm"), 197.3269788);
%!assert(physical_constant("Planck length"), 1.616229e-35);
%!assert(physical_constant("Planck mass"), 2.176470e-8);
%!assert(physical_constant("Planck mass energy equivalent in GeV"), 1.220910e19);
%!assert(physical_constant("Planck temperature"), 1.416808e32);
%!assert(physical_constant("Planck time"), 5.39116e-44);
%!assert(physical_constant("Rydberg constant"), 10973731.568508);
%!assert(physical_constant("Rydberg constant times c in Hz"), 3.289841960355e15);
%!assert(physical_constant("Rydberg constant times hc in J"), 2.179872325e-18);
%!assert(physical_constant("Rydberg constant times hc in eV"), 13.605693009);
%!assert(physical_constant("Sackur-Tetrode constant (1 K, 100 kPa)"), -1.1517084);
%!assert(physical_constant("Sackur-Tetrode constant (1 K, 101.325 kPa)"), -1.1648714);
%!assert(physical_constant("Stefan-Boltzmann constant"), 5.670367e-8);
%!assert(physical_constant("Thomson cross section"), 0.66524587158e-28);
%!assert(physical_constant("Wien frequency displacement law constant"), 5.8789238e10);
%!assert(physical_constant("Wien wavelength displacement law constant"), 2.8977729e-3);
%!assert(physical_constant("alpha particle mass"), 6.644657230e-27);
%!assert(physical_constant("alpha particle mass energy equivalent"), 5.971920097e-10);
%!assert(physical_constant("alpha particle mass energy equivalent in MeV"), 3727.379378);
%!assert(physical_constant("alpha particle mass in u"), 4.001506179127);
%!assert(physical_constant("alpha particle molar mass"), 4.001506179127e-3);
%!assert(physical_constant("alpha particle-electron mass ratio"), 7294.29954136);
%!assert(physical_constant("alpha particle-proton mass ratio"), 3.97259968907);
%!assert(physical_constant("atomic mass constant"), 1.660539040e-27);
%!assert(physical_constant("atomic mass constant energy equivalent"), 1.492418062e-10);
%!assert(physical_constant("atomic mass constant energy equivalent in MeV"), 931.4940954);
%!assert(physical_constant("atomic mass unit-electron volt relationship"), 931.4940954e6);
%!assert(physical_constant("atomic mass unit-hartree relationship"), 3.4231776902e7);
%!assert(physical_constant("atomic mass unit-hertz relationship"), 2.2523427206e23);
%!assert(physical_constant("atomic mass unit-inverse meter relationship"), 7.5130066166e14);
%!assert(physical_constant("atomic mass unit-joule relationship"), 1.492418062e-10);
%!assert(physical_constant("atomic mass unit-kelvin relationship"), 1.08095438e13);
%!assert(physical_constant("atomic mass unit-kilogram relationship"), 1.660539040e-27);
%!assert(physical_constant("atomic unit of 1st hyperpolarizability"), 3.206361329e-53);
%!assert(physical_constant("atomic unit of 2nd hyperpolarizability"), 6.235380085e-65);
%!assert(physical_constant("atomic unit of action"), 1.054571800e-34);
%!assert(physical_constant("atomic unit of charge"), 1.6021766208e-19);
%!assert(physical_constant("atomic unit of charge density"), 1.0812023770e12);
%!assert(physical_constant("atomic unit of current"), 6.623618183e-3);
%!assert(physical_constant("atomic unit of electric dipole mom."), 8.478353552e-30);
%!assert(physical_constant("atomic unit of electric field"), 5.142206707e11);
%!assert(physical_constant("atomic unit of electric field gradient"), 9.717362356e21);
%!assert(physical_constant("atomic unit of electric polarizability"), 1.6487772731e-41);
%!assert(physical_constant("atomic unit of electric potential"), 27.21138602);
%!assert(physical_constant("atomic unit of electric quadrupole mom."), 4.486551484e-40);
%!assert(physical_constant("atomic unit of energy"), 4.359744650e-18);
%!assert(physical_constant("atomic unit of force"), 8.23872336e-8);
%!assert(physical_constant("atomic unit of length"), 0.52917721067e-10);
%!assert(physical_constant("atomic unit of mag. dipole mom."), 1.854801999e-23);
%!assert(physical_constant("atomic unit of mag. flux density"), 2.350517550e5);
%!assert(physical_constant("atomic unit of magnetizability"), 7.8910365886e-29);
%!assert(physical_constant("atomic unit of mass"), 9.10938356e-31);
%!assert(physical_constant("atomic unit of mom.um"), 1.992851882e-24);
%!assert(physical_constant("atomic unit of permittivity"), 1.112650056e-10);
%!assert(physical_constant("atomic unit of time"), 2.418884326509e-17);
%!assert(physical_constant("atomic unit of velocity"), 2.18769126277e6);
%!assert(physical_constant("characteristic impedance of vacuum"), 376.730313461);
%!assert(physical_constant("classical electron radius"), 2.8179403227e-15);
%!assert(physical_constant("conductance quantum"), 7.7480917310e-5);
%!assert(physical_constant("conventional value of Josephson constant"), 483597.9e9);
%!assert(physical_constant("conventional value of von Klitzing constant"), 25812.807);
%!assert(physical_constant("deuteron g factor"), 0.8574382311);
%!assert(physical_constant("deuteron mag. mom."), 0.4330735040e-26);
%!assert(physical_constant("deuteron mag. mom. to Bohr magneton ratio"), 0.4669754554e-3);
%!assert(physical_constant("deuteron mag. mom. to nuclear magneton ratio"), 0.8574382311);
%!assert(physical_constant("deuteron mass"), 3.343583719e-27);
%!assert(physical_constant("deuteron mass energy equivalent"), 3.005063183e-10);
%!assert(physical_constant("deuteron mass energy equivalent in MeV"), 1875.612928);
%!assert(physical_constant("deuteron mass in u"), 2.013553212745);
%!assert(physical_constant("deuteron molar mass"), 2.013553212745e-3);
%!assert(physical_constant("deuteron rms charge radius"), 2.1413e-15);
%!assert(physical_constant("deuteron-electron mag. mom. ratio"), -4.664345535e-4);
%!assert(physical_constant("deuteron-electron mass ratio"), 3670.48296785);
%!assert(physical_constant("deuteron-neutron mag. mom. ratio"), -0.44820652);
%!assert(physical_constant("deuteron-proton mag. mom. ratio"), 0.3070122077);
%!assert(physical_constant("deuteron-proton mass ratio"), 1.99900750087);
%!assert(physical_constant("electric constant"), 8.854187817e-12);
%!assert(physical_constant("electron charge to mass quotient"), -1.758820024e11);
%!assert(physical_constant("electron g factor"), -2.00231930436182);
%!assert(physical_constant("electron gyromag. ratio"), 1.760859644e11);
%!assert(physical_constant("electron gyromag. ratio over 2 pi"), 28024.95164);
%!assert(physical_constant("electron mag. mom."), -928.4764620e-26);
%!assert(physical_constant("electron mag. mom. anomaly"), 1.15965218091e-3);
%!assert(physical_constant("electron mag. mom. to Bohr magneton ratio"), -1.00115965218091);
%!assert(physical_constant("electron mag. mom. to nuclear magneton ratio"), -1838.28197234);
%!assert(physical_constant("electron mass"), 9.10938356e-31);
%!assert(physical_constant("electron mass energy equivalent"), 8.18710565e-14);
%!assert(physical_constant("electron mass energy equivalent in MeV"), 0.5109989461);
%!assert(physical_constant("electron mass in u"), 5.48579909070e-4);
%!assert(physical_constant("electron molar mass"), 5.48579909070e-7);
%!assert(physical_constant("electron to alpha particle mass ratio"), 1.370933554798e-4);
%!assert(physical_constant("electron to shielded helion mag. mom. ratio"), 864.058257);
%!assert(physical_constant("electron to shielded proton mag. mom. ratio"), -658.2275971);
%!assert(physical_constant("electron volt"), 1.6021766208e-19);
%!assert(physical_constant("electron volt-atomic mass unit relationship"), 1.0735441105e-9);
%!assert(physical_constant("electron volt-hartree relationship"), 3.674932248e-2);
%!assert(physical_constant("electron volt-hertz relationship"), 2.417989262e14);
%!assert(physical_constant("electron volt-inverse meter relationship"), 8.065544005e5);
%!assert(physical_constant("electron volt-joule relationship"), 1.6021766208e-19);
%!assert(physical_constant("electron volt-kelvin relationship"), 1.16045221e4);
%!assert(physical_constant("electron volt-kilogram relationship"), 1.782661907e-36);
%!assert(physical_constant("electron-deuteron mag. mom. ratio"), -2143.923499);
%!assert(physical_constant("electron-deuteron mass ratio"), 2.724437107484e-4);
%!assert(physical_constant("electron-helion mass ratio"), 1.819543074854e-4);
%!assert(physical_constant("electron-muon mag. mom. ratio"), 206.7669880);
%!assert(physical_constant("electron-muon mass ratio"), 4.83633170e-3);
%!assert(physical_constant("electron-neutron mag. mom. ratio"), 960.92050);
%!assert(physical_constant("electron-neutron mass ratio"), 5.4386734428e-4);
%!assert(physical_constant("electron-proton mag. mom. ratio"), -658.2106866);
%!assert(physical_constant("electron-proton mass ratio"), 5.44617021352e-4);
%!assert(physical_constant("electron-tau mass ratio"), 2.87592e-4);
%!assert(physical_constant("electron-triton mass ratio"), 1.819200062203e-4);
%!assert(physical_constant("elementary charge"), 1.6021766208e-19);
%!assert(physical_constant("elementary charge over h"), 2.417989262e14);
%!assert(physical_constant("fine-structure constant"), 7.2973525664e-3);
%!assert(physical_constant("first radiation constant"), 3.741771790e-16);
%!assert(physical_constant("first radiation constant for spectral radiance"), 1.191042953e-16);
%!assert(physical_constant("hartree-atomic mass unit relationship"), 2.9212623197e-8);
%!assert(physical_constant("hartree-electron volt relationship"), 27.21138602);
%!assert(physical_constant("hartree-hertz relationship"), 6.579683920711e15);
%!assert(physical_constant("hartree-inverse meter relationship"), 2.194746313702e7);
%!assert(physical_constant("hartree-joule relationship"), 4.359744650e-18);
%!assert(physical_constant("hartree-kelvin relationship"), 3.1577513e5);
%!assert(physical_constant("hartree-kilogram relationship"), 4.850870129e-35);
%!assert(physical_constant("helion g factor"), -4.255250616);
%!assert(physical_constant("helion mag. mom."), -1.074617522e-26);
%!assert(physical_constant("helion mag. mom. to Bohr magneton ratio"), -1.158740958e-3);
%!assert(physical_constant("helion mag. mom. to nuclear magneton ratio"), -2.127625308);
%!assert(physical_constant("helion mass"), 5.006412700e-27);
%!assert(physical_constant("helion mass energy equivalent"), 4.499539341e-10);
%!assert(physical_constant("helion mass energy equivalent in MeV"), 2808.391586);
%!assert(physical_constant("helion mass in u"), 3.01493224673);
%!assert(physical_constant("helion molar mass"), 3.01493224673e-3);
%!assert(physical_constant("helion-electron mass ratio"), 5495.88527922);
%!assert(physical_constant("helion-proton mass ratio"), 2.99315267046);
%!assert(physical_constant("hertz-atomic mass unit relationship"), 4.4398216616e-24);
%!assert(physical_constant("hertz-electron volt relationship"), 4.135667662e-15);
%!assert(physical_constant("hertz-hartree relationship"), 1.5198298460088e-16);
%!assert(physical_constant("hertz-inverse meter relationship"), 3.335640951e-9);
%!assert(physical_constant("hertz-joule relationship"), 6.626070040e-34);
%!assert(physical_constant("hertz-kelvin relationship"), 4.7992447e-11);
%!assert(physical_constant("hertz-kilogram relationship"), 7.372497201e-51);
%!assert(physical_constant("inverse fine-structure constant"), 137.035999139);
%!assert(physical_constant("inverse meter-atomic mass unit relationship"), 1.33102504900e-15);
%!assert(physical_constant("inverse meter-electron volt relationship"), 1.2398419739e-6);
%!assert(physical_constant("inverse meter-hartree relationship"), 4.556335252767e-8);
%!assert(physical_constant("inverse meter-hertz relationship"), 299792458);
%!assert(physical_constant("inverse meter-joule relationship"), 1.986445824e-25);
%!assert(physical_constant("inverse meter-kelvin relationship"), 1.43877736e-2);
%!assert(physical_constant("inverse meter-kilogram relationship"), 2.210219057e-42);
%!assert(physical_constant("inverse of conductance quantum"), 12906.4037278);
%!assert(physical_constant("joule-atomic mass unit relationship"), 6.700535363e9);
%!assert(physical_constant("joule-electron volt relationship"), 6.241509126e18);
%!assert(physical_constant("joule-hartree relationship"), 2.293712317e17);
%!assert(physical_constant("joule-hertz relationship"), 1.509190205e33);
%!assert(physical_constant("joule-inverse meter relationship"), 5.034116651e24);
%!assert(physical_constant("joule-kelvin relationship"), 7.2429731e22);
%!assert(physical_constant("joule-kilogram relationship"), 1.112650056e-17);
%!assert(physical_constant("kelvin-atomic mass unit relationship"), 9.2510842e-14);
%!assert(physical_constant("kelvin-electron volt relationship"), 8.6173303e-5);
%!assert(physical_constant("kelvin-hartree relationship"), 3.1668105e-6);
%!assert(physical_constant("kelvin-hertz relationship"), 2.0836612e10);
%!assert(physical_constant("kelvin-inverse meter relationship"), 69.503457);
%!assert(physical_constant("kelvin-joule relationship"), 1.38064852e-23);
%!assert(physical_constant("kelvin-kilogram relationship"), 1.53617865e-40);
%!assert(physical_constant("kilogram-atomic mass unit relationship"), 6.022140857e26);
%!assert(physical_constant("kilogram-electron volt relationship"), 5.609588650e35);
%!assert(physical_constant("kilogram-hartree relationship"), 2.061485823e34);
%!assert(physical_constant("kilogram-hertz relationship"), 1.356392512e50);
%!assert(physical_constant("kilogram-inverse meter relationship"), 4.524438411e41);
%!assert(physical_constant("kilogram-joule relationship"), 8.987551787e16);
%!assert(physical_constant("kilogram-kelvin relationship"), 6.5096595e39);
%!assert(physical_constant("lattice parameter of silicon"), 543.1020504e-12);
%!assert(physical_constant("mag. constant"), 12.566370614e-7);
%!assert(physical_constant("mag. flux quantum"), 2.067833831e-15);
%!assert(physical_constant("molar Planck constant"), 3.9903127110e-10);
%!assert(physical_constant("molar Planck constant times c"), 0.119626565582);
%!assert(physical_constant("molar gas constant"), 8.3144598);
%!assert(physical_constant("molar mass constant"), 1e-3);
%!assert(physical_constant("molar mass of carbon-12"), 12e-3);
%!assert(physical_constant("molar volume of ideal gas (273.15 K, 100 kPa)"), 22.710947e-3);
%!assert(physical_constant("molar volume of ideal gas (273.15 K, 101.325 kPa)"), 22.413962e-3);
%!assert(physical_constant("molar volume of silicon"), 12.05883214e-6);
%!assert(physical_constant("muon Compton wavelength"), 11.73444111e-15);
%!assert(physical_constant("muon Compton wavelength over 2 pi"), 1.867594308e-15);
%!assert(physical_constant("muon g factor"), -2.0023318418);
%!assert(physical_constant("muon mag. mom."), -4.49044826e-26);
%!assert(physical_constant("muon mag. mom. anomaly"), 1.16592089e-3);
%!assert(physical_constant("muon mag. mom. to Bohr magneton ratio"), -4.84197048e-3);
%!assert(physical_constant("muon mag. mom. to nuclear magneton ratio"), -8.89059705);
%!assert(physical_constant("muon mass"), 1.883531594e-28);
%!assert(physical_constant("muon mass energy equivalent"), 1.692833774e-11);
%!assert(physical_constant("muon mass energy equivalent in MeV"), 105.6583745);
%!assert(physical_constant("muon mass in u"), 0.1134289257);
%!assert(physical_constant("muon molar mass"), 0.1134289257e-3);
%!assert(physical_constant("muon-electron mass ratio"), 206.7682826);
%!assert(physical_constant("muon-neutron mass ratio"), 0.1124545167);
%!assert(physical_constant("muon-proton mag. mom. ratio"), -3.183345142);
%!assert(physical_constant("muon-proton mass ratio"), 0.1126095262);
%!assert(physical_constant("muon-tau mass ratio"), 5.94649e-2);
%!assert(physical_constant("natural unit of action"), 1.054571800e-34);
%!assert(physical_constant("natural unit of action in eV s"), 6.582119514e-16);
%!assert(physical_constant("natural unit of energy"), 8.18710565e-14);
%!assert(physical_constant("natural unit of energy in MeV"), 0.5109989461);
%!assert(physical_constant("natural unit of length"), 386.15926764e-15);
%!assert(physical_constant("natural unit of mass"), 9.10938356e-31);
%!assert(physical_constant("natural unit of mom.um"), 2.730924488e-22);
%!assert(physical_constant("natural unit of mom.um in MeV/c"), 0.5109989461);
%!assert(physical_constant("natural unit of time"), 1.28808866712e-21);
%!assert(physical_constant("natural unit of velocity"), 299792458);
%!assert(physical_constant("neutron Compton wavelength"), 1.31959090481e-15);
%!assert(physical_constant("neutron Compton wavelength over 2 pi"), 0.21001941536e-15);
%!assert(physical_constant("neutron g factor"), -3.82608545);
%!assert(physical_constant("neutron gyromag. ratio"), 1.83247172e8);
%!assert(physical_constant("neutron gyromag. ratio over 2 pi"), 29.1646933);
%!assert(physical_constant("neutron mag. mom."), -0.96623650e-26);
%!assert(physical_constant("neutron mag. mom. to Bohr magneton ratio"), -1.04187563e-3);
%!assert(physical_constant("neutron mag. mom. to nuclear magneton ratio"), -1.91304273);
%!assert(physical_constant("neutron mass"), 1.674927471e-27);
%!assert(physical_constant("neutron mass energy equivalent"), 1.505349739e-10);
%!assert(physical_constant("neutron mass energy equivalent in MeV"), 939.5654133);
%!assert(physical_constant("neutron mass in u"), 1.00866491588);
%!assert(physical_constant("neutron molar mass"), 1.00866491588e-3);
%!assert(physical_constant("neutron to shielded proton mag. mom. ratio"), -0.68499694);
%!assert(physical_constant("neutron-electron mag. mom. ratio"), 1.04066882e-3);
%!assert(physical_constant("neutron-electron mass ratio"), 1838.68366158);
%!assert(physical_constant("neutron-muon mass ratio"), 8.89248408);
%!assert(physical_constant("neutron-proton mag. mom. ratio"), -0.68497934);
%!assert(physical_constant("neutron-proton mass difference"), 2.30557377e-30);
%!assert(physical_constant("neutron-proton mass difference energy equivalent"), 2.07214637e-13);
%!assert(physical_constant("neutron-proton mass difference energy equivalent in MeV"), 1.29333205);
%!assert(physical_constant("neutron-proton mass difference in u"), 0.00138844900);
%!assert(physical_constant("neutron-proton mass ratio"), 1.00137841898);
%!assert(physical_constant("neutron-tau mass ratio"), 0.528790);
%!assert(physical_constant("nuclear magneton"), 5.050783699e-27);
%!assert(physical_constant("nuclear magneton in K/T"), 3.6582690e-4);
%!assert(physical_constant("nuclear magneton in MHz/T"), 7.622593285);
%!assert(physical_constant("nuclear magneton in eV/T"), 3.1524512550e-8);
%!assert(physical_constant("nuclear magneton in inverse meters per tesla"), 2.542623432e-2);
%!assert(physical_constant("proton Compton wavelength"), 1.32140985396e-15);
%!assert(physical_constant("proton Compton wavelength over 2 pi"), 0.210308910109e-15);
%!assert(physical_constant("proton charge to mass quotient"), 9.578833226e7);
%!assert(physical_constant("proton g factor"), 5.585694702);
%!assert(physical_constant("proton gyromag. ratio"), 2.675221900e8);
%!assert(physical_constant("proton gyromag. ratio over 2 pi"), 42.57747892);
%!assert(physical_constant("proton mag. mom."), 1.4106067873e-26);
%!assert(physical_constant("proton mag. mom. to Bohr magneton ratio"), 1.5210322053e-3);
%!assert(physical_constant("proton mag. mom. to nuclear magneton ratio"), 2.7928473508);
%!assert(physical_constant("proton mag. shielding correction"), 25.691e-6);
%!assert(physical_constant("proton mass"), 1.672621898e-27);
%!assert(physical_constant("proton mass energy equivalent"), 1.503277593e-10);
%!assert(physical_constant("proton mass energy equivalent in MeV"), 938.2720813);
%!assert(physical_constant("proton mass in u"), 1.007276466879);
%!assert(physical_constant("proton molar mass"), 1.007276466879e-3);
%!assert(physical_constant("proton rms charge radius"), 0.8751e-15);
%!assert(physical_constant("proton-electron mass ratio"), 1836.15267389);
%!assert(physical_constant("proton-muon mass ratio"), 8.88024338);
%!assert(physical_constant("proton-neutron mag. mom. ratio"), -1.45989805);
%!assert(physical_constant("proton-neutron mass ratio"), 0.99862347844);
%!assert(physical_constant("proton-tau mass ratio"), 0.528063);
%!assert(physical_constant("quantum of circulation"), 3.6369475486e-4);
%!assert(physical_constant("quantum of circulation times 2"), 7.2738950972e-4);
%!assert(physical_constant("second radiation constant"), 1.43877736e-2);
%!assert(physical_constant("shielded helion gyromag. ratio"), 2.037894585e8);
%!assert(physical_constant("shielded helion gyromag. ratio over 2 pi"), 32.43409966);
%!assert(physical_constant("shielded helion mag. mom."), -1.074553080e-26);
%!assert(physical_constant("shielded helion mag. mom. to Bohr magneton ratio"), -1.158671471e-3);
%!assert(physical_constant("shielded helion mag. mom. to nuclear magneton ratio"), -2.127497720);
%!assert(physical_constant("shielded helion to proton mag. mom. ratio"), -0.7617665603);
%!assert(physical_constant("shielded helion to shielded proton mag. mom. ratio"), -0.7617861313);
%!assert(physical_constant("shielded proton gyromag. ratio"), 2.675153171e8);
%!assert(physical_constant("shielded proton gyromag. ratio over 2 pi"), 42.57638507);
%!assert(physical_constant("shielded proton mag. mom."), 1.410570547e-26);
%!assert(physical_constant("shielded proton mag. mom. to Bohr magneton ratio"), 1.520993128e-3);
%!assert(physical_constant("shielded proton mag. mom. to nuclear magneton ratio"), 2.792775600);
%!assert(physical_constant("speed of light in vacuum"), 299792458);
%!assert(physical_constant("standard acceleration of gravity"), 9.80665);
%!assert(physical_constant("standard atmosphere"), 101325);
%!assert(physical_constant("standard-state pressure"), 100000);
%!assert(physical_constant("tau Compton wavelength"), 0.697787e-15);
%!assert(physical_constant("tau Compton wavelength over 2 pi"), 0.111056e-15);
%!assert(physical_constant("tau mass"), 3.16747e-27);
%!assert(physical_constant("tau mass energy equivalent"), 2.84678e-10);
%!assert(physical_constant("tau mass energy equivalent in MeV"), 1776.82);
%!assert(physical_constant("tau mass in u"), 1.90749);
%!assert(physical_constant("tau molar mass"), 1.90749e-3);
%!assert(physical_constant("tau-electron mass ratio"), 3477.15);
%!assert(physical_constant("tau-muon mass ratio"), 16.8167);
%!assert(physical_constant("tau-neutron mass ratio"), 1.89111);
%!assert(physical_constant("tau-proton mass ratio"), 1.89372);
%!assert(physical_constant("triton g factor"), 5.957924920);
%!assert(physical_constant("triton mag. mom."), 1.504609503e-26);
%!assert(physical_constant("triton mag. mom. to Bohr magneton ratio"), 1.6223936616e-3);
%!assert(physical_constant("triton mag. mom. to nuclear magneton ratio"), 2.978962460);
%!assert(physical_constant("triton mass"), 5.007356665e-27);
%!assert(physical_constant("triton mass energy equivalent"), 4.500387735e-10);
%!assert(physical_constant("triton mass energy equivalent in MeV"), 2808.921112);
%!assert(physical_constant("triton mass in u"), 3.01550071632);
%!assert(physical_constant("triton molar mass"), 3.01550071632e-3);
%!assert(physical_constant("triton-electron mass ratio"), 5496.92153588);
%!assert(physical_constant("triton-proton mass ratio"), 2.99371703348);
%!assert(physical_constant("unified atomic mass unit"), 1.660539040e-27);
%!assert(physical_constant("von Klitzing constant"), 25812.8074555);
%!assert(physical_constant("weak mixing angle"), 0.2223);
%!assert(physical_constant("{220} lattice spacing of silicon"), 192.0155714e-12);
