# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
OPENSUSE_RELEASES += 15.4

.PHONY: all
all:: opensuse-cloud-15.4.$(GARDEN_ARCH).qcow2 opensuse-cloud-15.4.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/opensuse/openSUSE-Leap-15.4.$(GARDEN_ARCH)-NoCloud.qcow2

$(GARDEN_DL_DIR)/opensuse/openSUSE-Leap-15.4.x86_64-NoCloud.qcow2 $(GARDEN_DL_DIR)/opensuse/openSUSE-Leap-15.4.aarch64-NoCloud.qcow2: $(GARDEN_DL_DIR)/opensuse/openSUSE-Leap-15.4.%-NoCloud.qcow2: | $(GARDEN_DL_DIR)/opensuse
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://download.opensuse.org/repositories/Cloud:/Images:/Leap_15.4/images/openSUSE-Leap-15.4.$*-NoCloud.qcow2)

$(GARDEN_DL_DIR)/opensuse/opensuse-cloud-15.4.x86_64.qcow2: | $(GARDEN_DL_DIR)/opensuse $(GARDEN_DL_DIR)/opensuse/openSUSE-Leap-15.4.x86_64-NoCloud.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/opensuse/opensuse-cloud-15.4.aarch64.qcow2: | $(GARDEN_DL_DIR)/opensuse $(GARDEN_DL_DIR)/opensuse/openSUSE-Leap-15.4.aarch64-NoCloud.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/opensuse/opensuse-cloud-15.4.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/opensuse/openSUSE-Leap-15.4.*-NoCloud.qcow2
