/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.0lf) => dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf)
 * mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.3333333333333333lf) => dvec4(-2.3333333333333335lf, -0.3333333333333335lf, 0.3333333333333335lf, 2.3333333333333335lf)
 * mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.6666666666666666lf) => dvec4(-2.666666666666667lf, 1.3333333333333333lf, -1.3333333333333333lf, 2.666666666666667lf)
 * mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 1.0lf) => dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf)
 */
#version 400

void main()
{
  double[distance(mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.0lf), dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf)) <= 4e-05lf ? 1 : -1] array0;
  double[distance(mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.3333333333333333lf), dvec4(-2.3333333333333335lf, -0.3333333333333335lf, 0.3333333333333335lf, 2.3333333333333335lf)) <= 3.3333333333333335e-05lf ? 1 : -1] array1;
  double[distance(mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 0.6666666666666666lf), dvec4(-2.666666666666667lf, 1.3333333333333333lf, -1.3333333333333333lf, 2.666666666666667lf)) <= 4.21637021355784e-05lf ? 1 : -1] array2;
  double[distance(mix(dvec4(-2.0lf, -2.0lf, 2.0lf, 2.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf), 1.0lf), dvec4(-3.0lf, 3.0lf, -3.0lf, 3.0lf)) <= 6.000000000000001e-05lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
