/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) / uvec3(36u, 32u, 88u)) => uvec3(1u, 1u, 1u)
 * (uvec3(36u, 32u, 88u) / uvec3(59u, 77u, 68u)) => uvec3(0u, 0u, 1u)
 * (uvec3(59u, 77u, 68u) / uvec3(36u, 32u, 88u)) => uvec3(1u, 2u, 0u)
 * (uvec3(59u, 77u, 68u) / uvec3(59u, 77u, 68u)) => uvec3(1u, 1u, 1u)
 */
#version 150

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) / uvec3(36u, 32u, 88u)), uvec3(1u, 1u, 1u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) / uvec3(59u, 77u, 68u)), uvec3(0u, 0u, 1u))) ? 1 : -1] array1;
  float[all(equal((uvec3(59u, 77u, 68u) / uvec3(36u, 32u, 88u)), uvec3(1u, 2u, 0u))) ? 1 : -1] array2;
  float[all(equal((uvec3(59u, 77u, 68u) / uvec3(59u, 77u, 68u)), uvec3(1u, 1u, 1u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
