/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) / 6u) => uvec3(6u, 5u, 14u)
 * (uvec3(36u, 32u, 88u) / 12u) => uvec3(3u, 2u, 7u)
 * (uvec3(36u, 32u, 88u) / 32u) => uvec3(1u, 1u, 2u)
 * (uvec3(36u, 32u, 88u) / 74u) => uvec3(0u, 0u, 1u)
 * (uvec3(59u, 77u, 68u) / 6u) => uvec3(9u, 12u, 11u)
 * (uvec3(59u, 77u, 68u) / 12u) => uvec3(4u, 6u, 5u)
 * (uvec3(59u, 77u, 68u) / 32u) => uvec3(1u, 2u, 2u)
 * (uvec3(59u, 77u, 68u) / 74u) => uvec3(0u, 1u, 0u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) / 6u), uvec3(6u, 5u, 14u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) / 12u), uvec3(3u, 2u, 7u))) ? 1 : -1] array1;
  float[all(equal((uvec3(36u, 32u, 88u) / 32u), uvec3(1u, 1u, 2u))) ? 1 : -1] array2;
  float[all(equal((uvec3(36u, 32u, 88u) / 74u), uvec3(0u, 0u, 1u))) ? 1 : -1] array3;
  float[all(equal((uvec3(59u, 77u, 68u) / 6u), uvec3(9u, 12u, 11u))) ? 1 : -1] array4;
  float[all(equal((uvec3(59u, 77u, 68u) / 12u), uvec3(4u, 6u, 5u))) ? 1 : -1] array5;
  float[all(equal((uvec3(59u, 77u, 68u) / 32u), uvec3(1u, 2u, 2u))) ? 1 : -1] array6;
  float[all(equal((uvec3(59u, 77u, 68u) / 74u), uvec3(0u, 1u, 0u))) ? 1 : -1] array7;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
