/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) & (- 12)) => ivec3(-44, 32, -96)
 * (ivec3(-36, 32, -88) & (- -6)) => ivec3(4, 0, 0)
 * (ivec3(-36, 32, -88) & (- 76)) => ivec3(-108, 32, -96)
 * (ivec3(-36, 32, -88) & (- -32)) => ivec3(0, 32, 32)
 * (ivec3(-36, 32, -88) & (- 0)) => ivec3(0, 0, 0)
 * (ivec3(36, 32, 88) & (- 12)) => ivec3(36, 32, 80)
 * (ivec3(36, 32, 88) & (- -6)) => ivec3(4, 0, 0)
 * (ivec3(36, 32, 88) & (- 76)) => ivec3(36, 32, 16)
 * (ivec3(36, 32, 88) & (- -32)) => ivec3(32, 32, 0)
 * (ivec3(36, 32, 88) & (- 0)) => ivec3(0, 0, 0)
 * (ivec3(59, 77, 68) & (- 12)) => ivec3(48, 68, 68)
 * (ivec3(59, 77, 68) & (- -6)) => ivec3(2, 4, 4)
 * (ivec3(59, 77, 68) & (- 76)) => ivec3(48, 4, 4)
 * (ivec3(59, 77, 68) & (- -32)) => ivec3(32, 0, 0)
 * (ivec3(59, 77, 68) & (- 0)) => ivec3(0, 0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec3(-36, 32, -88) & (- 12)), ivec3(-44, 32, -96))) ? 1 : -1] array0;
  float[all(equal((ivec3(-36, 32, -88) & (- -6)), ivec3(4, 0, 0))) ? 1 : -1] array1;
  float[all(equal((ivec3(-36, 32, -88) & (- 76)), ivec3(-108, 32, -96))) ? 1 : -1] array2;
  float[all(equal((ivec3(-36, 32, -88) & (- -32)), ivec3(0, 32, 32))) ? 1 : -1] array3;
  float[all(equal((ivec3(-36, 32, -88) & (- 0)), ivec3(0, 0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec3(36, 32, 88) & (- 12)), ivec3(36, 32, 80))) ? 1 : -1] array5;
  float[all(equal((ivec3(36, 32, 88) & (- -6)), ivec3(4, 0, 0))) ? 1 : -1] array6;
  float[all(equal((ivec3(36, 32, 88) & (- 76)), ivec3(36, 32, 16))) ? 1 : -1] array7;
  float[all(equal((ivec3(36, 32, 88) & (- -32)), ivec3(32, 32, 0))) ? 1 : -1] array8;
  float[all(equal((ivec3(36, 32, 88) & (- 0)), ivec3(0, 0, 0))) ? 1 : -1] array9;
  float[all(equal((ivec3(59, 77, 68) & (- 12)), ivec3(48, 68, 68))) ? 1 : -1] array10;
  float[all(equal((ivec3(59, 77, 68) & (- -6)), ivec3(2, 4, 4))) ? 1 : -1] array11;
  float[all(equal((ivec3(59, 77, 68) & (- 76)), ivec3(48, 4, 4))) ? 1 : -1] array12;
  float[all(equal((ivec3(59, 77, 68) & (- -32)), ivec3(32, 0, 0))) ? 1 : -1] array13;
  float[all(equal((ivec3(59, 77, 68) & (- 0)), ivec3(0, 0, 0))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
