/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * refract(vec2(-0.08304548, -0.99654573), vec2(-0.08304548, -0.99654573), 0.5) => vec2(0.08304548, 0.9965457)
 * refract(vec2(-0.08304548, -0.99654573), vec2(-0.08304548, -0.99654573), 2.0) => vec2(0.08304546, 0.99654543)
 * refract(vec2(-0.08304548, -0.99654573), vec2(-0.6585046, 0.7525767), 0.5) => vec2(0.34406582, -0.93894553)
 * refract(vec2(-0.08304548, -0.99654573), vec2(-0.6585046, 0.7525767), 2.0) => vec2(-0.0, -0.0)
 * refract(vec2(-0.6585046, 0.7525767), vec2(-0.08304548, -0.99654573), 0.5) => vec2(-0.28062487, 0.9598175)
 * refract(vec2(-0.6585046, 0.7525767), vec2(-0.08304548, -0.99654573), 2.0) => vec2(-0.0, 0.0)
 * refract(vec2(-0.6585046, 0.7525767), vec2(-0.6585046, 0.7525767), 0.5) => vec2(0.6585046, -0.7525767)
 * refract(vec2(-0.6585046, 0.7525767), vec2(-0.6585046, 0.7525767), 2.0) => vec2(0.65850466, -0.75257677)
 */
#version 120

void main()
{
  float[distance(refract(vec2(-0.08304548, -0.99654573), vec2(-0.08304548, -0.99654573), 0.5), vec2(0.08304548, 0.9965457)) <= 1e-05 ? 1 : -1] array0;
  float[distance(refract(vec2(-0.08304548, -0.99654573), vec2(-0.08304548, -0.99654573), 2.0), vec2(0.08304546, 0.99654543)) <= 9.999997e-06 ? 1 : -1] array1;
  float[distance(refract(vec2(-0.08304548, -0.99654573), vec2(-0.6585046, 0.7525767), 0.5), vec2(0.34406582, -0.93894553)) <= 1e-05 ? 1 : -1] array2;
  float[distance(refract(vec2(-0.08304548, -0.99654573), vec2(-0.6585046, 0.7525767), 2.0), vec2(-0.0, -0.0)) <= 0.0 ? 1 : -1] array3;
  float[distance(refract(vec2(-0.6585046, 0.7525767), vec2(-0.08304548, -0.99654573), 0.5), vec2(-0.28062487, 0.9598175)) <= 1e-05 ? 1 : -1] array4;
  float[distance(refract(vec2(-0.6585046, 0.7525767), vec2(-0.08304548, -0.99654573), 2.0), vec2(-0.0, 0.0)) <= 0.0 ? 1 : -1] array5;
  float[distance(refract(vec2(-0.6585046, 0.7525767), vec2(-0.6585046, 0.7525767), 0.5), vec2(0.6585046, -0.7525767)) <= 1.0000001e-05 ? 1 : -1] array6;
  float[distance(refract(vec2(-0.6585046, 0.7525767), vec2(-0.6585046, 0.7525767), 2.0), vec2(0.65850466, -0.75257677)) <= 1.0000002e-05 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
