/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (false ? 0.0 : 0.0) => 0.0
 * (false ? 0.0 : -1.33) => -1.33
 * (false ? 0.0 : 0.85) => 0.85
 * (false ? -1.33 : 0.0) => 0.0
 * (false ? -1.33 : -1.33) => -1.33
 * (false ? -1.33 : 0.85) => 0.85
 * (false ? 0.85 : 0.0) => 0.0
 * (false ? 0.85 : -1.33) => -1.33
 * (false ? 0.85 : 0.85) => 0.85
 * (true ? 0.0 : 0.0) => 0.0
 * (true ? 0.0 : -1.33) => 0.0
 * (true ? 0.0 : 0.85) => 0.0
 * (true ? -1.33 : 0.0) => -1.33
 * (true ? -1.33 : -1.33) => -1.33
 * (true ? -1.33 : 0.85) => -1.33
 * (true ? 0.85 : 0.0) => 0.85
 * (true ? 0.85 : -1.33) => 0.85
 * (true ? 0.85 : 0.85) => 0.85
 */
#version 120

void main()
{
  float[distance((false ? 0.0 : 0.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance((false ? 0.0 : -1.33), -1.33) <= 1.33e-05 ? 1 : -1] array1;
  float[distance((false ? 0.0 : 0.85), 0.85) <= 8.5e-06 ? 1 : -1] array2;
  float[distance((false ? -1.33 : 0.0), 0.0) <= 0.0 ? 1 : -1] array3;
  float[distance((false ? -1.33 : -1.33), -1.33) <= 1.33e-05 ? 1 : -1] array4;
  float[distance((false ? -1.33 : 0.85), 0.85) <= 8.5e-06 ? 1 : -1] array5;
  float[distance((false ? 0.85 : 0.0), 0.0) <= 0.0 ? 1 : -1] array6;
  float[distance((false ? 0.85 : -1.33), -1.33) <= 1.33e-05 ? 1 : -1] array7;
  float[distance((false ? 0.85 : 0.85), 0.85) <= 8.5e-06 ? 1 : -1] array8;
  float[distance((true ? 0.0 : 0.0), 0.0) <= 0.0 ? 1 : -1] array9;
  float[distance((true ? 0.0 : -1.33), 0.0) <= 0.0 ? 1 : -1] array10;
  float[distance((true ? 0.0 : 0.85), 0.0) <= 0.0 ? 1 : -1] array11;
  float[distance((true ? -1.33 : 0.0), -1.33) <= 1.33e-05 ? 1 : -1] array12;
  float[distance((true ? -1.33 : -1.33), -1.33) <= 1.33e-05 ? 1 : -1] array13;
  float[distance((true ? -1.33 : 0.85), -1.33) <= 1.33e-05 ? 1 : -1] array14;
  float[distance((true ? 0.85 : 0.0), 0.85) <= 8.5e-06 ? 1 : -1] array15;
  float[distance((true ? 0.85 : -1.33), 0.85) <= 8.5e-06 ? 1 : -1] array16;
  float[distance((true ? 0.85 : 0.85), 0.85) <= 8.5e-06 ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
