/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (vec4(-1.65, 1.33, 1.93, 0.76) / -1.33) => vec4(1.2406014, -1.0, -1.4511278, -0.57142854)
 * (vec4(-1.65, 1.33, 1.93, 0.76) / 0.85) => vec4(-1.9411764, 1.5647058, 2.2705882, 0.8941176)
 * (vec4(0.8, -0.15, -0.51, 0.0) / -1.33) => vec4(-0.60150373, 0.11278196, 0.3834586, -0.0)
 * (vec4(0.8, -0.15, -0.51, 0.0) / 0.85) => vec4(0.9411765, -0.1764706, -0.59999996, 0.0)
 */
#version 120

void main()
{
  float[distance((vec4(-1.65, 1.33, 1.93, 0.76) / -1.33), vec4(1.2406014, -1.0, -1.4511278, -0.57142854)) <= 2.2296623e-05 ? 1 : -1] array0;
  float[distance((vec4(-1.65, 1.33, 1.93, 0.76) / 0.85), vec4(-1.9411764, 1.5647058, 2.2705882, 0.8941176)) <= 3.4887657e-05 ? 1 : -1] array1;
  float[distance((vec4(0.8, -0.15, -0.51, 0.0) / -1.33), vec4(-0.60150373, 0.11278196, 0.3834586, -0.0)) <= 7.22196e-06 ? 1 : -1] array2;
  float[distance((vec4(0.8, -0.15, -0.51, 0.0) / 0.85), vec4(0.9411765, -0.1764706, -0.59999996, 0.0)) <= 1.1300243e-05 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
