/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l / i64vec2(-10l, -12l)) => i64vec2(0l, 0l)
 * (0l / i64vec2(-42l, 48l)) => i64vec2(0l, 0l)
 * (3l / i64vec2(-10l, -12l)) => i64vec2(0l, 0l)
 * (3l / i64vec2(-42l, 48l)) => i64vec2(0l, 0l)
 * (-1192l / i64vec2(-10l, -12l)) => i64vec2(119l, 99l)
 * (-1192l / i64vec2(-42l, 48l)) => i64vec2(28l, -24l)
 * (1048576l / i64vec2(-10l, -12l)) => i64vec2(-104857l, -87381l)
 * (1048576l / i64vec2(-42l, 48l)) => i64vec2(-24966l, 21845l)
 * (4251475l / i64vec2(-10l, -12l)) => i64vec2(-425147l, -354289l)
 * (4251475l / i64vec2(-42l, 48l)) => i64vec2(-101225l, 88572l)
 * (29852643761l / i64vec2(-10l, -12l)) => i64vec2(-2985264376l, -2487720313l)
 * (29852643761l / i64vec2(-42l, 48l)) => i64vec2(-710777232l, 621930078l)
 * (-4398046511104l / i64vec2(-10l, -12l)) => i64vec2(439804651110l, 366503875925l)
 * (-4398046511104l / i64vec2(-42l, 48l)) => i64vec2(104715393121l, -91625968981l)
 * (-3948976685146l / i64vec2(-10l, -12l)) => i64vec2(394897668514l, 329081390428l)
 * (-3948976685146l / i64vec2(-42l, 48l)) => i64vec2(94023254408l, -82270347607l)
 * (-135763469567146206l / i64vec2(-10l, -12l)) => i64vec2(13576346956714620l, 11313622463928850l)
 * (-135763469567146206l / i64vec2(-42l, 48l)) => i64vec2(3232463561122528l, -2828405615982212l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l / i64vec2(-10l, -12l)), i64vec2(0l, 0l))) ? 1 : -1] array0;
  float[all(equal((0l / i64vec2(-42l, 48l)), i64vec2(0l, 0l))) ? 1 : -1] array1;
  float[all(equal((3l / i64vec2(-10l, -12l)), i64vec2(0l, 0l))) ? 1 : -1] array2;
  float[all(equal((3l / i64vec2(-42l, 48l)), i64vec2(0l, 0l))) ? 1 : -1] array3;
  float[all(equal((-1192l / i64vec2(-10l, -12l)), i64vec2(119l, 99l))) ? 1 : -1] array4;
  float[all(equal((-1192l / i64vec2(-42l, 48l)), i64vec2(28l, -24l))) ? 1 : -1] array5;
  float[all(equal((1048576l / i64vec2(-10l, -12l)), i64vec2(-104857l, -87381l))) ? 1 : -1] array6;
  float[all(equal((1048576l / i64vec2(-42l, 48l)), i64vec2(-24966l, 21845l))) ? 1 : -1] array7;
  float[all(equal((4251475l / i64vec2(-10l, -12l)), i64vec2(-425147l, -354289l))) ? 1 : -1] array8;
  float[all(equal((4251475l / i64vec2(-42l, 48l)), i64vec2(-101225l, 88572l))) ? 1 : -1] array9;
  float[all(equal((29852643761l / i64vec2(-10l, -12l)), i64vec2(-2985264376l, -2487720313l))) ? 1 : -1] array10;
  float[all(equal((29852643761l / i64vec2(-42l, 48l)), i64vec2(-710777232l, 621930078l))) ? 1 : -1] array11;
  float[all(equal((-4398046511104l / i64vec2(-10l, -12l)), i64vec2(439804651110l, 366503875925l))) ? 1 : -1] array12;
  float[all(equal((-4398046511104l / i64vec2(-42l, 48l)), i64vec2(104715393121l, -91625968981l))) ? 1 : -1] array13;
  float[all(equal((-3948976685146l / i64vec2(-10l, -12l)), i64vec2(394897668514l, 329081390428l))) ? 1 : -1] array14;
  float[all(equal((-3948976685146l / i64vec2(-42l, 48l)), i64vec2(94023254408l, -82270347607l))) ? 1 : -1] array15;
  float[all(equal((-135763469567146206l / i64vec2(-10l, -12l)), i64vec2(13576346956714620l, 11313622463928850l))) ? 1 : -1] array16;
  float[all(equal((-135763469567146206l / i64vec2(-42l, 48l)), i64vec2(3232463561122528l, -2828405615982212l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
