/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) * 0.0lf) => dvec4(-0.0lf, 0.0lf, 0.0lf, 0.0lf)
 * (dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) * -1.3333333333333333lf) => dvec4(2.1999999999999997lf, -1.7733333333333334lf, -2.5733333333333333lf, -1.0133333333333332lf)
 * (dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) * 0.85lf) => dvec4(-1.4024999999999999lf, 1.1305lf, 1.6404999999999998lf, 0.646lf)
 * (dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) * 0.0lf) => dvec4(0.0lf, -0.0lf, -0.0lf, 0.0lf)
 * (dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) * -1.3333333333333333lf) => dvec4(-1.0666666666666667lf, 0.19999999999999998lf, 0.6799999999999999lf, -0.0lf)
 * (dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) * 0.85lf) => dvec4(0.68lf, -0.1275lf, -0.4335lf, 0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) * 0.0lf), dvec4(-0.0lf, 0.0lf, 0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array0;
  double[distance((dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) * -1.3333333333333333lf), dvec4(2.1999999999999997lf, -1.7733333333333334lf, -2.5733333333333333lf, -1.0133333333333332lf)) <= 3.953934749082235e-05lf ? 1 : -1] array1;
  double[distance((dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf) * 0.85lf), dvec4(-1.4024999999999999lf, 1.1305lf, 1.6404999999999998lf, 0.646lf)) <= 2.520633402539925e-05lf ? 1 : -1] array2;
  double[distance((dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) * 0.0lf), dvec4(0.0lf, -0.0lf, -0.0lf, 0.0lf)) <= 0.0lf ? 1 : -1] array3;
  double[distance((dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) * -1.3333333333333333lf), dvec4(-1.0666666666666667lf, 0.19999999999999998lf, 0.6799999999999999lf, -0.0lf)) <= 1.2806942561664662e-05lf ? 1 : -1] array4;
  double[distance((dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf) * 0.85lf), dvec4(0.68lf, -0.1275lf, -0.4335lf, 0.0lf)) <= 8.164425883061222e-06lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
