/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * min(-2.0lf, -2.0lf) => -2.0lf
 * min(-2.0lf, -0.6666666666666667lf) => -2.0lf
 * min(-2.0lf, 0.6666666666666665lf) => -2.0lf
 * min(-2.0lf, 2.0lf) => -2.0lf
 * min(-0.6666666666666667lf, -2.0lf) => -2.0lf
 * min(-0.6666666666666667lf, -0.6666666666666667lf) => -0.6666666666666667lf
 * min(-0.6666666666666667lf, 0.6666666666666665lf) => -0.6666666666666667lf
 * min(-0.6666666666666667lf, 2.0lf) => -0.6666666666666667lf
 * min(0.6666666666666665lf, -2.0lf) => -2.0lf
 * min(0.6666666666666665lf, -0.6666666666666667lf) => -0.6666666666666667lf
 * min(0.6666666666666665lf, 0.6666666666666665lf) => 0.6666666666666665lf
 * min(0.6666666666666665lf, 2.0lf) => 0.6666666666666665lf
 * min(2.0lf, -2.0lf) => -2.0lf
 * min(2.0lf, -0.6666666666666667lf) => -0.6666666666666667lf
 * min(2.0lf, 0.6666666666666665lf) => 0.6666666666666665lf
 * min(2.0lf, 2.0lf) => 2.0lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(min(-2.0lf, -2.0lf), -2.0lf) <= 2e-05lf ? 1 : -1] array0;
  double[distance(min(-2.0lf, -0.6666666666666667lf), -2.0lf) <= 2e-05lf ? 1 : -1] array1;
  double[distance(min(-2.0lf, 0.6666666666666665lf), -2.0lf) <= 2e-05lf ? 1 : -1] array2;
  double[distance(min(-2.0lf, 2.0lf), -2.0lf) <= 2e-05lf ? 1 : -1] array3;
  double[distance(min(-0.6666666666666667lf, -2.0lf), -2.0lf) <= 2e-05lf ? 1 : -1] array4;
  double[distance(min(-0.6666666666666667lf, -0.6666666666666667lf), -0.6666666666666667lf) <= 6.666666666666668e-06lf ? 1 : -1] array5;
  double[distance(min(-0.6666666666666667lf, 0.6666666666666665lf), -0.6666666666666667lf) <= 6.666666666666668e-06lf ? 1 : -1] array6;
  double[distance(min(-0.6666666666666667lf, 2.0lf), -0.6666666666666667lf) <= 6.666666666666668e-06lf ? 1 : -1] array7;
  double[distance(min(0.6666666666666665lf, -2.0lf), -2.0lf) <= 2e-05lf ? 1 : -1] array8;
  double[distance(min(0.6666666666666665lf, -0.6666666666666667lf), -0.6666666666666667lf) <= 6.666666666666668e-06lf ? 1 : -1] array9;
  double[distance(min(0.6666666666666665lf, 0.6666666666666665lf), 0.6666666666666665lf) <= 6.666666666666666e-06lf ? 1 : -1] array10;
  double[distance(min(0.6666666666666665lf, 2.0lf), 0.6666666666666665lf) <= 6.666666666666666e-06lf ? 1 : -1] array11;
  double[distance(min(2.0lf, -2.0lf), -2.0lf) <= 2e-05lf ? 1 : -1] array12;
  double[distance(min(2.0lf, -0.6666666666666667lf), -0.6666666666666667lf) <= 6.666666666666668e-06lf ? 1 : -1] array13;
  double[distance(min(2.0lf, 0.6666666666666665lf), 0.6666666666666665lf) <= 6.666666666666666e-06lf ? 1 : -1] array14;
  double[distance(min(2.0lf, 2.0lf), 2.0lf) <= 2e-05lf ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
