/**
 * Copyright 2013-2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 */

/*eslint-disable no-unused-vars */

'use strict';

var invariant = require('./invariant');

/**
 * Mimics empty from PHP.
 */
function isEmpty(obj) {
  !!(obj && obj[Symbol.iterator] && obj.size !== undefined) ? process.env.NODE_ENV !== 'production' ? invariant(false, 'isEmpty does not support Map or Set') : invariant(false) : undefined;

  if (Array.isArray(obj)) {
    return obj.length === 0;
  } else if (typeof obj === 'object') {
    for (var i in obj) {
      return false;
    }
    return true;
  } else {
    return !obj;
  }
}

module.exports = isEmpty;